/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverOneTimePasswordExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverOneTimePasswordExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DeliverOneTimePassword
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = -7414730592661321416L;
    private BooleanArgument promptForBindPassword = null;
    private DNArgument bindDN = null;
    private FileArgument bindPasswordFile = null;
    private StringArgument compactTextAfterOTP = null;
    private StringArgument compactTextBeforeOTP = null;
    private StringArgument deliveryMechanism = null;
    private StringArgument fullTextAfterOTP = null;
    private StringArgument fullTextBeforeOTP = null;
    private StringArgument messageSubject = null;
    private StringArgument userName = null;
    private StringArgument bindPassword = null;

    public static void main(String ... args) {
        ResultCode resultCode = DeliverOneTimePassword.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    public static ResultCode main(String[] args, OutputStream outStream, OutputStream errStream) {
        DeliverOneTimePassword tool = new DeliverOneTimePassword(outStream, errStream);
        return tool.runTool(args);
    }

    public DeliverOneTimePassword(OutputStream outStream, OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    public String getToolName() {
        return "deliver-one-time-password";
    }

    @Override
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_DELIVER_OTP_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "3.1.0";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.bindDN = new DNArgument(Character.valueOf('D'), "bindDN", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_DN.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_DN.get());
        parser.addArgument(this.bindDN);
        this.userName = new StringArgument(Character.valueOf('n'), "userName", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_USERNAME.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_USERNAME.get());
        parser.addArgument(this.userName);
        this.bindPassword = new StringArgument(Character.valueOf('w'), "bindPassword", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_PASSWORD.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW.get());
        parser.addArgument(this.bindPassword);
        this.bindPasswordFile = new FileArgument(Character.valueOf('j'), "bindPasswordFile", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_PATH.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
        parser.addArgument(this.bindPasswordFile);
        this.promptForBindPassword = new BooleanArgument(null, "promptForBindPassword", 1, UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW_PROMPT.get());
        parser.addArgument(this.promptForBindPassword);
        this.deliveryMechanism = new StringArgument(Character.valueOf('m'), "deliveryMechanism", false, 0, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_NAME.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_MECH.get());
        parser.addArgument(this.deliveryMechanism);
        this.messageSubject = new StringArgument(Character.valueOf('s'), "messageSubject", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_SUBJECT.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_SUBJECT.get());
        parser.addArgument(this.messageSubject);
        this.fullTextBeforeOTP = new StringArgument(Character.valueOf('f'), "fullTextBeforeOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_FULL_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_FULL_BEFORE.get());
        parser.addArgument(this.fullTextBeforeOTP);
        this.fullTextAfterOTP = new StringArgument(Character.valueOf('F'), "fullTextAfterOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_FULL_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_FULL_AFTER.get());
        parser.addArgument(this.fullTextAfterOTP);
        this.compactTextBeforeOTP = new StringArgument(Character.valueOf('c'), "compactTextBeforeOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_COMPACT_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_COMPACT_BEFORE.get());
        parser.addArgument(this.compactTextBeforeOTP);
        this.compactTextAfterOTP = new StringArgument(Character.valueOf('C'), "compactTextAfterOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_COMPACT_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_COMPACT_AFTER.get());
        parser.addArgument(this.compactTextAfterOTP);
        parser.addRequiredArgumentSet(this.bindDN, this.userName, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindDN, this.userName, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindPassword, this.bindPasswordFile, this.promptForBindPassword);
    }

    @Override
    protected boolean supportsAuthentication() {
        return false;
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCode doToolProcessing() {
        DeliverOneTimePasswordExtendedResult result;
        LDAPConnection conn;
        ArrayList<ObjectPair<String, String>> preferredDeliveryMechanisms;
        String pw;
        String authID = this.bindDN.isPresent() ? "dn:" + this.bindDN.getValue() : "u:" + this.userName.getValue();
        if (this.bindPassword.isPresent()) {
            pw = this.bindPassword.getValue();
        } else {
            if (this.bindPasswordFile.isPresent()) {
                try {
                    pw = this.bindPasswordFile.getNonBlankFileLines().get(0);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_READ_BIND_PW.get(StaticUtils.getExceptionMessage(e)));
                    return ResultCode.LOCAL_ERROR;
                }
            }
            try {
                this.getOut().print(UnboundIDDSMessages.INFO_DELIVER_OTP_ENTER_PW.get());
                pw = StaticUtils.toUTF8String(PasswordReader.readPassword());
                this.getOut().println();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_READ_BIND_PW.get(StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        if (this.deliveryMechanism.isPresent()) {
            List<String> dmList = this.deliveryMechanism.getValues();
            preferredDeliveryMechanisms = new ArrayList<ObjectPair<String, String>>(dmList.size());
            for (String s : dmList) {
                preferredDeliveryMechanisms.add(new ObjectPair<String, Object>(s, null));
            }
        } else {
            preferredDeliveryMechanisms = null;
        }
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_GET_CONNECTION.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            DeliverOneTimePasswordExtendedRequest request = new DeliverOneTimePasswordExtendedRequest(authID, pw, this.messageSubject.getValue(), this.fullTextBeforeOTP.getValue(), this.fullTextAfterOTP.getValue(), this.compactTextBeforeOTP.getValue(), this.compactTextAfterOTP.getValue(), preferredDeliveryMechanisms, new Control[0]);
            try {
                result = (DeliverOneTimePasswordExtendedResult)conn.processExtendedOperation(request);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_PROCESSING_EXTOP.get(StaticUtils.getExceptionMessage(le)));
                ResultCode resultCode = le.getResultCode();
                Object var11_14 = null;
                conn.close();
                return resultCode;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            conn.close();
            throw throwable;
        }
        if (result.getResultCode() == ResultCode.SUCCESS) {
            String mechanism = result.getDeliveryMechanism();
            String id = result.getRecipientID();
            if (id == null) {
                this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_RESULT_WITHOUT_ID.get(mechanism));
            } else {
                this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_RESULT_WITH_ID.get(mechanism, id));
            }
            String message = result.getDeliveryMessage();
            if (message != null) {
                this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_MESSAGE.get(message));
            }
        } else if (result.getDiagnosticMessage() == null) {
            this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_RESULT_NO_MESSAGE.get(String.valueOf(result.getResultCode())));
        } else {
            this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_RESULT.get(String.valueOf(result.getResultCode()), result.getDiagnosticMessage()));
        }
        ResultCode resultCode = result.getResultCode();
        Object var11_15 = null;
        conn.close();
        return resultCode;
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(2);
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=test.user,ou=People,dc=example,dc=com", "--bindPassword", "password", "--messageSubject", "Your one-time password", "--fullTextBeforeOTP", "Your one-time password is '", "--fullTextAfterOTP", "'.", "--compactTextBeforeOTP", "Your OTP is '", "--compactTextAfterOTP", "'."};
        exampleMap.put(args, UnboundIDDSMessages.INFO_DELIVER_OTP_EXAMPLE_1.get());
        args = new String[]{"--hostname", "server.example.com", "--port", "389", "--userName", "test.user", "--bindPassword", "password", "--deliveryMechanism", "SMS", "--deliveryMechanism", "E-Mail", "--messageSubject", "Your one-time password", "--fullTextBeforeOTP", "Your one-time password is '", "--fullTextAfterOTP", "'.", "--compactTextBeforeOTP", "Your OTP is '", "--compactTextAfterOTP", "'."};
        exampleMap.put(args, UnboundIDDSMessages.INFO_DELIVER_OTP_EXAMPLE_2.get());
        return exampleMap;
    }
}

