/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtree;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeListener;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.IgnoreNoUserModificationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class MoveSubtreeAccessibilitySearchListener
implements SearchResultListener {
    private static final long serialVersionUID = -2255331999271129548L;
    private final AtomicInteger entriesAddedToTarget;
    private final AtomicInteger entriesReadFromSource;
    private final AtomicReference<ResultCode> resultCode;
    private final Control[] addControls;
    private final LDAPConnection sourceConnection;
    private final LDAPConnection targetConnection;
    private final MoveSubtree tool;
    private final MoveSubtreeListener moveListener;
    private final String baseDN;
    private final StringBuilder errorMessage;
    private final TreeSet<DN> sourceEntryDNs;

    MoveSubtreeAccessibilitySearchListener(MoveSubtree tool, String baseDN, LDAPConnection sourceConnection, LDAPConnection targetConnection, AtomicReference<ResultCode> resultCode, StringBuilder errorMessage, AtomicInteger entriesReadFromSource, AtomicInteger entriesAddedToTarget, TreeSet<DN> sourceEntryDNs, OperationPurposeRequestControl opPurposeControl, MoveSubtreeListener moveListener) {
        this.tool = tool;
        this.baseDN = baseDN;
        this.sourceConnection = sourceConnection;
        this.targetConnection = targetConnection;
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.entriesReadFromSource = entriesReadFromSource;
        this.entriesAddedToTarget = entriesAddedToTarget;
        this.sourceEntryDNs = sourceEntryDNs;
        this.moveListener = moveListener;
        this.addControls = opPurposeControl == null ? new Control[]{new IgnoreNoUserModificationRequestControl()} : new Control[]{new IgnoreNoUserModificationRequestControl(), opPurposeControl};
    }

    @Override
    public void searchEntryReturned(SearchResultEntry searchEntry) {
        LDAPResult addResult;
        ReadOnlyEntry entry;
        this.entriesReadFromSource.incrementAndGet();
        try {
            this.sourceEntryDNs.add(searchEntry.getParsedDN());
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.resultCode.compareAndSet(null, le.getResultCode());
            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_CANNOT_PARSE_DN.get(searchEntry.getDN(), StaticUtils.getExceptionMessage(le)), this.errorMessage);
            return;
        }
        if (this.errorMessage.length() > 0) {
            return;
        }
        if (this.moveListener == null) {
            entry = searchEntry;
        } else {
            try {
                entry = this.moveListener.doPreAddProcessing(searchEntry);
                if (entry == null) {
                    return;
                }
                if (!DN.equals(entry.getDN(), searchEntry.getDN())) {
                    this.resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_PRE_ADD_DN_ALTERED.get(entry.getDN(), searchEntry.getDN()), this.errorMessage);
                    return;
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_PRE_ADD_FAILURE.get(searchEntry.getDN(), StaticUtils.getExceptionMessage(e)), this.errorMessage);
                return;
            }
        }
        try {
            addResult = this.targetConnection.add(new AddRequest(entry, this.addControls));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            addResult = le.toLDAPResult();
        }
        if (addResult.getResultCode() != ResultCode.SUCCESS) {
            this.resultCode.compareAndSet(null, addResult.getResultCode());
            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_ADD_FAILURE.get(searchEntry.getDN(), addResult.getDiagnosticMessage()), this.errorMessage);
            return;
        }
        this.entriesAddedToTarget.incrementAndGet();
        MoveSubtree.setInterruptMessage(this.tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_ENTRIES_ADDED_TO_TARGET.get(this.baseDN, this.targetConnection.getConnectedAddress(), this.targetConnection.getConnectedPort(), this.sourceConnection.getConnectedAddress(), this.sourceConnection.getConnectedPort()));
        if (this.moveListener != null) {
            try {
                this.moveListener.doPostAddProcessing(entry);
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_POST_ADD_FAILURE.get(searchEntry.getDN(), StaticUtils.getExceptionMessage(e)), this.errorMessage);
                return;
            }
        }
    }

    @Override
    public void searchReferenceReturned(SearchResultReference searchReference) {
        if (this.errorMessage.length() > 0) {
            return;
        }
        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ACC_LISTENER_REFERENCE_RETURNED.get(StaticUtils.concatenateStrings(searchReference.getReferralURLs())), this.errorMessage);
    }
}

