/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.unboundidds.SingleUseTOTPBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDeliveredOTPBindRequest;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.SASLMechanismInfo;
import com.unboundid.util.SASLOption;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SASLHelper {
    public static final String SASL_OPTION_OTP = "otp";
    public static final String SASL_OPTION_TOTP_PASSWORD = "totpPassword";

    private SASLHelper() {
    }

    @InternalUseOnly
    public static void addCESASLInfo(Map<String, SASLMechanismInfo> saslMap) {
        saslMap.put(StaticUtils.toLowerCase("UNBOUNDID-DELIVERED-OTP"), new SASLMechanismInfo("UNBOUNDID-DELIVERED-OTP", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_DESCRIPTION.get(), false, false, new SASLOption("authID", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption("authzID", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_OTP, UnboundIDDSMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_OPTION_OTP.get(), true, false)));
        saslMap.put(StaticUtils.toLowerCase("UNBOUNDID-TOTP"), new SASLMechanismInfo("UNBOUNDID-TOTP", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_DESCRIPTION.get(), true, false, new SASLOption("authID", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption("authzID", UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_TOTP_PASSWORD, UnboundIDDSMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_TOTP_PASSWORD.get(), true, false)));
    }

    @InternalUseOnly
    public static SASLBindRequest createBindRequest(String bindDN, byte[] password, String mechanism, Map<String, String> options, Control ... controls) throws LDAPException {
        if (mechanism.equalsIgnoreCase("UNBOUNDID-DELIVERED-OTP")) {
            return SASLHelper.createUNBOUNDIDDeliveredOTPBindRequest(password, options, controls);
        }
        if (mechanism.equalsIgnoreCase("UNBOUNDID-TOTP")) {
            return SASLHelper.createUNBOUNDIDTOTPBindRequest(password, options, controls);
        }
        return null;
    }

    private static UnboundIDDeliveredOTPBindRequest createUNBOUNDIDDeliveredOTPBindRequest(byte[] password, Map<String, String> options, Control ... controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("UNBOUNDID-DELIVERED-OTP"));
        }
        String authID = options.remove(StaticUtils.toLowerCase("authID"));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get("authID", "UNBOUNDID-DELIVERED-OTP"));
        }
        String otp = options.remove(StaticUtils.toLowerCase(SASL_OPTION_OTP));
        if (otp == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_OTP, "UNBOUNDID-DELIVERED-OTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase("authzID"));
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-DELIVERED-OTP");
        return new UnboundIDDeliveredOTPBindRequest(authID, authzID, otp, controls);
    }

    private static SingleUseTOTPBindRequest createUNBOUNDIDTOTPBindRequest(byte[] password, Map<String, String> options, Control ... controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase("authID"));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get("authID", "UNBOUNDID-TOTP"));
        }
        String totpPassword = options.remove(StaticUtils.toLowerCase(SASL_OPTION_TOTP_PASSWORD));
        if (totpPassword == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_TOTP_PASSWORD, "UNBOUNDID-TOTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase("authzID"));
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-TOTP");
        return new SingleUseTOTPBindRequest(authID, authzID, totpPassword, password, controls);
    }
}

