/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetBackendSetIDResponseControl
extends Control
implements DecodeableControl {
    public static final String GET_BACKEND_SET_ID_RESPONSE_OID = "1.3.6.1.4.1.30221.2.5.34";
    private static final long serialVersionUID = 117359364981309726L;
    private final Set<String> backendSetIDs;
    private final String entryBalancingRequestProcessorID;

    GetBackendSetIDResponseControl() {
        this.entryBalancingRequestProcessorID = null;
        this.backendSetIDs = null;
    }

    public GetBackendSetIDResponseControl(String entryBalancingRequestProcessorID, String backendSetID) {
        this(entryBalancingRequestProcessorID, Arrays.asList(backendSetID));
    }

    public GetBackendSetIDResponseControl(String entryBalancingRequestProcessorID, Collection<String> backendSetIDs) {
        super(GET_BACKEND_SET_ID_RESPONSE_OID, false, GetBackendSetIDResponseControl.encodeValue(entryBalancingRequestProcessorID, backendSetIDs));
        this.entryBalancingRequestProcessorID = entryBalancingRequestProcessorID;
        this.backendSetIDs = Collections.unmodifiableSet(new LinkedHashSet<String>(backendSetIDs));
    }

    public GetBackendSetIDResponseControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.entryBalancingRequestProcessorID = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            ASN1Element[] backendSetIDElements = ASN1Set.decodeAsSet(elements[1]).elements();
            LinkedHashSet<String> setIDs = new LinkedHashSet<String>(backendSetIDElements.length);
            for (ASN1Element e : backendSetIDElements) {
                setIDs.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
            }
            this.backendSetIDs = Collections.unmodifiableSet(setIDs);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_GET_BACKEND_SET_ID_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(String entryBalancingRequestProcessorID, Collection<String> backendSetIDs) {
        Validator.ensureNotNull(entryBalancingRequestProcessorID);
        Validator.ensureNotNull(backendSetIDs);
        Validator.ensureFalse(backendSetIDs.isEmpty());
        ArrayList<ASN1OctetString> backendSetIDElements = new ArrayList<ASN1OctetString>(backendSetIDs.size());
        for (String s : backendSetIDs) {
            backendSetIDElements.add(new ASN1OctetString(s));
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(entryBalancingRequestProcessorID), new ASN1Set(backendSetIDElements));
        return new ASN1OctetString(valueSequence.encode());
    }

    @Override
    public GetBackendSetIDResponseControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new GetBackendSetIDResponseControl(oid, isCritical, value);
    }

    public String getEntryBalancingRequestProcessorID() {
        return this.entryBalancingRequestProcessorID;
    }

    public Set<String> getBackendSetIDs() {
        return this.backendSetIDs;
    }

    public static GetBackendSetIDResponseControl get(LDAPResult result) throws LDAPException {
        Control c = result.getResponseControl(GET_BACKEND_SET_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetBackendSetIDResponseControl) {
            return (GetBackendSetIDResponseControl)c;
        }
        return new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public static GetBackendSetIDResponseControl get(SearchResultEntry entry) throws LDAPException {
        Control c = entry.getControl(GET_BACKEND_SET_ID_RESPONSE_OID);
        if (c == null) {
            return null;
        }
        if (c instanceof GetBackendSetIDResponseControl) {
            return (GetBackendSetIDResponseControl)c;
        }
        return new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue());
    }

    public static List<GetBackendSetIDResponseControl> get(ExtendedResult result) throws LDAPException {
        Control[] controls = result.getResponseControls();
        if (controls.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<GetBackendSetIDResponseControl> decodedControls = new ArrayList<GetBackendSetIDResponseControl>(controls.length);
        for (Control c : controls) {
            if (c instanceof GetBackendSetIDResponseControl) {
                decodedControls.add((GetBackendSetIDResponseControl)c);
                continue;
            }
            if (!c.getOID().equals(GET_BACKEND_SET_ID_RESPONSE_OID)) continue;
            decodedControls.add(new GetBackendSetIDResponseControl(c.getOID(), c.isCritical(), c.getValue()));
        }
        return Collections.unmodifiableList(decodedControls);
    }

    @Override
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_GET_BACKEND_SET_ID_RESPONSE.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GetBackendSetIDResponseControl(entryBalancingRequestProcessorID='");
        buffer.append(this.entryBalancingRequestProcessorID);
        buffer.append("', backendSetIDs={");
        Iterator<String> iterator = this.backendSetIDs.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("})");
    }
}

