/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class HardDeleteRequestControl
extends Control {
    public static final String HARD_DELETE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.22";
    private static final long serialVersionUID = 1169625153021056712L;

    public HardDeleteRequestControl() {
        this(false);
    }

    public HardDeleteRequestControl(boolean isCritical) {
        super(HARD_DELETE_REQUEST_OID, isCritical, null);
    }

    public HardDeleteRequestControl(Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            try {
                ASN1Sequence valueSequence = ASN1Sequence.decodeAsSequence(control.getValue().getValue());
                ASN1Element[] elements = valueSequence.elements();
                if (elements.length > 0) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_HARD_DELETE_REQUEST_UNSUPPORTED_VALUE_ELEMENT_TYPE.get(StaticUtils.toHex(elements[0].getType())));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_HARD_DELETE_REQUEST_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    public static DeleteRequest createHardDeleteRequest(String targetDN, boolean isCritical) {
        Control[] controls = new Control[]{new HardDeleteRequestControl(isCritical)};
        return new DeleteRequest(targetDN, controls);
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_HARD_DELETE_REQUEST.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("HardDeleteRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

