/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingEntryCountRequestControl
extends Control {
    public static final String MATCHING_ENTRY_COUNT_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.36";
    private static final byte TYPE_MAX_CANDIDATES_TO_EXAMINE = -128;
    private static final byte TYPE_ALWAYS_EXAMINE_CANDIDATES = -127;
    private static final byte TYPE_PROCESS_SEARCH_IF_UNINDEXED = -126;
    private static final byte TYPE_INCLUDE_DEBUG_INFO = -125;
    private static final long serialVersionUID = -6077150575658563941L;
    private final boolean alwaysExamineCandidates;
    private final boolean includeDebugInfo;
    private final boolean processSearchIfUnindexed;
    private final int maxCandidatesToExamine;

    public MatchingEntryCountRequestControl() {
        this(true, 0, false, false, false);
    }

    public MatchingEntryCountRequestControl(boolean isCritical, int maxCandidatesToExamine, boolean alwaysExamineCandidates, boolean processSearchIfUnindexed, boolean includeDebugInfo) {
        super(MATCHING_ENTRY_COUNT_REQUEST_OID, isCritical, MatchingEntryCountRequestControl.encodeValue(maxCandidatesToExamine, alwaysExamineCandidates, processSearchIfUnindexed, includeDebugInfo));
        Validator.ensureTrue(maxCandidatesToExamine >= 0);
        this.maxCandidatesToExamine = maxCandidatesToExamine;
        this.alwaysExamineCandidates = alwaysExamineCandidates;
        this.processSearchIfUnindexed = processSearchIfUnindexed;
        this.includeDebugInfo = includeDebugInfo;
    }

    public MatchingEntryCountRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_MISSING_VALUE.get());
        }
        try {
            ASN1Element[] elements;
            boolean alwaysExamine = false;
            boolean debug = false;
            boolean processUnindexed = false;
            int maxCandidates = 0;
            block9: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        maxCandidates = ASN1Integer.decodeAsInteger(e).intValue();
                        if (maxCandidates >= 0) continue block9;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_INVALID_MAX.get());
                    }
                    case -127: {
                        alwaysExamine = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -126: {
                        processUnindexed = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    case -125: {
                        debug = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.maxCandidatesToExamine = maxCandidates;
            this.alwaysExamineCandidates = alwaysExamine;
            this.processSearchIfUnindexed = processUnindexed;
            this.includeDebugInfo = debug;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_MATCHING_ENTRY_COUNT_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(int maxCandidatesToExamine, boolean alwaysExamineCandidates, boolean processSearchIfUnindexed, boolean includeDebugInfo) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        if (maxCandidatesToExamine > 0) {
            elements.add(new ASN1Integer(-128, maxCandidatesToExamine));
        }
        if (alwaysExamineCandidates) {
            elements.add(new ASN1Boolean(-127, true));
        }
        if (processSearchIfUnindexed) {
            elements.add(new ASN1Boolean(-126, true));
        }
        if (includeDebugInfo) {
            elements.add(new ASN1Boolean(-125, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public int getMaxCandidatesToExamine() {
        return this.maxCandidatesToExamine;
    }

    public boolean alwaysExamineCandidates() {
        return this.alwaysExamineCandidates;
    }

    public boolean processSearchIfUnindexed() {
        return this.processSearchIfUnindexed;
    }

    public boolean includeDebugInfo() {
        return this.includeDebugInfo;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_MATCHING_ENTRY_COUNT_REQUEST.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("MatchingEntryCountRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(", maxCandidatesToExamine=");
        buffer.append(this.maxCandidatesToExamine);
        buffer.append(", alwaysExamineCandidates=");
        buffer.append(this.alwaysExamineCandidates);
        buffer.append(", processSearchIfUnindexed=");
        buffer.append(this.processSearchIfUnindexed);
        buffer.append(", includeDebugInfo=");
        buffer.append(this.includeDebugInfo);
        buffer.append(')');
    }
}

