/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DeliverOneTimePasswordExtendedResult
extends ExtendedResult {
    public static final String DELIVER_OTP_RESULT_OID = "1.3.6.1.4.1.30221.2.6.25";
    private static final byte TYPE_MECH = -128;
    private static final byte TYPE_RECIPIENT_DN = -127;
    private static final byte TYPE_RECIPIENT_ID = -126;
    private static final byte TYPE_MESSAGE = -125;
    private static final long serialVersionUID = 5077693879184160485L;
    private final String deliveryMechanism;
    private final String deliveryMessage;
    private final String recipientDN;
    private final String recipientID;

    public DeliverOneTimePasswordExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.deliveryMechanism = null;
            this.recipientDN = null;
            this.recipientID = null;
            this.deliveryMessage = null;
            return;
        }
        String mech = null;
        String dn = null;
        String id = null;
        String message = null;
        try {
            block9: for (ASN1Element e : ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        mech = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -127: {
                        dn = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -126: {
                        id = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    case -125: {
                        message = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_RES_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_RES_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (mech == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_RES_NO_MECH.get());
        }
        this.deliveryMechanism = mech;
        if (dn == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_DELIVER_OTP_RES_NO_RECIPIENT_DN.get());
        }
        this.recipientDN = dn;
        this.recipientID = id;
        this.deliveryMessage = message;
    }

    public DeliverOneTimePasswordExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, String deliveryMechanism, String recipientDN, String recipientID, String deliveryMessage, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, deliveryMechanism == null ? null : DELIVER_OTP_RESULT_OID, DeliverOneTimePasswordExtendedResult.encodeValue(deliveryMechanism, recipientDN, recipientID, deliveryMessage), responseControls);
        this.deliveryMechanism = deliveryMechanism;
        this.recipientDN = recipientDN;
        this.recipientID = recipientID;
        this.deliveryMessage = deliveryMessage;
    }

    private static ASN1OctetString encodeValue(String deliveryMechanism, String recipientDN, String recipientID, String deliveryMessage) {
        if (deliveryMechanism == null) {
            Validator.ensureTrue(recipientID == null, "The delivery mechanism must be non-null if the recipient ID is non-null.");
            Validator.ensureTrue(deliveryMessage == null, "The delivery mechanism must be non-null if the delivery message is non-null.");
            return null;
        }
        Validator.ensureTrue(recipientDN != null, "If a delivery mechanism is provided, then a recipient DN must also be provided.");
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(4);
        elements.add(new ASN1OctetString(-128, deliveryMechanism));
        elements.add(new ASN1OctetString(-127, recipientDN));
        if (recipientID != null) {
            elements.add(new ASN1OctetString(-126, recipientID));
        }
        if (deliveryMessage != null) {
            elements.add(new ASN1OctetString(-125, deliveryMessage));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getDeliveryMechanism() {
        return this.deliveryMechanism;
    }

    public String getRecipientDN() {
        return this.recipientDN;
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public String getDeliveryMessage() {
        return this.deliveryMessage;
    }

    public String getExtendedResultName() {
        return ExtOpMessages.INFO_DELIVER_OTP_RES_NAME.get();
    }

    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("DeliverOneTimePasswordExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.deliveryMechanism != null) {
            buffer.append(", deliveryMechanism='");
            buffer.append(this.deliveryMechanism);
            buffer.append('\'');
        }
        if (this.recipientDN != null) {
            buffer.append(", recipientDN='");
            buffer.append(this.recipientDN);
            buffer.append('\'');
        }
        if (this.recipientID != null) {
            buffer.append(", recipientID='");
            buffer.append(this.recipientID);
            buffer.append('\'');
        }
        if (this.deliveryMessage != null) {
            buffer.append(", deliveryMessage='");
            buffer.append(this.deliveryMessage);
            buffer.append('\'');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

