/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetSupportedOTPDeliveryMechanismsExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetSupportedOTPDeliveryMechanismsExtendedRequest
extends ExtendedRequest {
    public static final String GET_SUPPORTED_OTP_DELIVERY_MECHANISMS_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.47";
    private static final byte TYPE_USER_DN = -128;
    private static final long serialVersionUID = -1670631089524097883L;
    private final String userDN;

    public GetSupportedOTPDeliveryMechanismsExtendedRequest(String userDN, Control ... controls) {
        super(GET_SUPPORTED_OTP_DELIVERY_MECHANISMS_REQUEST_OID, GetSupportedOTPDeliveryMechanismsExtendedRequest.encodeValue(userDN), controls);
        this.userDN = userDN;
    }

    public GetSupportedOTPDeliveryMechanismsExtendedRequest(ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUPPORTED_OTP_MECH_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.userDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUPPORTED_OTP_MECH_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(String userDN) {
        return new ASN1OctetString(new ASN1Sequence(new ASN1OctetString(-128, userDN)).encode());
    }

    public String getUserDN() {
        return this.userDN;
    }

    public GetSupportedOTPDeliveryMechanismsExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new GetSupportedOTPDeliveryMechanismsExtendedResult(extendedResponse);
    }

    public GetSupportedOTPDeliveryMechanismsExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public GetSupportedOTPDeliveryMechanismsExtendedRequest duplicate(Control[] controls) {
        GetSupportedOTPDeliveryMechanismsExtendedRequest r = new GetSupportedOTPDeliveryMechanismsExtendedRequest(this.userDN, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_GET_SUPPORTED_OTP_MECH_REQ_NAME.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("GetSupportedOTPDeliveryMechanismsExtendedRequest(userDN='");
        buffer.append(this.userDN);
        buffer.append('\'');
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

