/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StreamDirectoryValuesIntermediateResponse
extends IntermediateResponse {
    public static final String STREAM_DIRECTORY_VALUES_INTERMEDIATE_RESPONSE_OID = "1.3.6.1.4.1.30221.2.6.7";
    public static final int RESULT_ALL_VALUES_RETURNED = 0;
    public static final int RESULT_MORE_VALUES_TO_RETURN = 1;
    public static final int RESULT_ATTRIBUTE_NOT_INDEXED = 2;
    public static final int RESULT_PROCESSING_ERROR = 3;
    private static final byte TYPE_ATTRIBUTE_NAME = -128;
    private static final byte TYPE_RESULT = -127;
    private static final byte TYPE_DIAGNOSTIC_MESSAGE = -126;
    private static final byte TYPE_VALUES = -93;
    private static final long serialVersionUID = -1756020236490168006L;
    private final int result;
    private final List<ASN1OctetString> values;
    private final String attributeName;
    private final String diagnosticMessage;

    public StreamDirectoryValuesIntermediateResponse(String attributeName, int result, String diagnosticMessage, Collection<ASN1OctetString> values, Control ... controls) {
        super(STREAM_DIRECTORY_VALUES_INTERMEDIATE_RESPONSE_OID, StreamDirectoryValuesIntermediateResponse.encodeValue(attributeName, result, diagnosticMessage, values), controls);
        this.attributeName = attributeName;
        this.result = result;
        this.diagnosticMessage = diagnosticMessage;
        this.values = values == null || values.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<ASN1OctetString>(values));
    }

    public StreamDirectoryValuesIntermediateResponse(IntermediateResponse intermediateResponse) throws LDAPException {
        super(intermediateResponse);
        ASN1OctetString value = intermediateResponse.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_RESPONSE_NO_VALUE.get());
        }
        int tmpResult = -1;
        String tmpAttr = null;
        String tmpMessage = null;
        ArrayList<ASN1OctetString> tmpValues = new ArrayList<ASN1OctetString>();
        try {
            ASN1Element[] elements;
            block9: for (ASN1Element e : elements = ASN1Element.decode(value.getValue()).decodeAsSequence().elements()) {
                switch (e.getType()) {
                    case -128: {
                        tmpAttr = e.decodeAsOctetString().stringValue();
                        continue block9;
                    }
                    case -127: {
                        tmpResult = e.decodeAsEnumerated().intValue();
                        if (tmpResult >= 0) continue block9;
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_RESPONSE_INVALID_RESULT.get(tmpResult));
                    }
                    case -126: {
                        tmpMessage = e.decodeAsOctetString().stringValue();
                        continue block9;
                    }
                    case -93: {
                        ASN1Element[] valueElements;
                        for (ASN1Element ve : valueElements = e.decodeAsSet().elements()) {
                            tmpValues.add(ve.decodeAsOctetString());
                        }
                        continue block9;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_RESPONSE_INVALID_SEQUENCE_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_RESPONSE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (tmpResult < 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STREAM_DIRECTORY_VALUES_RESPONSE_NO_RESULT.get());
        }
        this.attributeName = tmpAttr;
        this.result = tmpResult;
        this.diagnosticMessage = tmpMessage;
        this.values = Collections.unmodifiableList(tmpValues);
    }

    private static ASN1OctetString encodeValue(String attributeName, int result, String diagnosticMessage, Collection<ASN1OctetString> values) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(4);
        if (attributeName != null) {
            elements.add(new ASN1OctetString(-128, attributeName));
        }
        elements.add(new ASN1Enumerated(-127, result));
        if (diagnosticMessage != null) {
            elements.add(new ASN1OctetString(-126, diagnosticMessage));
        }
        if (values != null && !values.isEmpty()) {
            elements.add(new ASN1Set(-93, values));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public int getResult() {
        return this.result;
    }

    public String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    public List<ASN1OctetString> getValues() {
        return this.values;
    }

    @Override
    public String getIntermediateResponseName() {
        return ExtOpMessages.INFO_INTERMEDIATE_RESPONSE_NAME_STREAM_DIRECTORY_VALUES.get();
    }

    @Override
    public String valueToString() {
        StringBuilder buffer = new StringBuilder();
        if (this.attributeName != null) {
            buffer.append("attributeName='");
            buffer.append(this.attributeName);
            buffer.append("' ");
        }
        buffer.append("result='");
        switch (this.result) {
            case 0: {
                buffer.append("all values returned");
                break;
            }
            case 2: {
                buffer.append("attribute not indexed");
                break;
            }
            case 1: {
                buffer.append("more values to return");
                break;
            }
            case 3: {
                buffer.append("processing error");
                break;
            }
            default: {
                buffer.append(this.result);
            }
        }
        buffer.append('\'');
        if (this.diagnosticMessage != null) {
            buffer.append(" diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        buffer.append(" valueCount='");
        buffer.append(this.values.size());
        buffer.append('\'');
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("StreamDirectoryValuesIntermediateResponse(");
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append("messageID=");
            buffer.append(messageID);
            buffer.append(", ");
        }
        if (this.attributeName != null) {
            buffer.append("attributeName='");
            buffer.append(this.attributeName);
            buffer.append("', ");
        }
        buffer.append("result=");
        buffer.append(this.result);
        if (this.diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(this.diagnosticMessage);
            buffer.append('\'');
        }
        buffer.append(", values={");
        Iterator<ASN1OctetString> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            buffer.append('\'');
            buffer.append(iterator.next().stringValue());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append("})");
    }
}

