/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogOperationType;
import com.unboundid.ldap.sdk.unboundidds.logs.BindRequestAuthenticationType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.OperationRequestAccessLogMessage;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotExtensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class BindRequestAccessLogMessage
extends OperationRequestAccessLogMessage {
    private static final long serialVersionUID = 8603928027823970L;
    private final BindRequestAuthenticationType authenticationType;
    private final String dn = this.getNamedValue("dn");
    private final String protocolVersion;
    private final String saslMechanismName = this.getNamedValue("saslMechanism");

    public BindRequestAccessLogMessage(String s) throws LogException {
        this(new LogMessage(s));
    }

    public BindRequestAccessLogMessage(LogMessage m) {
        super(m);
        this.protocolVersion = this.getNamedValue("version");
        BindRequestAuthenticationType authType = null;
        try {
            authType = BindRequestAuthenticationType.valueOf(this.getNamedValue("authType"));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.authenticationType = authType;
    }

    public final BindRequestAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public final String getDN() {
        return this.dn;
    }

    public final String getProtocolVersion() {
        return this.protocolVersion;
    }

    public final String getSASLMechanismName() {
        return this.saslMechanismName;
    }

    public final AccessLogOperationType getOperationType() {
        return AccessLogOperationType.BIND;
    }
}

