/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class EntryCacheMonitorEntry
extends MonitorEntry {
    static final String ENTRY_CACHE_MONITOR_OC = "ds-entry-cache-monitor-entry";
    private static final String ATTR_CURRENT_COUNT = "currentEntryCacheCount";
    private static final String ATTR_CURRENT_SIZE = "currentEntryCacheSize";
    private static final String ATTR_HIT_RATIO = "entryCacheHitRatio";
    private static final String ATTR_HITS = "entryCacheHits";
    private static final String ATTR_MAX_COUNT = "maxEntryCacheCount";
    private static final String ATTR_MAX_SIZE = "maxEntryCacheSize";
    private static final String ATTR_TRIES = "entryCacheTries";
    private static final long serialVersionUID = 2468261007112908567L;
    private final Double hitRatio;
    private final Long cacheHits = this.getLong("entryCacheHits");
    private final Long cacheMisses;
    private final Long cacheTries = this.getLong("entryCacheTries");
    private final Long currentCount;
    private final Long currentSize;
    private final Long maxCount;
    private final Long maxSize;

    public EntryCacheMonitorEntry(Entry entry) {
        super(entry);
        this.hitRatio = this.getDouble(ATTR_HIT_RATIO);
        this.currentCount = this.getLong(ATTR_CURRENT_COUNT);
        this.maxCount = this.getLong(ATTR_MAX_COUNT);
        this.currentSize = this.getLong(ATTR_CURRENT_SIZE);
        this.maxSize = this.getLong(ATTR_MAX_SIZE);
        this.cacheMisses = this.cacheHits == null || this.cacheTries == null ? null : Long.valueOf(this.cacheTries - this.cacheHits);
    }

    public Long getCacheTries() {
        return this.cacheTries;
    }

    public Long getCacheHits() {
        return this.cacheHits;
    }

    public Long getCacheMisses() {
        return this.cacheMisses;
    }

    public Double getCacheHitRatio() {
        return this.hitRatio;
    }

    public Long getCurrentCount() {
        return this.currentCount;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public Long getCurrentCacheSize() {
        return this.currentSize;
    }

    public Long getMaxCacheSize() {
        return this.maxSize;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_ENTRY_CACHE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_ENTRY_CACHE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.cacheTries != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_TRIES, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_TRIES.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_TRIES.get(), this.cacheTries);
        }
        if (this.cacheHits != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_HITS, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_HITS.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_HITS.get(), this.cacheHits);
        }
        if (this.cacheMisses != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, "entryCacheMisses", MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_MISSES.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_MISSES.get(), this.cacheMisses);
        }
        if (this.hitRatio != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_HIT_RATIO, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_HIT_RATIO.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_HIT_RATIO.get(), this.hitRatio);
        }
        if (this.currentCount != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_COUNT, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_CURRENT_COUNT.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_CURRENT_COUNT.get(), this.currentCount);
        }
        if (this.maxCount != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_COUNT, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_MAX_COUNT.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_MAX_COUNT.get(), this.maxCount);
        }
        if (this.currentSize != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_SIZE, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_CURRENT_SIZE.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_CURRENT_SIZE.get(), this.currentSize);
        }
        if (this.maxSize != null) {
            EntryCacheMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_SIZE, MonitorMessages.INFO_ENTRY_CACHE_DISPNAME_MAX_SIZE.get(), MonitorMessages.INFO_ENTRY_CACHE_DESC_MAX_SIZE.get(), this.maxSize);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

