/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AddSchemaFileTask
extends Task {
    static final String ADD_SCHEMA_FILE_TASK_CLASS = "com.unboundid.directory.server.tasks.AddSchemaFileTask";
    private static final String ATTR_SCHEMA_FILE = "ds-task-schema-file-name";
    private static final String OC_ADD_SCHEMA_FILE_TASK = "ds-task-add-schema-file";
    private static final TaskProperty PROPERTY_SCHEMA_FILE = new TaskProperty("ds-task-schema-file-name", TaskMessages.INFO_DISPLAY_NAME_SCHEMA_FILE.get(), TaskMessages.INFO_DESCRIPTION_SCHEMA_FILE.get(), String.class, true, true, false);
    private static final long serialVersionUID = -5430392768265418966L;
    private final List<String> schemaFileNames;

    public AddSchemaFileTask() {
        this.schemaFileNames = null;
    }

    public AddSchemaFileTask(String taskID, String schemaFileName) {
        this(taskID, Arrays.asList(schemaFileName), null, null, null, null, null);
        Validator.ensureNotNull(schemaFileName);
    }

    public AddSchemaFileTask(String taskID, List<String> schemaFileNames) {
        this(taskID, schemaFileNames, null, null, null, null, null);
    }

    public AddSchemaFileTask(String taskID, List<String> schemaFileNames, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, ADD_SCHEMA_FILE_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(schemaFileNames);
        Validator.ensureFalse(schemaFileNames.isEmpty(), "AddSchemaFileTask.schemaFileNames must not be empty.");
        this.schemaFileNames = Collections.unmodifiableList(schemaFileNames);
    }

    public AddSchemaFileTask(Entry entry) throws TaskException {
        super(entry);
        String[] fileNames = entry.getAttributeValues(ATTR_SCHEMA_FILE);
        if (fileNames == null || fileNames.length == 0) {
            throw new TaskException(TaskMessages.ERR_ADD_SCHEMA_FILE_TASK_NO_FILES.get(this.getTaskEntryDN()));
        }
        this.schemaFileNames = Collections.unmodifiableList(Arrays.asList(fileNames));
    }

    public AddSchemaFileTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(ADD_SCHEMA_FILE_TASK_CLASS, properties);
        String[] names = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (!attrName.equalsIgnoreCase(ATTR_SCHEMA_FILE)) continue;
            names = AddSchemaFileTask.parseStrings(p, values, names);
        }
        if (names == null) {
            throw new TaskException(TaskMessages.ERR_ADD_SCHEMA_FILE_TASK_NO_FILES.get(this.getTaskEntryDN()));
        }
        this.schemaFileNames = Collections.unmodifiableList(Arrays.asList(names));
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_ADD_SCHEMA_FILE.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_ADD_SCHEMA_FILE.get();
    }

    public List<String> getSchemaFileNames() {
        return this.schemaFileNames;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_ADD_SCHEMA_FILE_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        return Arrays.asList(new Attribute(ATTR_SCHEMA_FILE, this.schemaFileNames));
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_SCHEMA_FILE));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_SCHEMA_FILE, Collections.unmodifiableList(this.schemaFileNames));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

