/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AuditDataSecurityTask
extends Task {
    static final String AUDIT_DATA_SECURITY_TASK_CLASS = "com.unboundid.directory.server.tasks.AuditDataSecurityTask";
    private static final String ATTR_INCLUDE_AUDITOR = "ds-task-audit-data-security-include-auditor";
    private static final String ATTR_EXCLUDE_AUDITOR = "ds-task-audit-data-security-exclude-auditor";
    private static final String ATTR_BACKEND_ID = "ds-task-audit-data-security-backend-id";
    private static final String ATTR_REPORT_FILTER = "ds-task-audit-data-security-report-filter";
    private static final String ATTR_OUTPUT_DIRECTORY = "ds-task-audit-data-security-output-directory";
    private static final String OC_AUDIT_DATA_SECURITY_TASK = "ds-task-audit-data-security";
    private static final TaskProperty PROPERTY_INCLUDE_AUDITOR = new TaskProperty("ds-task-audit-data-security-include-auditor", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_INCLUDE_AUDITOR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_INCLUDE_AUDITOR.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_EXCLUDE_AUDITOR = new TaskProperty("ds-task-audit-data-security-exclude-auditor", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_EXCLUDE_AUDITOR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_EXCLUDE_AUDITOR.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-audit-data-security-backend-id", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_BACKEND_ID.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_REPORT_FILTER = new TaskProperty("ds-task-audit-data-security-report-filter", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_REPORT_FILTER.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_REPORT_FILTER.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_OUTPUT_DIRECTORY = new TaskProperty("ds-task-audit-data-security-output-directory", TaskMessages.INFO_AUDIT_DATA_SECURITY_DISPLAY_NAME_OUTPUT_DIR.get(), TaskMessages.INFO_AUDIT_DATA_SECURITY_DESCRIPTION_OUTPUT_DIR.get(), String.class, false, false, false);
    private static final long serialVersionUID = -4994621474763299632L;
    private final List<String> backendIDs;
    private final List<String> excludeAuditors;
    private final List<String> includeAuditors;
    private final List<String> reportFilters;
    private final String outputDirectory;

    public AuditDataSecurityTask() {
        this.excludeAuditors = null;
        this.includeAuditors = null;
        this.backendIDs = null;
        this.reportFilters = null;
        this.outputDirectory = null;
    }

    public AuditDataSecurityTask(List<String> includeAuditors, List<String> excludeAuditors, List<String> backendIDs, List<String> reportFilters, String outputDirectory) {
        this(null, includeAuditors, excludeAuditors, backendIDs, reportFilters, outputDirectory, null, null, null, null, null);
    }

    public AuditDataSecurityTask(String taskID, List<String> includeAuditors, List<String> excludeAuditors, List<String> backendIDs, List<String> reportFilters, String outputDirectory, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, AUDIT_DATA_SECURITY_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        this.includeAuditors = AuditDataSecurityTask.getStringList(includeAuditors);
        this.excludeAuditors = AuditDataSecurityTask.getStringList(excludeAuditors);
        this.backendIDs = AuditDataSecurityTask.getStringList(backendIDs);
        this.reportFilters = AuditDataSecurityTask.getStringList(reportFilters);
        this.outputDirectory = outputDirectory;
        Validator.ensureTrue(this.includeAuditors.isEmpty() || this.excludeAuditors.isEmpty(), "You cannot request both include and exclude auditors.");
    }

    public AuditDataSecurityTask(Entry entry) throws TaskException {
        super(entry);
        this.includeAuditors = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_INCLUDE_AUDITOR)));
        this.excludeAuditors = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_EXCLUDE_AUDITOR)));
        this.backendIDs = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_BACKEND_ID)));
        this.reportFilters = Collections.unmodifiableList(StaticUtils.toNonNullList(entry.getAttributeValues(ATTR_REPORT_FILTER)));
        this.outputDirectory = entry.getAttributeValue(ATTR_OUTPUT_DIRECTORY);
    }

    public AuditDataSecurityTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(AUDIT_DATA_SECURITY_TASK_CLASS, properties);
        String outputDir = null;
        LinkedList<String> includeAuditorsList = new LinkedList<String>();
        LinkedList<String> excludeAuditorsList = new LinkedList<String>();
        LinkedList<String> backendIDList = new LinkedList<String>();
        LinkedList<String> reportFilterList = new LinkedList<String>();
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            String[] s;
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_INCLUDE_AUDITOR)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                includeAuditorsList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_EXCLUDE_AUDITOR)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                excludeAuditorsList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_BACKEND_ID)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                backendIDList.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_REPORT_FILTER)) {
                s = AuditDataSecurityTask.parseStrings(p, values, null);
                if (s == null) continue;
                reportFilterList.addAll(Arrays.asList(s));
                continue;
            }
            if (!attrName.equals(ATTR_OUTPUT_DIRECTORY)) continue;
            outputDir = AuditDataSecurityTask.parseString(p, values, null);
        }
        this.includeAuditors = Collections.unmodifiableList(includeAuditorsList);
        this.excludeAuditors = Collections.unmodifiableList(excludeAuditorsList);
        this.backendIDs = Collections.unmodifiableList(backendIDList);
        this.reportFilters = Collections.unmodifiableList(reportFilterList);
        this.outputDirectory = outputDir;
        if (!this.includeAuditors.isEmpty() && !this.excludeAuditors.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_AUDIT_DATA_SECURITY_BOTH_INCLUDE_AND_EXCLUDE_AUDITORS.get());
        }
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_AUDIT_DATA_SECURITY.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_AUDIT_DATA_SECURITY.get();
    }

    public List<String> getIncludeAuditors() {
        return this.includeAuditors;
    }

    public List<String> getExcludeAuditors() {
        return this.excludeAuditors;
    }

    public List<String> getBackendIDs() {
        return this.backendIDs;
    }

    public List<String> getReportFilterStrings() {
        return this.reportFilters;
    }

    public List<Filter> getReportFilters() throws LDAPException {
        if (this.reportFilters.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Filter> filterList = new ArrayList<Filter>(this.reportFilters.size());
        for (String filter : this.reportFilters) {
            filterList.add(Filter.create(filter));
        }
        return Collections.unmodifiableList(filterList);
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_AUDIT_DATA_SECURITY_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        if (!this.includeAuditors.isEmpty()) {
            attrList.add(new Attribute(ATTR_INCLUDE_AUDITOR, this.includeAuditors));
        }
        if (!this.excludeAuditors.isEmpty()) {
            attrList.add(new Attribute(ATTR_EXCLUDE_AUDITOR, this.excludeAuditors));
        }
        if (!this.backendIDs.isEmpty()) {
            attrList.add(new Attribute(ATTR_BACKEND_ID, this.backendIDs));
        }
        if (!this.reportFilters.isEmpty()) {
            attrList.add(new Attribute(ATTR_REPORT_FILTER, this.reportFilters));
        }
        if (this.outputDirectory != null) {
            attrList.add(new Attribute(ATTR_OUTPUT_DIRECTORY, this.outputDirectory));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_INCLUDE_AUDITOR, PROPERTY_EXCLUDE_AUDITOR, PROPERTY_BACKEND_ID, PROPERTY_REPORT_FILTER, PROPERTY_OUTPUT_DIRECTORY));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<String>> props = new LinkedHashMap<TaskProperty, List<String>>(5);
        if (!this.includeAuditors.isEmpty()) {
            props.put(PROPERTY_INCLUDE_AUDITOR, Collections.unmodifiableList(this.includeAuditors));
        }
        if (!this.excludeAuditors.isEmpty()) {
            props.put(PROPERTY_EXCLUDE_AUDITOR, Collections.unmodifiableList(this.excludeAuditors));
        }
        if (!this.backendIDs.isEmpty()) {
            props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(this.backendIDs));
        }
        if (!this.reportFilters.isEmpty()) {
            props.put(PROPERTY_REPORT_FILTER, Collections.unmodifiableList(this.reportFilters));
        }
        if (this.outputDirectory != null) {
            props.put(PROPERTY_OUTPUT_DIRECTORY, Collections.unmodifiableList(Arrays.asList(this.outputDirectory)));
        }
        return Collections.unmodifiableMap(props);
    }

    private static List<String> getStringList(List<String> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }
}

