/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ExportTask
extends Task {
    static final String EXPORT_TASK_CLASS = "com.unboundid.directory.server.tasks.ExportTask";
    private static final String ATTR_APPEND_TO_LDIF = "ds-task-export-append-to-ldif";
    private static final String ATTR_BACKEND_ID = "ds-task-export-backend-id";
    private static final String ATTR_COMPRESS = "ds-task-export-compress-ldif";
    private static final String ATTR_ENCRYPT = "ds-task-export-encrypt-ldif";
    private static final String ATTR_EXCLUDE_ATTRIBUTE = "ds-task-export-exclude-attribute";
    private static final String ATTR_EXCLUDE_BRANCH = "ds-task-export-exclude-branch";
    private static final String ATTR_EXCLUDE_FILTER = "ds-task-export-exclude-filter";
    private static final String ATTR_INCLUDE_ATTRIBUTE = "ds-task-export-include-attribute";
    private static final String ATTR_INCLUDE_BRANCH = "ds-task-export-include-branch";
    private static final String ATTR_INCLUDE_FILTER = "ds-task-export-include-filter";
    private static final String ATTR_LDIF_FILE = "ds-task-export-ldif-file";
    private static final String ATTR_SIGN = "ds-task-export-sign-hash";
    private static final String ATTR_WRAP_COLUMN = "ds-task-export-wrap-column";
    private static final String OC_EXPORT_TASK = "ds-task-export";
    private static final TaskProperty PROPERTY_BACKEND_ID = new TaskProperty("ds-task-export-backend-id", TaskMessages.INFO_DISPLAY_NAME_BACKEND_ID.get(), TaskMessages.INFO_DESCRIPTION_BACKEND_ID_EXPORT.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_LDIF_FILE = new TaskProperty("ds-task-export-ldif-file", TaskMessages.INFO_DISPLAY_NAME_LDIF_FILE.get(), TaskMessages.INFO_DESCRIPTION_LDIF_FILE_EXPORT.get(), String.class, true, false, false);
    private static final TaskProperty PROPERTY_APPEND_TO_LDIF = new TaskProperty("ds-task-export-append-to-ldif", TaskMessages.INFO_DISPLAY_NAME_APPEND_TO_LDIF.get(), TaskMessages.INFO_DESCRIPTION_APPEND_TO_LDIF.get(), Boolean.class, false, false, true);
    private static final TaskProperty PROPERTY_INCLUDE_BRANCH = new TaskProperty("ds-task-export-include-branch", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_BRANCH_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_BRANCH = new TaskProperty("ds-task-export-exclude-branch", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_BRANCH.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_BRANCH_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_INCLUDE_FILTER = new TaskProperty("ds-task-export-include-filter", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_FILTER_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_FILTER = new TaskProperty("ds-task-export-exclude-filter", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_FILTER.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_FILTER_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_INCLUDE_ATTRIBUTE = new TaskProperty("ds-task-export-include-attribute", TaskMessages.INFO_DISPLAY_NAME_INCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_INCLUDE_ATTRIBUTE_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_EXCLUDE_ATTRIBUTE = new TaskProperty("ds-task-export-exclude-attribute", TaskMessages.INFO_DISPLAY_NAME_EXCLUDE_ATTRIBUTE.get(), TaskMessages.INFO_DESCRIPTION_EXCLUDE_ATTRIBUTE_EXPORT.get(), String.class, false, true, true);
    private static final TaskProperty PROPERTY_WRAP_COLUMN = new TaskProperty("ds-task-export-wrap-column", TaskMessages.INFO_DISPLAY_NAME_WRAP_COLUMN.get(), TaskMessages.INFO_DESCRIPTION_WRAP_COLUMN.get(), Long.class, false, false, true);
    private static final TaskProperty PROPERTY_COMPRESS = new TaskProperty("ds-task-export-compress-ldif", TaskMessages.INFO_DISPLAY_NAME_COMPRESS.get(), TaskMessages.INFO_DESCRIPTION_COMPRESS_EXPORT.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_ENCRYPT = new TaskProperty("ds-task-export-encrypt-ldif", TaskMessages.INFO_DISPLAY_NAME_ENCRYPT.get(), TaskMessages.INFO_DESCRIPTION_ENCRYPT_EXPORT.get(), Boolean.class, false, false, false);
    private static final TaskProperty PROPERTY_SIGN = new TaskProperty("ds-task-export-sign-hash", TaskMessages.INFO_DISPLAY_NAME_SIGN.get(), TaskMessages.INFO_DESCRIPTION_SIGN_EXPORT.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = 5489855404880345160L;
    private final boolean appendToLDIF;
    private final boolean compress;
    private final boolean encrypt;
    private final boolean sign;
    private final int wrapColumn;
    private final List<String> excludeAttributes;
    private final List<String> excludeBranches;
    private final List<String> excludeFilters;
    private final List<String> includeAttributes;
    private final List<String> includeBranches;
    private final List<String> includeFilters;
    private final String backendID;
    private final String ldifFile;

    public ExportTask() {
        this.appendToLDIF = false;
        this.compress = false;
        this.encrypt = false;
        this.sign = false;
        this.wrapColumn = -1;
        this.excludeAttributes = null;
        this.excludeBranches = null;
        this.excludeFilters = null;
        this.includeAttributes = null;
        this.includeBranches = null;
        this.includeFilters = null;
        this.backendID = null;
        this.ldifFile = null;
    }

    public ExportTask(String taskID, String backendID, String ldifFile) {
        this(taskID, backendID, ldifFile, false, null, null, null, null, null, null, -1, false, false, false, null, null, null, null, null);
    }

    public ExportTask(String taskID, String backendID, String ldifFile, boolean appendToLDIF, List<String> includeBranches, List<String> excludeBranches, List<String> includeFilters, List<String> excludeFilters, List<String> includeAttributes, List<String> excludeAttributes, int wrapColumn, boolean compress, boolean encrypt, boolean sign, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, EXPORT_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(backendID, ldifFile);
        this.backendID = backendID;
        this.ldifFile = ldifFile;
        this.appendToLDIF = appendToLDIF;
        this.wrapColumn = wrapColumn;
        this.compress = compress;
        this.encrypt = encrypt;
        this.sign = sign;
        this.includeBranches = includeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(includeBranches);
        this.excludeBranches = excludeBranches == null ? Collections.emptyList() : Collections.unmodifiableList(excludeBranches);
        this.includeFilters = includeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(includeFilters);
        this.excludeFilters = excludeFilters == null ? Collections.emptyList() : Collections.unmodifiableList(excludeFilters);
        this.includeAttributes = includeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(includeAttributes);
        this.excludeAttributes = excludeAttributes == null ? Collections.emptyList() : Collections.unmodifiableList(excludeAttributes);
    }

    public ExportTask(Entry entry) throws TaskException {
        super(entry);
        this.backendID = entry.getAttributeValue(ATTR_BACKEND_ID);
        if (this.backendID == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_BACKEND_ID.get(this.getTaskEntryDN()));
        }
        this.ldifFile = entry.getAttributeValue(ATTR_LDIF_FILE);
        if (this.ldifFile == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_LDIF_FILE.get(this.getTaskEntryDN()));
        }
        this.appendToLDIF = ExportTask.parseBooleanValue(entry, ATTR_APPEND_TO_LDIF, false);
        this.includeBranches = ExportTask.parseStringList(entry, ATTR_INCLUDE_BRANCH);
        this.excludeBranches = ExportTask.parseStringList(entry, ATTR_EXCLUDE_BRANCH);
        this.includeFilters = ExportTask.parseStringList(entry, ATTR_INCLUDE_FILTER);
        this.excludeFilters = ExportTask.parseStringList(entry, ATTR_EXCLUDE_FILTER);
        this.includeAttributes = ExportTask.parseStringList(entry, ATTR_INCLUDE_ATTRIBUTE);
        this.excludeAttributes = ExportTask.parseStringList(entry, ATTR_EXCLUDE_ATTRIBUTE);
        String wrapStr = entry.getAttributeValue(ATTR_WRAP_COLUMN);
        if (wrapStr == null) {
            this.wrapColumn = -1;
        } else {
            try {
                this.wrapColumn = Integer.parseInt(wrapStr);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new TaskException(TaskMessages.ERR_EXPORT_TASK_CANNOT_PARSE_WRAP_COLUMN.get(this.getTaskEntryDN(), wrapStr), e);
            }
        }
        this.compress = ExportTask.parseBooleanValue(entry, ATTR_COMPRESS, false);
        this.encrypt = ExportTask.parseBooleanValue(entry, ATTR_ENCRYPT, false);
        this.sign = ExportTask.parseBooleanValue(entry, ATTR_SIGN, false);
    }

    public ExportTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(EXPORT_TASK_CLASS, properties);
        boolean a = false;
        boolean c = false;
        boolean e = false;
        boolean s = false;
        long w = 0L;
        String b = null;
        String l = null;
        String[] eA = StaticUtils.NO_STRINGS;
        String[] eB = StaticUtils.NO_STRINGS;
        String[] eF = StaticUtils.NO_STRINGS;
        String[] iA = StaticUtils.NO_STRINGS;
        String[] iB = StaticUtils.NO_STRINGS;
        String[] iF = StaticUtils.NO_STRINGS;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_BACKEND_ID)) {
                b = ExportTask.parseString(p, values, b);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_LDIF_FILE)) {
                l = ExportTask.parseString(p, values, l);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_APPEND_TO_LDIF)) {
                a = ExportTask.parseBoolean(p, values, a);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_BRANCH)) {
                iB = ExportTask.parseStrings(p, values, iB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_BRANCH)) {
                eB = ExportTask.parseStrings(p, values, eB);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_FILTER)) {
                iF = ExportTask.parseStrings(p, values, iF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_FILTER)) {
                eF = ExportTask.parseStrings(p, values, eF);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_INCLUDE_ATTRIBUTE)) {
                iA = ExportTask.parseStrings(p, values, iA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_EXCLUDE_ATTRIBUTE)) {
                eA = ExportTask.parseStrings(p, values, eA);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_WRAP_COLUMN)) {
                w = ExportTask.parseLong(p, values, w);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_COMPRESS)) {
                c = ExportTask.parseBoolean(p, values, c);
                continue;
            }
            if (attrName.equalsIgnoreCase(ATTR_ENCRYPT)) {
                e = ExportTask.parseBoolean(p, values, e);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_SIGN)) continue;
            s = ExportTask.parseBoolean(p, values, s);
        }
        if (b == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_BACKEND_ID.get(this.getTaskEntryDN()));
        }
        if (l == null) {
            throw new TaskException(TaskMessages.ERR_EXPORT_TASK_NO_LDIF_FILE.get(this.getTaskEntryDN()));
        }
        this.backendID = b;
        this.ldifFile = l;
        this.appendToLDIF = a;
        this.includeAttributes = Collections.unmodifiableList(Arrays.asList(iA));
        this.excludeAttributes = Collections.unmodifiableList(Arrays.asList(eA));
        this.includeBranches = Collections.unmodifiableList(Arrays.asList(iB));
        this.excludeBranches = Collections.unmodifiableList(Arrays.asList(eB));
        this.includeFilters = Collections.unmodifiableList(Arrays.asList(iF));
        this.excludeFilters = Collections.unmodifiableList(Arrays.asList(eF));
        this.wrapColumn = (int)w;
        this.compress = c;
        this.encrypt = e;
        this.sign = s;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_EXPORT.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_EXPORT.get();
    }

    public String getBackendID() {
        return this.backendID;
    }

    public String getLDIFFile() {
        return this.ldifFile;
    }

    public boolean appendToLDIF() {
        return this.appendToLDIF;
    }

    public List<String> getIncludeBranches() {
        return this.includeBranches;
    }

    public List<String> getExcludeBranches() {
        return this.excludeBranches;
    }

    public List<String> getIncludeFilters() {
        return this.includeFilters;
    }

    public List<String> getExcludeFilters() {
        return this.excludeFilters;
    }

    public List<String> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public List<String> getExcludeAttributes() {
        return this.excludeAttributes;
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public boolean compress() {
        return this.compress;
    }

    public boolean encrypt() {
        return this.encrypt;
    }

    public boolean sign() {
        return this.sign;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_EXPORT_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(13);
        attrs.add(new Attribute(ATTR_BACKEND_ID, this.backendID));
        attrs.add(new Attribute(ATTR_LDIF_FILE, this.ldifFile));
        attrs.add(new Attribute(ATTR_APPEND_TO_LDIF, String.valueOf(this.appendToLDIF)));
        attrs.add(new Attribute(ATTR_COMPRESS, String.valueOf(this.compress)));
        attrs.add(new Attribute(ATTR_ENCRYPT, String.valueOf(this.encrypt)));
        attrs.add(new Attribute(ATTR_SIGN, String.valueOf(this.sign)));
        if (!this.includeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_BRANCH, this.includeBranches));
        }
        if (!this.excludeBranches.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_BRANCH, this.excludeBranches));
        }
        if (!this.includeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_ATTRIBUTE, this.includeAttributes));
        }
        if (!this.excludeAttributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_ATTRIBUTE, this.excludeAttributes));
        }
        if (!this.includeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_INCLUDE_FILTER, this.includeFilters));
        }
        if (!this.excludeFilters.isEmpty()) {
            attrs.add(new Attribute(ATTR_EXCLUDE_FILTER, this.excludeFilters));
        }
        if (this.wrapColumn > 0) {
            attrs.add(new Attribute(ATTR_WRAP_COLUMN, String.valueOf(this.wrapColumn)));
        }
        return attrs;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_BACKEND_ID, PROPERTY_LDIF_FILE, PROPERTY_APPEND_TO_LDIF, PROPERTY_INCLUDE_BRANCH, PROPERTY_EXCLUDE_BRANCH, PROPERTY_INCLUDE_FILTER, PROPERTY_EXCLUDE_FILTER, PROPERTY_INCLUDE_ATTRIBUTE, PROPERTY_EXCLUDE_ATTRIBUTE, PROPERTY_WRAP_COLUMN, PROPERTY_COMPRESS, PROPERTY_ENCRYPT, PROPERTY_SIGN);
        return Collections.unmodifiableList(propList);
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>();
        props.put(PROPERTY_BACKEND_ID, Collections.unmodifiableList(Arrays.asList(this.backendID)));
        props.put(PROPERTY_LDIF_FILE, Collections.unmodifiableList(Arrays.asList(this.ldifFile)));
        props.put(PROPERTY_APPEND_TO_LDIF, Collections.unmodifiableList(Arrays.asList(this.appendToLDIF)));
        props.put(PROPERTY_INCLUDE_BRANCH, Collections.unmodifiableList(this.includeBranches));
        props.put(PROPERTY_EXCLUDE_BRANCH, Collections.unmodifiableList(this.excludeBranches));
        props.put(PROPERTY_INCLUDE_FILTER, Collections.unmodifiableList(this.includeFilters));
        props.put(PROPERTY_EXCLUDE_FILTER, Collections.unmodifiableList(this.excludeFilters));
        props.put(PROPERTY_INCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.includeAttributes));
        props.put(PROPERTY_EXCLUDE_ATTRIBUTE, Collections.unmodifiableList(this.excludeAttributes));
        props.put(PROPERTY_WRAP_COLUMN, Collections.unmodifiableList(Arrays.asList(this.wrapColumn)));
        props.put(PROPERTY_COMPRESS, Collections.unmodifiableList(Arrays.asList(this.compress)));
        props.put(PROPERTY_ENCRYPT, Collections.unmodifiableList(Arrays.asList(this.encrypt)));
        props.put(PROPERTY_SIGN, Collections.unmodifiableList(Arrays.asList(this.sign)));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

