/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum FailedDependencyAction {
    PROCESS("process"),
    CANCEL("cancel"),
    DISABLE("disable");

    private final String name;

    private FailedDependencyAction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static FailedDependencyAction forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("process")) {
            return PROCESS;
        }
        if (lowerName.equals("cancel")) {
            return CANCEL;
        }
        if (lowerName.equals("disable")) {
            return DISABLE;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

