/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONArray
extends JSONValue {
    public static final JSONArray EMPTY_ARRAY = new JSONArray(new JSONValue[0]);
    private static final long serialVersionUID = -5493008945333225318L;
    private Integer hashCode;
    private final List<JSONValue> values;
    private String stringRepresentation;

    public JSONArray(JSONValue ... values) {
        this(values == null ? null : Arrays.asList(values));
    }

    public JSONArray(List<? extends JSONValue> values) {
        this.values = values == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<JSONValue>(values));
        this.hashCode = null;
        this.stringRepresentation = null;
    }

    public List<JSONValue> getValues() {
        return this.values;
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public int hashCode() {
        if (this.hashCode == null) {
            int hc = 0;
            for (JSONValue v : this.values) {
                hc = hc * 31 + v.hashCode();
            }
            this.hashCode = hc;
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            return ((Object)this.values).equals(a.values);
        }
        return false;
    }

    public boolean equals(JSONArray array, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        if (!(ignoreFieldNameCase || ignoreValueCase || ignoreArrayOrder)) {
            return ((Object)this.values).equals(array.values);
        }
        if (this.values.size() != array.values.size()) {
            return false;
        }
        if (!ignoreArrayOrder) {
            Iterator<JSONValue> thisIterator = this.values.iterator();
            Iterator<JSONValue> thatIterator = array.values.iterator();
            while (thisIterator.hasNext()) {
                JSONValue thatValue;
                JSONValue thisValue = thisIterator.next();
                if (thisValue.equals(thatValue = thatIterator.next(), ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                return false;
            }
            return true;
        }
        ArrayList<JSONValue> thatValues = new ArrayList<JSONValue>(array.values);
        for (JSONValue thisValue : this.values) {
            boolean found = false;
            Iterator<JSONValue> thatIterator = thatValues.iterator();
            while (thatIterator.hasNext()) {
                JSONValue thatValue = thatIterator.next();
                if (!thisValue.equals(thatValue, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) continue;
                found = true;
                thatIterator.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONArray && this.equals((JSONArray)v, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder);
    }

    public boolean contains(JSONValue value, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder, boolean recursive) {
        for (JSONValue v : this.values) {
            if (v.equals(value, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder)) {
                return true;
            }
            if (!recursive || !(v instanceof JSONArray) || !((JSONArray)v).contains(value, ignoreFieldNameCase, ignoreValueCase, ignoreArrayOrder, recursive)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    @Override
    public void toString(StringBuilder buffer) {
        if (this.stringRepresentation != null) {
            buffer.append(this.stringRepresentation);
            return;
        }
        buffer.append("[ ");
        Iterator<JSONValue> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            iterator.next().toString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append(']');
    }

    @Override
    public String toSingleLineString() {
        StringBuilder buffer = new StringBuilder();
        this.toSingleLineString(buffer);
        return buffer.toString();
    }

    @Override
    public void toSingleLineString(StringBuilder buffer) {
        buffer.append("[ ");
        Iterator<JSONValue> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            iterator.next().toSingleLineString(buffer);
            if (iterator.hasNext()) {
                buffer.append(',');
            }
            buffer.append(' ');
        }
        buffer.append(']');
    }

    @Override
    public String toNormalizedString() {
        StringBuilder buffer = new StringBuilder();
        this.toNormalizedString(buffer);
        return buffer.toString();
    }

    @Override
    public void toNormalizedString(StringBuilder buffer) {
        buffer.append('[');
        Iterator<JSONValue> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            iterator.next().toNormalizedString(buffer);
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append(']');
    }
}

