/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.crowdin;

import com.universalmediaserver.crowdin.AbstractCrowdinMojo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ApplyCrowdinMojo
extends AbstractCrowdinMojo {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.downloadFolder.exists()) throw new MojoExecutionException("Crowdin download folder (" + this.downloadFolder + ") does not exist. Call fetch first.");
        if (!this.languageFilesFolder.exists()) throw new MojoExecutionException("Language files folder (" + this.languageFilesFolder + ") does not exist.");
        this.getLog().info((CharSequence)"Applying all translation files");
        File[] folderEntries = this.downloadFolder.listFiles();
        if (folderEntries != null) {
            this.getLog().debug((CharSequence)("Checking folder " + this.downloadFolder.getAbsolutePath()));
            for (File entry : folderEntries) {
                if (entry.getName().startsWith(".")) continue;
                if (entry.isDirectory()) {
                    this.getLog().debug((CharSequence)("Checking subfolder " + entry.getName()));
                    File[] entryFiles = entry.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isFile() && !pathname.getName().startsWith(".") && pathname.getName().toLowerCase(Locale.US).endsWith(".properties");
                        }
                    });
                    if (entryFiles != null) {
                        for (File file : entryFiles) {
                            this.getLog().info((CharSequence)("Copying file " + file.getName() + " to " + this.languageFilesFolder.getAbsolutePath()));
                            try {
                                this.copyFile(file, new File(this.languageFilesFolder, file.getName()), true);
                            }
                            catch (IOException e) {
                                throw new MojoExecutionException("Error copying file " + file.getName(), (Exception)e);
                            }
                        }
                        continue;
                    }
                    this.getLog().debug((CharSequence)("Subfolder " + entry.getName() + " is empty"));
                    continue;
                }
                if (entry.getName().equals(this.statusFile.getName())) {
                    this.getLog().info((CharSequence)("Copying file " + entry.getName() + " to " + this.statusFile.getParent()));
                    try {
                        this.copyFile(entry, this.statusFile, true);
                        continue;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error copying file " + entry.getName(), (Exception)e);
                    }
                }
                this.getLog().warn((CharSequence)("Unexpected file (" + entry.getAbsolutePath() + ") encountered, skipping"));
            }
            return;
        }
        this.getLog().warn((CharSequence)"No files found for application");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destinationFile, boolean overwrite) throws IOException {
        if (!overwrite && destinationFile.exists()) {
            throw new IOException("File \"" + destinationFile.getAbsolutePath() + "\" already exists");
        }
        FileOutputStream destination = null;
        try (FileInputStream source = new FileInputStream(sourceFile);){
            destination = new FileOutputStream(destinationFile);
            try {
                long size = source.getChannel().size();
                for (long count = 0L; count < size; count += destination.getChannel().transferFrom(source.getChannel(), count, size - count)) {
                }
            }
            finally {
                destination.close();
            }
        }
    }
}

