/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.crowdin;

import com.universalmediaserver.crowdin.AbstractCrowdinMojo;
import com.universalmediaserver.crowdin.tool.CodeConversion;
import com.universalmediaserver.crowdin.tool.SortedProperties;
import com.universalmediaserver.crowdin.tool.SpecialArtifact;
import com.universalmediaserver.crowdin.tool.TranslationFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.apache.maven.shared.dependency.tree.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdom.Document;
import org.jdom.Element;

public class FetchCrowdinMojo
extends AbstractCrowdinMojo {
    public static final String COMMENT = "This file is automatically generated. Please do not edit this file. If you'd like to change the content please use crowdin.";
    protected DependencyTreeBuilder treeBuilder;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactCollector artifactCollector;

    protected void setTreeBuilder(DependencyTreeBuilder value) {
        this.treeBuilder = value;
    }

    protected void setLocalRepository(ArtifactRepository value) {
        this.localRepository = value;
    }

    protected void setArtifactFactory(ArtifactFactory value) {
        this.artifactFactory = value;
    }

    protected void setArtifactMetadataSource(ArtifactMetadataSource value) {
        this.artifactMetadataSource = value;
    }

    protected void setArtifactCollector(ArtifactCollector value) {
        this.artifactCollector = value;
    }

    private void cleanFolders(Set<TranslationFile> translationFiles) {
        File[] languageFolders;
        if (this.downloadFolder.exists() && (languageFolders = this.downloadFolder.listFiles()) != null) {
            for (File languageFolder : languageFolders) {
                if (languageFolder.getName().startsWith(".") || !languageFolder.isDirectory()) continue;
                if (!this.containsLanguage(translationFiles, languageFolder.getName())) {
                    this.deleteFolder(languageFolder, true);
                    continue;
                }
                this.cleanLanguageFolder(languageFolder, translationFiles);
            }
        }
    }

    private void cleanLanguageFolder(File languageFolder, Set<TranslationFile> translationFiles) {
        File[] entries = languageFolder.listFiles();
        if (entries != null) {
            for (File entry : entries) {
                if (entry.getName().startsWith(".")) continue;
                if (entry.isDirectory()) {
                    if (!this.containsMavenId(translationFiles, entry.getName())) {
                        this.deleteFolder(entry, true);
                        continue;
                    }
                    this.deleteFolder(entry, false);
                    continue;
                }
                if (this.isLanguageFile(translationFiles, entry)) continue;
                if (entry.delete() && this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Deleted " + entry));
                    continue;
                }
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Failed to delete " + entry));
            }
        }
    }

    private boolean containsLanguage(Set<TranslationFile> translationFiles, String language) {
        for (TranslationFile translationFile : translationFiles) {
            if (!translationFile.getLanguage().equals(language)) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguageFile(Set<TranslationFile> translationFiles, File file) {
        for (TranslationFile translationFile : translationFiles) {
            if (!translationFile.getName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean containsMavenId(Set<TranslationFile> translationFiles, String mavenId) {
        for (TranslationFile translationFile : translationFiles) {
            if (!translationFile.getMavenId().equals(mavenId)) continue;
            return true;
        }
        return false;
    }

    private boolean deleteFolder(File folder, boolean deleteRoot) {
        File[] listFiles = folder.listFiles();
        if (listFiles != null) {
            for (File file : listFiles) {
                if (file.getName().startsWith(".") && !deleteRoot) continue;
                if (file.isDirectory()) {
                    this.deleteFolder(file, true);
                }
                if (!file.delete()) {
                    return false;
                }
                this.getLog().debug((CharSequence)("Deleted " + file));
            }
        }
        if (deleteRoot) {
            boolean deleted = folder.delete();
            this.getLog().debug((CharSequence)("Deleted " + folder));
            return deleted;
        }
        return true;
    }

    private Map<TranslationFile, byte[]> downloadTranslations(String branch) throws MojoExecutionException {
        try {
            String uri = "http://api.crowdin.net/api/project/" + this.authenticationInfo.getUserName() + "/download/all.zip?" + (branch != null ? "branch=" + branch + "&" : "") + "key=";
            this.getLog().debug((CharSequence)("Calling " + uri + "<API key>"));
            uri = uri + this.authenticationInfo.getPassword();
            HttpGet getMethod = new HttpGet(uri);
            HttpResponse response = this.client.execute((HttpUriRequest)getMethod);
            int returnCode = response.getStatusLine().getStatusCode();
            this.getLog().debug((CharSequence)("Return code : " + returnCode));
            if (returnCode == 200) {
                HashMap<TranslationFile, byte[]> translations = new HashMap<TranslationFile, byte[]>();
                InputStream responseBodyAsStream = response.getEntity().getContent();
                try (ZipInputStream zis = new ZipInputStream(responseBodyAsStream);){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (entry.isDirectory()) continue;
                        String name = entry.getName();
                        this.getLog().debug((CharSequence)("Processing " + name));
                        int slash = name.indexOf(47);
                        String language = name.substring(0, slash);
                        name = name.substring(slash + 1);
                        slash = name.indexOf(47);
                        String mavenId = null;
                        if (slash > 0) {
                            mavenId = name.substring(0, slash);
                            name = name.substring(slash + 1);
                        }
                        if (name.matches("messages_.*\\.properties")) {
                            name = "messages_" + CodeConversion.crowdinCodeToFileTag(language) + ".properties";
                        }
                        TranslationFile translationFile = new TranslationFile(CodeConversion.crowdinCodeToLanguageTag(language), mavenId, name);
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        while (zis.available() > 0) {
                            int read = zis.read();
                            if (read == -1) continue;
                            bos.write(read);
                        }
                        bos.close();
                        translations.put(translationFile, bos.toByteArray());
                    }
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return translations;
            }
            if (returnCode == 404) {
                throw new MojoExecutionException("Could not find any files in branch \"" + (branch != null ? branch : this.rootBranch) + "\" on crowdin");
            }
            throw new MojoExecutionException("Failed to get translations from crowdin with return code " + Integer.toString(returnCode));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to call API", (Exception)e);
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        String branch = this.getBranch();
        this.getLog().info((CharSequence)"Downloading translations from crowdin");
        Map<TranslationFile, byte[]> translations = this.downloadTranslations(branch);
        if (this.localRepository != null) {
            Set<Artifact> dependencyArtifacts = this.getAllDependencies();
            HashSet<String> mavenIds = new HashSet<String>();
            for (Artifact artifact : dependencyArtifacts) {
                String mavenId = this.getMavenId(artifact);
                mavenIds.add(mavenId);
            }
            HashMap<TranslationFile, byte[]> usedTranslations = new HashMap<TranslationFile, byte[]>();
            usedTranslations.putAll(translations);
            for (TranslationFile translationFile : translations.keySet()) {
                if (translationFile.getMavenId() == null) {
                    this.getLog().debug((CharSequence)(translationFile.getName() + " is a root project file"));
                    continue;
                }
                if (!mavenIds.contains(translationFile.getMavenId())) {
                    this.getLog().debug((CharSequence)(translationFile.getMavenId() + " is not a dependency"));
                    usedTranslations.remove(translationFile);
                    continue;
                }
                this.getLog().debug((CharSequence)(translationFile.getMavenId() + " is a dependency"));
            }
            translations = usedTranslations;
        }
        if (translations.size() == 0) {
            this.getLog().info((CharSequence)"No translations available for this project!");
        } else {
            this.getLog().info((CharSequence)"Cleaning crowdin folder");
            this.cleanFolders(translations.keySet());
            this.getLog().info((CharSequence)"Copying translations to crowdin folder");
            try {
                this.copyTranslations(translations);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write file", (Exception)e);
            }
            this.downloadStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadStatus() throws MojoExecutionException {
        this.getLog().info((CharSequence)"Downloading translation status");
        if (this.statusFile == null) {
            throw new MojoExecutionException("Parameter statusFile can not be empty - fetch aborted");
        }
        if (this.statusFile.exists() && this.statusFile.isDirectory() || this.statusFile.getName() == null || this.statusFile.getName().equals("")) {
            throw new MojoExecutionException("Parameter statusFile must be a file - fetch aborted");
        }
        Document document = this.crowdinRequestAPI("status", null, null, true);
        if (!document.getRootElement().getName().equals("status")) {
            String code = document.getRootElement().getChildTextNormalize("code");
            String message = document.getRootElement().getChildTextNormalize("message");
            throw new MojoExecutionException("Failed to call API for \"status\" - " + code + " - " + message);
        }
        this.getLog().info((CharSequence)"Writing translation status to file");
        SortedProperties statusProperties = new SortedProperties();
        for (Object child : document.getRootElement().getChildren("language")) {
            Element childElement = (Element)child;
            if (childElement.getChildTextTrim("code").equals("")) continue;
            String languageTag = CodeConversion.crowdinCodeToLanguageTag(childElement.getChildTextNormalize("code"));
            statusProperties.put(languageTag + ".name", childElement.getChildTextNormalize("name"));
            statusProperties.put(languageTag + ".phrases", childElement.getChildTextNormalize("phrases"));
            statusProperties.put(languageTag + ".phrases.translated", childElement.getChildTextNormalize("translated"));
            statusProperties.put(languageTag + ".phrases.approved", childElement.getChildTextNormalize("approved"));
            statusProperties.put(languageTag + ".words", childElement.getChildTextNormalize("words"));
            statusProperties.put(languageTag + ".words.translated", childElement.getChildTextNormalize("words_translated"));
            statusProperties.put(languageTag + ".words.approved", childElement.getChildTextNormalize("words_approved"));
            statusProperties.put(languageTag + ".progress.translated", childElement.getChildTextNormalize("translated_progress"));
            statusProperties.put(languageTag + ".progress.approved", childElement.getChildTextNormalize("approved_progress"));
            if (!this.getLog().isDebugEnabled()) continue;
            this.getLog().debug((CharSequence)("Translation status for " + childElement.getChildTextNormalize("name") + "(" + childElement.getChildTextNormalize("code") + "): " + "Phrases " + childElement.getChildTextNormalize("phrases") + ", Translated " + childElement.getChildTextNormalize("translated") + ", Approved " + childElement.getChildTextNormalize("approved")));
        }
        File statusFile = new File(this.downloadFolder, this.statusFile.getName());
        try (FileOutputStream out = new FileOutputStream(statusFile);){
            statusProperties.store(out, "This file is automatically generated, please do not edit this file.");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write file " + statusFile.getAbsolutePath() + ": " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTranslations(Map<TranslationFile, byte[]> translations) throws IOException, MojoExecutionException {
        Set<Map.Entry<TranslationFile, byte[]>> entrySet = translations.entrySet();
        for (Map.Entry<TranslationFile, byte[]> entry : entrySet) {
            File targetFile;
            TranslationFile translationFile = entry.getKey();
            byte[] bytes = entry.getValue();
            SortedProperties properties = new SortedProperties();
            try (ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);){
                properties.load(inStream);
            }
            File languageFolder = new File(this.downloadFolder, translationFile.getLanguage());
            if (!languageFolder.exists() && !languageFolder.mkdirs()) {
                throw new MojoExecutionException("Could not create folder " + languageFolder.getAbsolutePath());
            }
            if (translationFile.getMavenId() != null) {
                File mavenIdFolder = new File(languageFolder, translationFile.getMavenId());
                if (!mavenIdFolder.exists() && !mavenIdFolder.mkdirs()) {
                    throw new MojoExecutionException("Could not create folder \"" + mavenIdFolder.getAbsolutePath() + "\"");
                }
                targetFile = new File(mavenIdFolder, translationFile.getName());
            } else {
                targetFile = new File(languageFolder, translationFile.getName());
            }
            this.getLog().info((CharSequence)("Importing " + translationFile.getLanguage() + (translationFile.getMavenId() == null ? "" : "/" + translationFile.getMavenId()) + "/" + translationFile.getName() + " from crowdin"));
            try (FileOutputStream out = new FileOutputStream(targetFile);){
                properties.store(out, COMMENT);
            }
        }
    }

    private Set<Artifact> getAllDependencies() throws MojoExecutionException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        try {
            ScopeArtifactFilter artifactFilter = new ScopeArtifactFilter(null);
            if (this.localRepository != null) {
                DependencyNode rootNode = this.treeBuilder.buildDependencyTree(this.project, this.localRepository, this.artifactFactory, this.artifactMetadataSource, (ArtifactFilter)artifactFilter, this.artifactCollector);
                CollectingDependencyNodeVisitor visitor = new CollectingDependencyNodeVisitor();
                rootNode.accept((DependencyNodeVisitor)visitor);
                List nodes = visitor.getNodes();
                for (DependencyNode dependencyNode : nodes) {
                    int state = dependencyNode.getState();
                    Artifact artifact = dependencyNode.getArtifact();
                    if (state != 0) continue;
                    result.add(new SpecialArtifact(artifact));
                }
            }
        }
        catch (DependencyTreeBuilderException e) {
            throw new MojoExecutionException("Failed to get dependencies", (Exception)((Object)e));
        }
        return result;
    }
}

