/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.crowdin.tool;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Repository;

public class GitUtil {
    public static String getBranch(File projectBasedir, Log log) {
        if (!projectBasedir.exists()) {
            log.warn((CharSequence)("Project basedir (" + projectBasedir + ") doesn't exist - cannot determine git branch"));
            return null;
        }
        if (!projectBasedir.isDirectory()) {
            log.warn((CharSequence)("Project basedir (" + projectBasedir + ") must be a folder - cannot determine git branch"));
            return null;
        }
        try {
            log.debug((CharSequence)("Trying to read \"" + projectBasedir + "\" with git"));
            Git git = Git.open((File)projectBasedir);
            Repository repo = git.getRepository();
            try {
                String branch = repo.getBranch();
                if (repo.getRef("HEAD").getTarget().getName().endsWith(branch)) {
                    log.debug((CharSequence)("Git branch determined to be \"" + branch + "\""));
                    return branch;
                }
                log.warn((CharSequence)("Git branch was reported to be \"" + branch + "\" which means that HEAD is detached"));
            }
            catch (IOException e) {
                log.warn((CharSequence)("An error occurred while reading git branch: " + e.getMessage()));
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("An error occurred while opening project basedir with git: " + e.getMessage()));
        }
        log.warn((CharSequence)"Cannot determine git branch");
        return null;
    }
}

