/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.annotations.helpers.AnnotationHelper;
import com.univocity.parsers.annotations.helpers.FieldMapping;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.ConversionProcessor;
import com.univocity.parsers.conversions.Conversion;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

abstract class BeanConversionProcessor<T>
extends ConversionProcessor {
    private final Class<T> beanClass;
    private final Set<FieldMapping> parsedFields = new HashSet<FieldMapping>();
    private boolean fieldIndexesMapped = false;
    private FieldMapping[] readOrder;
    private boolean initialized = false;

    public BeanConversionProcessor(Class<T> beanType) {
        this.beanClass = beanType;
    }

    protected final void initialize() {
        if (!this.initialized) {
            this.initialized = true;
            HashMap<String, Object> properties = new HashMap<String, Object>();
            try {
                BeanInfo beanInfo = Introspector.getBeanInfo(this.beanClass, Object.class);
                for (PropertyDescriptor property : beanInfo.getPropertyDescriptors()) {
                    String name = property.getName();
                    properties.put(name, property);
                }
            }
            catch (IntrospectionException e) {
                // empty catch block
            }
            Field[] declared = this.beanClass.getDeclaredFields();
            for (Field field : declared) {
                Parsed annotation = field.getAnnotation(Parsed.class);
                if (annotation == null) continue;
                FieldMapping mapping = new FieldMapping(this.beanClass, field, (PropertyDescriptor)properties.get(field.getName()));
                this.parsedFields.add(mapping);
                this.setupConversions(field, mapping);
            }
            this.readOrder = null;
            this.fieldIndexesMapped = false;
        }
    }

    private void setupConversions(Field field, FieldMapping mapping) {
        Conversion defaultConversion;
        Annotation[] annotations = field.getAnnotations();
        Conversion lastConversion = null;
        for (Annotation annotation : annotations) {
            try {
                Conversion conversion = AnnotationHelper.getConversion(field, annotation);
                if (conversion == null) continue;
                this.addConversion(conversion, mapping);
                lastConversion = conversion;
            }
            catch (Exception ex) {
                String path = annotation.annotationType().getSimpleName() + "' of field '" + field.getName() + "' in " + this.beanClass.getName();
                throw new IllegalArgumentException("Error processing annotation " + path + ". " + ex.getMessage(), ex);
            }
        }
        if (field.getAnnotation(Parsed.class).applyDefaultConversion() && this.applyDefaultConversion(lastConversion, defaultConversion = AnnotationHelper.getDefaultConversion(field))) {
            this.addConversion(defaultConversion, mapping);
        }
    }

    private boolean applyDefaultConversion(Conversion lastConversionApplied, Conversion defaultConversion) {
        if (defaultConversion == null) {
            return false;
        }
        if (lastConversionApplied == null) {
            return true;
        }
        if (lastConversionApplied.getClass() == defaultConversion.getClass()) {
            return false;
        }
        Method execute = this.getConversionMethod(lastConversionApplied, "execute");
        Method revert = this.getConversionMethod(lastConversionApplied, "revert");
        Method defaultExecute = this.getConversionMethod(defaultConversion, "execute");
        Method defaultRevert = this.getConversionMethod(defaultConversion, "revert");
        return execute.getReturnType() != defaultExecute.getReturnType() || revert.getReturnType() != defaultRevert.getReturnType();
    }

    private Method getConversionMethod(Conversion conversion, String methodName) {
        Method targetMethod = null;
        for (Method method : conversion.getClass().getMethods()) {
            if (!method.getName().equals(methodName) || method.isSynthetic() || method.isBridge() || (method.getModifiers() & 1) != 1 || method.getParameterTypes().length != 1 || method.getReturnType() == Void.class) continue;
            if (targetMethod != null) {
                throw new IllegalStateException("Unable to convert values for class '" + this.beanClass + "'. Multiple '" + methodName + "' methods defined in conversion " + conversion.getClass() + ".");
            }
            targetMethod = method;
        }
        if (targetMethod != null) {
            return targetMethod;
        }
        throw new IllegalStateException("Unable to convert values for class '" + this.beanClass + "'. Cannot find method '" + methodName + "' in conversion " + conversion.getClass() + ".");
    }

    private void addConversion(Conversion conversion, FieldMapping mapping) {
        if (conversion == null) {
            return;
        }
        if (mapping.isMappedToIndex()) {
            this.convertIndexes(conversion).add((Integer[])new Integer[]{mapping.getIndex()});
        } else {
            this.convertFields(conversion).add((String[])new String[]{mapping.getFieldName()});
        }
    }

    private void mapValuesToFields(T instance, Object[] row, ParsingContext context) {
        if (!this.fieldIndexesMapped) {
            this.mapFieldIndexes(row, context.headers(), context.extractedFieldIndexes(), context.columnsReordered());
        }
        int last = row.length < this.readOrder.length ? row.length : this.readOrder.length;
        for (int i = 0; i < last; ++i) {
            FieldMapping field = this.readOrder[i];
            if (field == null) continue;
            Object value = row[i];
            field.write(instance, value);
        }
    }

    private void mapFieldIndexes(Object[] row, String[] headers, int[] indexes, boolean columnsReordered) {
        this.fieldIndexesMapped = true;
        if (headers == null) {
            headers = ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        int biggestIndex = headers.length > row.length ? headers.length : row.length;
        for (FieldMapping mapping : this.parsedFields) {
            int index = mapping.getIndex();
            if (biggestIndex >= index) continue;
            biggestIndex = index;
        }
        FieldMapping[] fieldOrder = new FieldMapping[biggestIndex];
        for (FieldMapping mapping : this.parsedFields) {
            if (mapping.isMappedToField()) {
                int index = ArgumentUtils.indexOf(headers, mapping.getFieldName());
                if (index == -1) {
                    throw new IllegalStateException("Could not find field with name '" + mapping.getFieldName() + "' in input. Names found: " + Arrays.toString(headers));
                }
                fieldOrder[index] = mapping;
                continue;
            }
            fieldOrder[mapping.getIndex()] = mapping;
        }
        if (indexes != null) {
            int j;
            for (int i = 0; i < fieldOrder.length; ++i) {
                boolean isIndexUsed = false;
                for (j = 0; j < indexes.length; ++j) {
                    if (indexes[j] != i) continue;
                    isIndexUsed = true;
                    break;
                }
                if (isIndexUsed) continue;
                fieldOrder[i] = null;
            }
            if (columnsReordered) {
                FieldMapping[] newFieldOrder = new FieldMapping[indexes.length];
                for (int i = 0; i < indexes.length; ++i) {
                    for (j = 0; j < fieldOrder.length; ++j) {
                        FieldMapping field;
                        int index = indexes[i];
                        newFieldOrder[i] = field = fieldOrder[index];
                    }
                }
                fieldOrder = newFieldOrder;
            }
        }
        this.readOrder = fieldOrder;
    }

    public final T createBean(String[] row, ParsingContext context) {
        T instance;
        Object[] convertedRow = super.applyConversions(row, context);
        try {
            instance = this.beanClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate class '" + this.beanClass.getName() + "'", e);
        }
        this.mapValuesToFields(instance, convertedRow, context);
        return instance;
    }

    private void mapFieldsToValues(T instance, Object[] row, String[] headers, int[] indexes, boolean columnsReordered) {
        if (!this.fieldIndexesMapped) {
            this.mapFieldIndexes(row, headers, indexes, columnsReordered);
        }
        int last = row.length < this.readOrder.length ? row.length : this.readOrder.length;
        for (int i = 0; i < last; ++i) {
            FieldMapping field = this.readOrder[i];
            if (field == null) continue;
            row[i] = field.read(instance);
        }
    }

    public final Object[] reverseConversions(T bean, String[] headers, int[] indexesToWrite) {
        Object[] row = indexesToWrite != null ? new Object[indexesToWrite.length] : new Object[headers.length];
        if (bean != null) {
            this.mapFieldsToValues(bean, row, headers, indexesToWrite, false);
        }
        super.reverseConversions(true, row, headers, indexesToWrite);
        return row;
    }
}

