/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.WriterCharAppender;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractWriter<S extends CommonWriterSettings<?>> {
    private final RowWriterProcessor writerProcessor;
    private final BufferedWriter writer;
    private final boolean skipEmptyLines;
    private final char comment;
    private final StringBuilder freeText = new StringBuilder();
    private final WriterCharAppender rowAppender;
    private final Object[] outputRow;
    private final int[] indexesToWrite;
    private final char[] lineSeparator;
    private String[] headers;
    private long recordCount = 0L;
    protected final String nullValue;
    protected final String emptyValue;
    protected final CharAppender appender;
    private final Object[] partialLine;
    private int partialLineIndex = 0;
    private Map<String, Integer> headerIndexes;

    public AbstractWriter(Writer writer, S settings) {
        this.nullValue = ((CommonSettings)settings).getNullValue();
        this.emptyValue = ((CommonWriterSettings)settings).getEmptyValue();
        this.lineSeparator = ((Format)((CommonSettings)settings).getFormat()).getLineSeparator();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
        this.skipEmptyLines = ((CommonSettings)settings).getSkipEmptyLines();
        this.writerProcessor = ((CommonWriterSettings)settings).getRowWriterProcessor();
        this.appender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn(), "", (Format)((CommonSettings)settings).getFormat());
        this.rowAppender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn() * ((CommonSettings)settings).getMaxColumns(), "", (Format)((CommonSettings)settings).getFormat());
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.headers = ((CommonSettings)settings).getHeaders();
        FieldSelector selector = ((CommonSettings)settings).getFieldSelector();
        if (this.headers != null && this.headers.length > 0 && selector != null) {
            this.outputRow = new Object[this.headers.length];
            this.indexesToWrite = selector.getFieldIndexes(this.headers);
        } else {
            this.outputRow = null;
            this.indexesToWrite = null;
        }
        this.partialLine = new Object[((CommonSettings)settings).getMaxColumns()];
    }

    protected abstract void processRow(Object[] var1);

    protected final void appendValueToRow() {
        this.rowAppender.append((WriterCharAppender)this.appender);
    }

    protected final void appendToRow(char ch) {
        this.rowAppender.append(ch);
    }

    public final void writeHeaders() {
        this.writeHeaders(this.headers);
    }

    public final void writeHeaders(Collection<String> headers) {
        if (headers != null && headers.size() > 0) {
            this.writeHeaders(headers.toArray(new String[headers.size()]));
        } else {
            this.throwExceptionAndClose("No headers defined", (Object[])null, null);
        }
    }

    public final void writeHeaders(String ... headers) {
        if (this.recordCount > 0L) {
            this.throwExceptionAndClose("Cannot write headers after records have been written", headers, null);
        }
        if (headers != null && headers.length > 0) {
            this.processRow(headers);
            this.headers = headers;
            this.writeRow();
        } else {
            this.throwExceptionAndClose("No headers defined", headers, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Iterable<?> allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Object[] allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    public final void processRecords(Iterable<?> records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecords(Object[] records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecord(Object ... record) {
        this.processRecord((Object)record);
    }

    public final void processRecord(Object record) {
        if (this.writerProcessor == null) {
            try {
                throw new IllegalStateException("Cannot process record '" + record + "' without a writer processor. Please define a writer processor instance in the settings or use the 'writeRow' methods.");
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
        Object[] row = this.writerProcessor.write(record, this.headers, this.indexesToWrite);
        this.writeRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends Collection<Object>> void writeRowsAndClose(Iterable<C> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Collection<Object[]> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Object[][] allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    public final void writeRows(Object[][] rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final <C extends Collection<Object>> void writeRows(Iterable<C> rows) {
        for (Collection row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRows(Collection<Object[]> rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRow(Collection<Object> row) {
        if (row == null) {
            return;
        }
        this.writeRow(row.toArray());
    }

    public final void writeRow(Object ... row) {
        try {
            if (row == null || row.length == 0) {
                if (this.skipEmptyLines) {
                    return;
                }
                this.writeEmptyRow();
                return;
            }
            if (this.outputRow != null) {
                this.fillOutputRow(row);
                row = this.outputRow;
            }
            this.processRow(row);
            this.writeRow();
        }
        catch (Throwable ex) {
            this.throwExceptionAndClose("Error writing empty row", row, ex);
        }
    }

    public final void writeRow(String row) {
        this.freeText.setLength(0);
        this.freeText.append(row);
        this.writeToOutput(this.freeText.toString());
    }

    public final void writeEmptyRow() {
        try {
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            this.throwExceptionAndClose("Error writing empty row", Arrays.toString(this.lineSeparator), (Throwable)ex);
        }
    }

    public final void commentRow(String comment) {
        this.writeRow(this.comment + comment);
    }

    private <T> void fillOutputRow(T[] row) {
        if (row.length > this.indexesToWrite.length) {
            String msg = "Cannot write row as it contains more elements than the number of selected fields (" + this.indexesToWrite.length + " fields selected)";
            this.throwExceptionAndClose(msg, this.headers, null);
        }
        for (int i = 0; i < this.indexesToWrite.length && i < row.length; ++i) {
            this.outputRow[this.indexesToWrite[i]] = row[i];
        }
    }

    private void writeRow() {
        try {
            this.rowAppender.appendNewLine();
            this.rowAppender.writeCharsAndReset(this.writer);
            ++this.recordCount;
        }
        catch (Throwable ex) {
            this.throwExceptionAndClose("Error writing row", this.rowAppender.getAndReset(), ex);
        }
    }

    private void writeToOutput(String row) {
        try {
            this.writer.write(row);
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            this.throwExceptionAndClose("Error writing row", row, (Throwable)ex);
        }
    }

    protected final int skipLeadingWhitespace(String element) {
        for (int i = 0; i < element.length(); ++i) {
            char nextChar = element.charAt(i);
            if (nextChar <= ' ') continue;
            return i;
        }
        return 0;
    }

    public final void flush() {
        try {
            this.writer.flush();
        }
        catch (Throwable ex) {
            this.throwExceptionAndClose("Error flushing output", this.rowAppender.getAndReset(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            this.headerIndexes = null;
            try {
                this.writer.flush();
            }
            finally {
                this.writer.close();
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Error closing the output.", ex);
        }
    }

    private void throwExceptionAndClose(String message, String recordCharacters, Throwable cause) {
        try {
            throw new TextWritingException(message, this.recordCount, recordCharacters, cause);
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    private void throwExceptionAndClose(String message, Object[] recordValues, Throwable cause) {
        try {
            throw new TextWritingException(message, this.recordCount, recordValues, cause);
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    protected String getStringValue(Object element) {
        if (element == null && (element = this.nullValue) == null) {
            return null;
        }
        String string = String.valueOf(element);
        if (string.isEmpty()) {
            return this.emptyValue;
        }
        return string;
    }

    public final void writeValues(Object ... values) {
        System.arraycopy(values, 0, this.partialLine, this.partialLineIndex, values.length);
        this.partialLineIndex += values.length;
    }

    public final void writeValue(Object value) {
        this.partialLine[this.partialLineIndex++] = value;
    }

    public final void writeValuesToRow() {
        this.writeRow(Arrays.copyOf(this.partialLine, this.partialLineIndex + 1));
        this.partialLineIndex = 0;
    }

    public final void writeValue(int index, Object value) {
        this.partialLine[index] = value;
        if (this.partialLineIndex < index) {
            this.partialLineIndex = index;
        }
    }

    public final void writeValue(String headerName, Object value) {
        this.writeValue(this.getFieldIndex(headerName), value);
    }

    private int getFieldIndex(String headerName) {
        Integer index;
        if (this.headerIndexes == null) {
            this.headerIndexes = new HashMap<String, Integer>();
        }
        if ((index = this.headerIndexes.get(headerName)) == null) {
            if (this.headers == null) {
                throw new IllegalArgumentException("Cannot calculate position of header '" + headerName + "' as no headers were defined");
            }
            index = ArgumentUtils.indexOf(ArgumentUtils.normalize(this.headers), ArgumentUtils.normalize(headerName));
            if (index == -1) {
                throw new IllegalArgumentException("Header '" + headerName + "' could not be found. Defined headers are: " + Arrays.toString(this.headers));
            }
            this.headerIndexes.put(headerName, index);
        }
        return index;
    }

    public final void discardValues() {
        this.partialLineIndex = 0;
    }
}

