/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input.concurrent;

import com.univocity.parsers.common.input.concurrent.CharBucket;
import com.univocity.parsers.common.input.concurrent.Entry;
import com.univocity.parsers.common.input.concurrent.FixedInstancePool;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.ArrayBlockingQueue;

class ConcurrentCharLoader
implements Runnable {
    private final ArrayBlockingQueue<Object> buckets;
    private final CharBucket end = new CharBucket(-1);
    private final FixedInstancePool<CharBucket> instances;
    private Entry<CharBucket> currentBucket;
    private boolean finished = false;
    private boolean active;
    private final Reader reader;
    private Thread activeExecution;

    public ConcurrentCharLoader(Reader reader, final int bucketSize, int bucketQuantity) {
        this.buckets = new ArrayBlockingQueue(bucketQuantity);
        this.reader = reader;
        this.instances = new FixedInstancePool<CharBucket>(bucketQuantity){

            @Override
            protected CharBucket newInstance() {
                return new CharBucket(bucketSize);
            }
        };
        this.finished = false;
        this.active = true;
        this.activeExecution = new Thread((Runnable)this, "unVocity-parsers input reading thread");
        this.activeExecution.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName("Character reading thread");
        try {
            try {
                int length;
                do {
                    Entry<CharBucket> bucket;
                    if ((length = (bucket = this.instances.allocate()).get().fill(this.reader)) != -1) {
                        this.buckets.put(bucket);
                        continue;
                    }
                    this.instances.release(bucket);
                } while (this.active && length != -1);
            }
            finally {
                this.buckets.put(this.end);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error processing input", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.stopReading();
        }
    }

    public synchronized CharBucket nextBucket() {
        try {
            Object element;
            if (this.finished) {
                return this.end;
            }
            if (this.currentBucket != null) {
                this.instances.release(this.currentBucket);
            }
            if ((element = this.buckets.take()) == this.end) {
                this.finished = true;
                return this.end;
            }
            this.currentBucket = (Entry)element;
            return this.currentBucket.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Unable to process input. ", e);
        }
    }

    public void stopReading() {
        this.active = false;
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Error closing input", e);
        }
        finally {
            try {
                this.activeExecution.interrupt();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Error stopping input reader thread", ex);
            }
        }
    }
}

