/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.DefaultConversionProcessor;
import com.univocity.parsers.common.DummyFormat;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.common.fields.ExcludeFieldNameSelector;
import com.univocity.parsers.common.fields.FieldIndexSelector;
import com.univocity.parsers.common.fields.FieldNameSelector;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.WriterCharAppender;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import com.univocity.parsers.common.processor.RowWriterProcessorSwitch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractWriter<S extends CommonWriterSettings<?>> {
    private final RowWriterProcessor writerProcessor;
    private BufferedWriter writer;
    private final boolean skipEmptyLines;
    private final char comment;
    private final WriterCharAppender rowAppender;
    private final boolean isHeaderWritingEnabled;
    private Object[] outputRow;
    private int[] indexesToWrite;
    private final char[] lineSeparator;
    private String[] headers;
    private long recordCount = 0L;
    protected final String nullValue;
    protected final String emptyValue;
    protected final WriterCharAppender appender;
    private final Object[] partialLine;
    private int partialLineIndex = 0;
    private Map<String[], Map<String, Integer>> headerIndexes;
    private int largestRowLength = -1;
    protected boolean writingHeaders = false;
    private String[] dummyHeaderRow;
    private boolean expandRows;
    private boolean usingSwitch;
    private final CommonSettings<DummyFormat> internalSettings = new CommonSettings<DummyFormat>(){

        @Override
        protected DummyFormat createDefaultFormat() {
            return DummyFormat.instance;
        }
    };

    public AbstractWriter(S settings) {
        this((Writer)null, settings);
    }

    public AbstractWriter(File file, S settings) {
        this(ArgumentUtils.newWriter(file), settings);
    }

    public AbstractWriter(File file, String encoding, S settings) {
        this(ArgumentUtils.newWriter(file, encoding), settings);
    }

    public AbstractWriter(File file, Charset encoding, S settings) {
        this(ArgumentUtils.newWriter(file, encoding), settings);
    }

    public AbstractWriter(OutputStream output, S settings) {
        this(ArgumentUtils.newWriter(output), settings);
    }

    public AbstractWriter(OutputStream output, String encoding, S settings) {
        this(ArgumentUtils.newWriter(output, encoding), settings);
    }

    public AbstractWriter(OutputStream output, Charset encoding, S settings) {
        this(ArgumentUtils.newWriter(output, encoding), settings);
    }

    public AbstractWriter(Writer writer, S settings) {
        ((CommonSettings)settings).autoConfigure();
        this.internalSettings.setMaxColumns(((CommonSettings)settings).getMaxColumns());
        this.nullValue = ((CommonSettings)settings).getNullValue();
        this.emptyValue = ((CommonWriterSettings)settings).getEmptyValue();
        this.lineSeparator = ((Format)((CommonSettings)settings).getFormat()).getLineSeparator();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
        this.skipEmptyLines = ((CommonSettings)settings).getSkipEmptyLines();
        this.writerProcessor = ((CommonWriterSettings)settings).getRowWriterProcessor();
        this.usingSwitch = this.writerProcessor instanceof RowWriterProcessorSwitch;
        this.expandRows = ((CommonWriterSettings)settings).getExpandIncompleteRows();
        this.appender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn(), "", (Format)((CommonSettings)settings).getFormat());
        this.rowAppender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn(), "", (Format)((CommonSettings)settings).getFormat());
        this.writer = writer != null ? (writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer)) : null;
        this.headers = ((CommonSettings)settings).getHeaders();
        this.updateIndexesToWrite((CommonSettings<?>)settings);
        this.partialLine = new Object[((CommonSettings)settings).getMaxColumns()];
        this.isHeaderWritingEnabled = ((CommonWriterSettings)settings).isHeaderWritingEnabled();
        if (this.writerProcessor instanceof DefaultConversionProcessor) {
            DefaultConversionProcessor conversionProcessor = (DefaultConversionProcessor)((Object)this.writerProcessor);
            conversionProcessor.context = null;
            conversionProcessor.errorHandler = ((CommonSettings)settings).getRowProcessorErrorHandler();
        }
        this.initialize(settings);
    }

    protected abstract void initialize(S var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateIndexesToWrite(CommonSettings<?> settings) {
        FieldSelector selector = settings.getFieldSelector();
        if (selector != null) {
            if (this.headers != null && this.headers.length > 0) {
                this.outputRow = new Object[this.headers.length];
                this.indexesToWrite = selector.getFieldIndexes(this.headers);
                return;
            } else {
                if (selector instanceof FieldNameSelector || selector instanceof ExcludeFieldNameSelector) throw new IllegalStateException("Cannot select fields by name with no headers defined");
                int rowLength = this.largestRowLength;
                if (selector instanceof FieldIndexSelector) {
                    boolean gotLengthFromSelection = false;
                    for (Integer index : ((FieldIndexSelector)selector).get()) {
                        if (rowLength > index) continue;
                        rowLength = index;
                        gotLengthFromSelection = true;
                    }
                    if (gotLengthFromSelection) {
                        ++rowLength;
                    }
                    if (rowLength < this.largestRowLength) {
                        rowLength = this.largestRowLength;
                    }
                } else {
                    rowLength = settings.getMaxColumns();
                }
                this.outputRow = new Object[rowLength];
                this.indexesToWrite = selector.getFieldIndexes(new String[rowLength]);
            }
            return;
        } else {
            this.outputRow = null;
            this.indexesToWrite = null;
        }
    }

    public void updateFieldSelection(String ... newFieldSelection) {
        if (this.headers == null) {
            throw new IllegalStateException("Cannot select fields by name. Headers not defined.");
        }
        this.internalSettings.selectFields(newFieldSelection);
        this.updateIndexesToWrite(this.internalSettings);
    }

    public void updateFieldSelection(Integer ... newFieldSelectionByIndex) {
        this.internalSettings.selectIndexes(newFieldSelectionByIndex);
        this.updateIndexesToWrite(this.internalSettings);
    }

    public void updateFieldExclusion(String ... fieldsToExclude) {
        if (this.headers == null) {
            throw new IllegalStateException("Cannot de-select fields by name. Headers not defined.");
        }
        this.internalSettings.excludeFields(fieldsToExclude);
        this.updateIndexesToWrite(this.internalSettings);
    }

    public void updateFieldExclusion(Integer ... fieldIndexesToExclude) {
        this.internalSettings.excludeIndexes(fieldIndexesToExclude);
        this.updateIndexesToWrite(this.internalSettings);
    }

    private void submitRow(Object[] row) {
        if (this.largestRowLength < row.length) {
            this.largestRowLength = row.length;
        }
        this.processRow(row);
    }

    protected abstract void processRow(Object[] var1);

    protected final void appendValueToRow() {
        this.rowAppender.append(this.appender);
    }

    protected final void appendToRow(char ch) {
        this.rowAppender.append(ch);
    }

    public final void writeHeaders() {
        this.writeHeaders(this.headers);
    }

    public final void writeHeaders(Collection<String> headers) {
        if (headers == null || headers.size() <= 0) {
            throw this.throwExceptionAndClose("No headers defined.");
        }
        this.writeHeaders(headers.toArray(new String[headers.size()]));
    }

    public final void writeHeaders(String ... headers) {
        if (this.recordCount > 0L) {
            throw this.throwExceptionAndClose("Cannot write headers after records have been written.", headers, null);
        }
        if (headers == null || headers.length <= 0) {
            throw this.throwExceptionAndClose("No headers defined.", headers, null);
        }
        this.writingHeaders = true;
        this.submitRow(headers);
        this.headers = headers;
        this.writeRow();
        this.writingHeaders = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Iterable<?> allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Object[] allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    public final void processRecords(Iterable<?> records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecords(Object[] records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecord(Object ... record) {
        this.processRecord((Object)record);
    }

    public final void processRecord(Object record) {
        Object[] row;
        if (this.writerProcessor == null) {
            String recordDescription = record instanceof Object[] ? Arrays.toString((Object[])record) : String.valueOf(record);
            String message = "Cannot process record '" + recordDescription + "' without a writer processor. Please define a writer processor instance in the settings or use the 'writeRow' methods.";
            this.throwExceptionAndClose(message);
        }
        if (this.usingSwitch) {
            this.dummyHeaderRow = ((RowWriterProcessorSwitch)this.writerProcessor).getHeaders(record);
            if (this.dummyHeaderRow == null) {
                this.dummyHeaderRow = this.headers;
            }
            row = this.writerProcessor.write(record, this.dummyHeaderRow, this.indexesToWrite);
        } else {
            row = this.writerProcessor.write(record, this.getRowProcessorHeaders(), this.indexesToWrite);
        }
        if (row != null) {
            this.writeRow(row);
        }
    }

    private String[] getRowProcessorHeaders() {
        if (this.headers == null && this.indexesToWrite == null) {
            return null;
        }
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends Collection<Object>> void writeRowsAndClose(Iterable<C> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Collection<Object[]> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeStringRowsAndClose(Collection<String[]> allRows) {
        try {
            this.writeStringRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Object[][] allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    public final void writeRows(Object[][] rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final <C extends Collection<Object>> void writeRows(Iterable<C> rows) {
        for (Collection row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeStringRows(Collection<String[]> rows) {
        for (String[] row : rows) {
            this.writeRow(row);
        }
    }

    public final <C extends Collection<String>> void writeStringRows(Iterable<C> rows) {
        for (Collection row : rows) {
            this.writeRow(row.toArray());
        }
    }

    public final void writeRows(Collection<Object[]> rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRow(Collection<Object> row) {
        if (row == null) {
            return;
        }
        this.writeRow(row.toArray());
    }

    public final void writeRow(String[] row) {
        this.writeRow((Object[])row);
    }

    public final void writeRow(Object ... row) {
        try {
            if (this.recordCount == 0L && this.isHeaderWritingEnabled && this.headers != null) {
                this.writeHeaders();
            }
            if (row == null || row.length == 0 && !this.expandRows) {
                if (this.skipEmptyLines) {
                    return;
                }
                this.writeEmptyRow();
                return;
            }
            if (this.outputRow != null) {
                this.fillOutputRow(row);
                row = this.outputRow;
            } else if (this.expandRows) {
                if (this.usingSwitch) {
                    row = this.expand(row, this.dummyHeaderRow, this.headers);
                    this.dummyHeaderRow = null;
                } else {
                    row = this.expand(row, this.headers, null);
                }
            }
            this.submitRow(row);
            this.writeRow();
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error writing row.", row, ex);
        }
    }

    private Object[] expand(Object[] row, String[] h1, String[] h2) {
        if (h1 != null && row.length < h1.length) {
            return Arrays.copyOf(row, h1.length);
        }
        if (h2 != null && row.length < h2.length) {
            return Arrays.copyOf(row, h2.length);
        }
        if (h1 == null && h2 == null && row.length < this.largestRowLength) {
            return Arrays.copyOf(row, this.largestRowLength);
        }
        return row;
    }

    public final void writeRow(String row) {
        try {
            this.writer.write(row);
            this.writer.write(this.lineSeparator);
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error writing row.", row, ex);
        }
    }

    public final void writeEmptyRow() {
        try {
            this.writer.write(this.lineSeparator);
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error writing empty row.", Arrays.toString(this.lineSeparator), ex);
        }
    }

    public final void commentRow(String comment) {
        this.writeRow(this.comment + comment);
    }

    private <T> void fillOutputRow(T[] row) {
        if (row.length > this.outputRow.length) {
            this.outputRow = row;
        } else if (row.length > this.indexesToWrite.length) {
            for (int i = 0; i < this.indexesToWrite.length; ++i) {
                this.outputRow[this.indexesToWrite[i]] = row[this.indexesToWrite[i]];
            }
        } else {
            for (int i = 0; i < this.indexesToWrite.length && i < row.length; ++i) {
                this.outputRow[this.indexesToWrite[i]] = row[i];
            }
        }
    }

    private void writeRow() {
        try {
            if (this.skipEmptyLines && this.rowAppender.length() == 0) {
                return;
            }
            this.rowAppender.appendNewLine();
            this.rowAppender.writeCharsAndReset(this.writer);
            ++this.recordCount;
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error writing row.", this.rowAppender.getAndReset(), ex);
        }
    }

    protected static int skipLeadingWhitespace(String element) {
        if (element.isEmpty()) {
            return 0;
        }
        for (int i = 0; i < element.length(); ++i) {
            char nextChar = element.charAt(i);
            if (nextChar <= ' ') continue;
            return i;
        }
        return element.length();
    }

    public final void flush() {
        try {
            this.writer.flush();
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error flushing output.", this.rowAppender.getAndReset(), ex);
        }
    }

    public final void close() {
        try {
            this.headerIndexes = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Error closing the output.", ex);
        }
        if (this.partialLineIndex != 0) {
            throw new TextWritingException("Not all values associated with the last record have been written to the output. \n\tHint: use 'writeValuesToRow()' or 'writeValuesToString()' to flush the partially written values to a row.", this.recordCount, Arrays.copyOf(this.partialLine, this.partialLineIndex));
        }
    }

    private TextWritingException throwExceptionAndClose(String message) {
        return this.throwExceptionAndClose(message, (Object[])null, null);
    }

    private TextWritingException throwExceptionAndClose(String message, Throwable cause) {
        return this.throwExceptionAndClose(message, (Object[])null, cause);
    }

    private TextWritingException throwExceptionAndClose(String message, String recordCharacters, Throwable cause) {
        try {
            if (cause instanceof NullPointerException && this.writer == null) {
                message = message + " No writer provided in the constructor of " + this.getClass().getName() + ". You can only use operations that write to Strings.";
            }
            throw new TextWritingException(message, this.recordCount, recordCharacters, cause);
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    private TextWritingException throwExceptionAndClose(String message, Object[] recordValues, Throwable cause) {
        try {
            throw new TextWritingException(message, this.recordCount, recordValues, cause);
        }
        catch (Throwable throwable) {
            try {
                this.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected String getStringValue(Object element) {
        if (element == null && (element = this.nullValue) == null) {
            return null;
        }
        String string = String.valueOf(element);
        if (string.isEmpty()) {
            return this.emptyValue;
        }
        return string;
    }

    public final void addValues(Object ... values) {
        try {
            System.arraycopy(values, 0, this.partialLine, this.partialLineIndex, values.length);
            this.partialLineIndex += values.length;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error adding values to in-memory row", values, t);
        }
    }

    public final void addStringValues(Collection<String> values) {
        if (values != null) {
            try {
                for (String o : values) {
                    this.partialLine[this.partialLineIndex++] = o;
                }
            }
            catch (Throwable t) {
                throw this.throwExceptionAndClose("Error adding values to in-memory row", values.toArray(), t);
            }
        }
    }

    public final void addValues(Collection<Object> values) {
        if (values != null) {
            try {
                for (Object o : values) {
                    this.partialLine[this.partialLineIndex++] = o;
                }
            }
            catch (Throwable t) {
                throw this.throwExceptionAndClose("Error adding values to in-memory row", values.toArray(), t);
            }
        }
    }

    public final void addValue(Object value) {
        try {
            this.partialLine[this.partialLineIndex++] = value;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error adding value to in-memory row", new Object[]{value}, t);
        }
    }

    private void fillPartialLineToMatchHeaders() {
        if (this.headers != null && this.partialLineIndex < this.headers.length) {
            while (this.partialLineIndex < this.headers.length) {
                this.partialLine[this.partialLineIndex++] = null;
            }
        }
    }

    public final void writeValuesToRow() {
        this.fillPartialLineToMatchHeaders();
        this.writeRow(Arrays.copyOf(this.partialLine, this.partialLineIndex));
        this.discardValues();
    }

    public final void addValue(int index, Object value) {
        if (index >= this.partialLine.length) {
            throw this.throwExceptionAndClose("Cannot write '" + value + "' to index '" + index + "'. Maximum number of columns (" + this.partialLine.length + ") exceeded.", new Object[]{value}, null);
        }
        this.partialLine[index] = value;
        if (this.partialLineIndex <= index) {
            this.partialLineIndex = index + 1;
        }
    }

    public final void addValue(String headerName, Object value) {
        this.addValue(this.getFieldIndex(this.headers, headerName, false), value);
    }

    private final void addValue(String[] headersInContext, String headerName, boolean ignoreOnMismatch, Object value) {
        int index = this.getFieldIndex(headersInContext, headerName, ignoreOnMismatch);
        if (index != -1) {
            this.addValue(index, value);
        }
    }

    private int getFieldIndex(String[] headersInContext, String headerName, boolean ignoreOnMismatch) {
        Integer index;
        Map<String, Integer> indexes;
        if (this.headerIndexes == null) {
            this.headerIndexes = new HashMap<String[], Map<String, Integer>>();
        }
        if ((indexes = this.headerIndexes.get(headersInContext)) == null) {
            indexes = new HashMap<String, Integer>();
            this.headerIndexes.put(headersInContext, indexes);
        }
        if ((index = indexes.get(headerName)) == null) {
            if (headersInContext == null) {
                throw this.throwExceptionAndClose("Cannot calculate position of header '" + headerName + "' as no headers were defined.", null);
            }
            index = ArgumentUtils.indexOf(ArgumentUtils.normalize(headersInContext), ArgumentUtils.normalize(headerName));
            if (index == -1 && !ignoreOnMismatch) {
                throw this.throwExceptionAndClose("Header '" + headerName + "' could not be found. Defined headers are: " + Arrays.toString(headersInContext) + '.', null);
            }
            indexes.put(headerName, index);
        }
        return index;
    }

    public final void discardValues() {
        Arrays.fill(this.partialLine, 0, this.partialLineIndex, null);
        this.partialLineIndex = 0;
    }

    public final String writeHeadersToString() {
        return this.writeHeadersToString(this.headers);
    }

    public final String writeHeadersToString(Collection<String> headers) {
        if (headers != null && headers.size() > 0) {
            return this.writeHeadersToString(headers.toArray(new String[headers.size()]));
        }
        throw this.throwExceptionAndClose("No headers defined");
    }

    public final String writeHeadersToString(String ... headers) {
        if (headers != null && headers.length > 0) {
            this.writingHeaders = true;
            this.submitRow(headers);
            this.writingHeaders = false;
            this.headers = headers;
            return this.writeRowToString();
        }
        throw this.throwExceptionAndClose("No headers defined.");
    }

    public final List<String> processRecordsToString(Iterable<?> records) {
        try {
            ArrayList<String> out = new ArrayList<String>(1000);
            for (Object record : records) {
                out.add(this.processRecordToString(record));
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Unable process input records", t);
        }
    }

    public final List<String> processRecordsToString(Object[] records) {
        try {
            ArrayList<String> out = new ArrayList<String>(1000);
            for (Object record : records) {
                out.add(this.processRecordToString(record));
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Unable process input records", records, t);
        }
    }

    public final String processRecordToString(Object ... record) {
        return this.processRecordToString((Object)record);
    }

    public final String processRecordToString(Object record) {
        if (this.writerProcessor == null) {
            throw this.throwExceptionAndClose("Cannot process record '" + record + "' without a writer processor. Please define a writer processor instance in the settings or use the 'writeRow' methods.");
        }
        try {
            Object[] row = this.writerProcessor.write(record, this.getRowProcessorHeaders(), this.indexesToWrite);
            if (row != null) {
                return this.writeRowToString(row);
            }
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Could not process record '" + record + "'", t);
        }
        return null;
    }

    public final List<String> writeRowsToString(Object[][] rows) {
        try {
            ArrayList<String> out = new ArrayList<String>(rows.length);
            for (Object[] row : rows) {
                String string = this.writeRowToString(row);
                if (string == null) continue;
                out.add(string);
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input rows", t);
        }
    }

    public final <C extends Collection<Object>> List<String> writeRowsToString(Iterable<C> rows) {
        try {
            ArrayList<String> out = new ArrayList<String>(1000);
            for (Collection row : rows) {
                out.add(this.writeRowToString(row));
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input rows", t);
        }
    }

    public final <C extends Collection<String>> List<String> writeStringRowsToString(Iterable<C> rows) {
        try {
            ArrayList<String> out = new ArrayList<String>(1000);
            for (Collection row : rows) {
                String string = this.writeRowToString(new Object[]{row});
                if (string == null) continue;
                out.add(string);
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input rows", t);
        }
    }

    public final List<String> writeRowsToString(Collection<Object[]> rows) {
        try {
            ArrayList<String> out = new ArrayList<String>(rows.size());
            for (Object[] row : rows) {
                out.add(this.writeRowToString(row));
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input rows", t);
        }
    }

    public final List<String> writeStringRowsToString(Collection<String[]> rows) {
        try {
            ArrayList<String> out = new ArrayList<String>(rows.size());
            for (String[] row : rows) {
                out.add(this.writeRowToString(row));
            }
            return out;
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input rows", t);
        }
    }

    public final String writeRowToString(Collection<Object> row) {
        try {
            if (row == null) {
                return null;
            }
            return this.writeRowToString(row.toArray());
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error writing input row ", t);
        }
    }

    public final String writeRowToString(String[] row) {
        return this.writeRowToString((Object[])row);
    }

    public final String writeRowToString(Object ... row) {
        try {
            if ((row == null || row.length == 0) && this.skipEmptyLines) {
                return null;
            }
            if (this.outputRow != null) {
                this.fillOutputRow(row);
                row = this.outputRow;
            }
            this.submitRow(row);
            return this.writeRowToString();
        }
        catch (Throwable ex) {
            throw this.throwExceptionAndClose("Error writing row.", row, ex);
        }
    }

    public final String commentRowToString(String comment) {
        return this.writeRowToString(this.comment + comment);
    }

    private String writeRowToString() {
        if (this.skipEmptyLines && this.rowAppender.length() == 0) {
            return null;
        }
        String out = this.rowAppender.getAndReset();
        ++this.recordCount;
        return out;
    }

    public final String writeValuesToString() {
        this.fillPartialLineToMatchHeaders();
        String out = this.writeRowToString(Arrays.copyOf(this.partialLine, this.partialLineIndex));
        this.discardValues();
        return out;
    }

    public final void processValuesToRow() {
        this.fillPartialLineToMatchHeaders();
        this.processRecord(Arrays.copyOf(this.partialLine, this.partialLineIndex));
        this.discardValues();
    }

    public final String processValuesToString() {
        this.fillPartialLineToMatchHeaders();
        String out = this.processRecordToString(Arrays.copyOf(this.partialLine, this.partialLineIndex));
        this.discardValues();
        return out;
    }

    public final long getRecordCount() {
        return this.recordCount;
    }

    private <K> void writeValuesFromMap(Map<K, String> headerMapping, Map<K, ?> rowData) {
        try {
            if (rowData != null && !rowData.isEmpty()) {
                this.dummyHeaderRow = this.headers;
                if (this.usingSwitch) {
                    this.dummyHeaderRow = ((RowWriterProcessorSwitch)this.writerProcessor).getHeaders(headerMapping, rowData);
                    if (this.dummyHeaderRow == null) {
                        this.dummyHeaderRow = this.headers;
                    }
                }
                if (this.dummyHeaderRow != null) {
                    if (headerMapping == null) {
                        for (Map.Entry<K, ?> e : rowData.entrySet()) {
                            this.addValue(this.dummyHeaderRow, String.valueOf(e.getKey()), true, e.getValue());
                        }
                    } else {
                        for (Map.Entry<K, ?> e : rowData.entrySet()) {
                            String header = headerMapping.get(e.getKey());
                            if (header == null) continue;
                            this.addValue(this.dummyHeaderRow, header, true, e.getValue());
                        }
                    }
                } else if (headerMapping != null) {
                    this.setHeadersFromMap(headerMapping, false);
                    this.writeValuesFromMap(headerMapping, rowData);
                } else {
                    this.setHeadersFromMap(rowData, true);
                    this.writeValuesFromMap(null, rowData);
                }
            }
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error processing data from input map", t);
        }
    }

    private void setHeadersFromMap(Map<?, ?> map, boolean keys) {
        this.headers = new String[map.size()];
        int i = 0;
        for (Object header : keys ? map.keySet() : map.values()) {
            this.headers[i++] = String.valueOf(header);
        }
    }

    public final String writeRowToString(Map<?, ?> rowData) {
        return this.writeRowToString(null, rowData);
    }

    public final void writeRow(Map<?, ?> rowData) {
        this.writeRow(null, rowData);
    }

    public final <K> String writeRowToString(Map<K, String> headerMapping, Map<K, ?> rowData) {
        this.writeValuesFromMap(headerMapping, rowData);
        return this.writeValuesToString();
    }

    public final <K> void writeRow(Map<K, String> headerMapping, Map<K, ?> rowData) {
        this.writeValuesFromMap(headerMapping, rowData);
        this.writeValuesToRow();
    }

    public final <K, I extends Iterable<?>> List<String> writeRowsToString(Map<K, I> rowData) {
        return this.writeRowsToString(null, rowData);
    }

    public final <K, I extends Iterable<?>> void writeRows(Map<K, I> rowData) {
        this.writeRows(null, rowData, null, false);
    }

    public final <K, I extends Iterable<?>> List<String> writeRowsToString(Map<K, String> headerMapping, Map<K, I> rowData) {
        ArrayList<String> writtenRows = new ArrayList<String>();
        this.writeRows(headerMapping, rowData, writtenRows, false);
        return writtenRows;
    }

    public final <K, I extends Iterable<?>> void writeRows(Map<K, String> headerMapping, Map<K, I> rowData) {
        this.writeRows(headerMapping, rowData, null, false);
    }

    private <K, I extends Iterable<?>> void writeRows(Map<K, String> headerMapping, Map<K, I> rowData, List<String> outputList, boolean useRowProcessor) {
        try {
            boolean nullsOnly;
            Iterator[] iterators = new Iterator[rowData.size()];
            Object[] keys = new Object[rowData.size()];
            LinkedHashMap rowValues = new LinkedHashMap(rowData.size());
            int length = 0;
            for (Map.Entry<K, I> rowEntry : rowData.entrySet()) {
                iterators[length] = rowEntry.getValue() == null ? null : ((Iterable)rowEntry.getValue()).iterator();
                keys[length] = rowEntry.getKey();
                rowValues.put(rowEntry.getKey(), null);
                ++length;
            }
            do {
                nullsOnly = true;
                for (int i = 0; i < length; ++i) {
                    Iterator iterator = iterators[i];
                    boolean isNull = iterator == null || !iterator.hasNext();
                    nullsOnly &= isNull;
                    if (isNull) {
                        rowValues.put(keys[i], null);
                        continue;
                    }
                    rowValues.put(keys[i], iterator.next());
                }
                if (nullsOnly) continue;
                if (outputList == null) {
                    if (useRowProcessor) {
                        this.processRecord(headerMapping, rowValues);
                        continue;
                    }
                    this.writeRow(headerMapping, rowValues);
                    continue;
                }
                if (useRowProcessor) {
                    outputList.add(this.processRecordToString(headerMapping, rowValues));
                    continue;
                }
                outputList.add(this.writeRowToString(headerMapping, rowValues));
            } while (!nullsOnly);
        }
        catch (Throwable t) {
            throw this.throwExceptionAndClose("Error processing input rows from map", t);
        }
    }

    public final <K> List<String> writeStringRowsToString(Map<K, String> headerMapping, Map<K, String[]> rowData) {
        ArrayList<String> writtenRows = new ArrayList<String>();
        this.writeRows(headerMapping, this.wrapStringArray(rowData), writtenRows, false);
        return writtenRows;
    }

    public final <K> void writeStringRows(Map<K, String> headerMapping, Map<K, String[]> rowData) {
        this.writeRows(headerMapping, this.wrapStringArray(rowData), null, false);
    }

    public final <K> List<String> writeObjectRowsToString(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        ArrayList<String> writtenRows = new ArrayList<String>();
        this.writeRows(headerMapping, this.wrapObjectArray(rowData), writtenRows, false);
        return writtenRows;
    }

    public final <K> void writeObjectRows(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        this.writeRows(headerMapping, this.wrapObjectArray(rowData), null, false);
    }

    private <K> Map<K, Iterable<Object>> wrapObjectArray(Map<K, Object[]> rowData) {
        LinkedHashMap<K, List<Object>> out = new LinkedHashMap<K, List<Object>>(rowData.size());
        for (Map.Entry<K, Object[]> e : rowData.entrySet()) {
            if (e.getValue() == null) {
                out.put(e.getKey(), Collections.emptyList());
                continue;
            }
            out.put(e.getKey(), Arrays.asList(e.getValue()));
        }
        return out;
    }

    private <K> Map<K, Iterable<String>> wrapStringArray(Map<K, String[]> rowData) {
        LinkedHashMap<K, List<Object>> out = new LinkedHashMap<K, List<Object>>(rowData.size());
        for (Map.Entry<K, String[]> e : rowData.entrySet()) {
            if (e.getValue() == null) {
                out.put(e.getKey(), Collections.emptyList());
                continue;
            }
            out.put(e.getKey(), Arrays.asList((Object[])e.getValue()));
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K> void writeObjectRowsAndClose(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        try {
            this.writeObjectRows(headerMapping, rowData);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K> void writeStringRowsAndClose(Map<K, String> headerMapping, Map<K, String[]> rowData) {
        try {
            this.writeStringRows(headerMapping, rowData);
        }
        finally {
            this.close();
        }
    }

    public final <K> void writeObjectRowsAndClose(Map<K, Object[]> rowData) {
        this.writeObjectRowsAndClose(null, rowData);
    }

    public final <K> void writeStringRowsAndClose(Map<K, String[]> rowData) {
        this.writeStringRowsAndClose(null, rowData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K, I extends Iterable<?>> void writeRowsAndClose(Map<K, String> headerMapping, Map<K, I> rowData) {
        try {
            this.writeRows(headerMapping, rowData);
        }
        finally {
            this.close();
        }
    }

    public final <K, I extends Iterable<?>> void writeRowsAndClose(Map<K, I> rowData) {
        this.writeRowsAndClose(null, rowData);
    }

    public final String processRecordToString(Map<?, ?> rowData) {
        return this.processRecordToString(null, rowData);
    }

    public final void processRecord(Map<?, ?> rowData) {
        this.processRecord(null, rowData);
    }

    public final <K> String processRecordToString(Map<K, String> headerMapping, Map<K, ?> rowData) {
        this.writeValuesFromMap(headerMapping, rowData);
        return this.processValuesToString();
    }

    public final <K> void processRecord(Map<K, String> headerMapping, Map<K, ?> rowData) {
        this.writeValuesFromMap(headerMapping, rowData);
        this.processValuesToRow();
    }

    public final <K, I extends Iterable<?>> List<String> processRecordsToString(Map<K, I> rowData) {
        return this.processRecordsToString(null, rowData);
    }

    public final <K, I extends Iterable<?>> void processRecords(Map<K, I> rowData) {
        this.writeRows(null, rowData, null, true);
    }

    public final <K, I extends Iterable<?>> List<String> processRecordsToString(Map<K, String> headerMapping, Map<K, I> rowData) {
        ArrayList<String> writtenRows = new ArrayList<String>();
        this.writeRows(headerMapping, rowData, writtenRows, true);
        return writtenRows;
    }

    public final <K, I extends Iterable<?>> void processRecords(Map<K, String> headerMapping, Map<K, I> rowData) {
        this.writeRows(headerMapping, rowData, null, true);
    }

    public final <K> List<String> processObjectRecordsToString(Map<K, Object[]> rowData) {
        return this.processObjectRecordsToString(null, rowData);
    }

    public final <K> List<String> processObjectRecordsToString(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        ArrayList<String> writtenRows = new ArrayList<String>();
        this.writeRows(headerMapping, this.wrapObjectArray(rowData), writtenRows, true);
        return writtenRows;
    }

    public final <K> void processObjectRecords(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        this.writeRows(headerMapping, this.wrapObjectArray(rowData), null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K> void processObjectRecordsAndClose(Map<K, String> headerMapping, Map<K, Object[]> rowData) {
        try {
            this.processObjectRecords(headerMapping, rowData);
        }
        finally {
            this.close();
        }
    }

    public final <K> void processObjectRecordsAndClose(Map<K, Object[]> rowData) {
        this.processRecordsAndClose(null, this.wrapObjectArray(rowData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K, I extends Iterable<?>> void processRecordsAndClose(Map<K, String> headerMapping, Map<K, I> rowData) {
        try {
            this.processRecords(headerMapping, rowData);
        }
        finally {
            this.close();
        }
    }

    public final <K, I extends Iterable<?>> void processRecordsAndClose(Map<K, I> rowData) {
        this.processRecordsAndClose(null, rowData);
    }
}

