/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.csv.CsvFormat;
import java.util.Map;

public class CsvParserSettings
extends CommonParserSettings<CsvFormat> {
    private String emptyValue = null;
    private boolean parseUnescapedQuotes = true;
    private boolean escapeUnquotedValues = false;
    private boolean keepEscapeSequences = false;
    private boolean normalizeLineEndingsWithinQuotes = true;
    private boolean delimiterDetectionEnabled = false;
    private boolean quoteDetectionEnabled = false;

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public void setEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
    }

    @Override
    protected CharAppender newCharAppender() {
        return new DefaultCharAppender(this.getMaxCharsPerColumn(), this.emptyValue);
    }

    @Override
    protected CsvFormat createDefaultFormat() {
        return new CsvFormat();
    }

    public boolean isParseUnescapedQuotes() {
        return this.parseUnescapedQuotes;
    }

    public void setParseUnescapedQuotes(boolean parseUnescapedQuotes) {
        this.parseUnescapedQuotes = parseUnescapedQuotes;
    }

    public boolean isEscapeUnquotedValues() {
        return this.escapeUnquotedValues;
    }

    public void setEscapeUnquotedValues(boolean escapeUnquotedValues) {
        this.escapeUnquotedValues = escapeUnquotedValues;
    }

    public final boolean isKeepEscapeSequences() {
        return this.keepEscapeSequences;
    }

    public final void setKeepEscapeSequences(boolean keepEscapeSequences) {
        this.keepEscapeSequences = keepEscapeSequences;
    }

    public final boolean isDelimiterDetectionEnabled() {
        return this.delimiterDetectionEnabled;
    }

    public final void setDelimiterDetectionEnabled(boolean separatorDetectionEnabled) {
        this.delimiterDetectionEnabled = separatorDetectionEnabled;
    }

    public final boolean isQuoteDetectionEnabled() {
        return this.quoteDetectionEnabled;
    }

    public final void setQuoteDetectionEnabled(boolean quoteDetectionEnabled) {
        this.quoteDetectionEnabled = quoteDetectionEnabled;
    }

    public final void detectFormatAutomatically() {
        this.setDelimiterDetectionEnabled(true);
        this.setQuoteDetectionEnabled(true);
        this.setLineSeparatorDetectionEnabled(true);
    }

    public boolean isNormalizeLineEndingsWithinQuotes() {
        return this.normalizeLineEndingsWithinQuotes;
    }

    public void setNormalizeLineEndingsWithinQuotes(boolean normalizeLineEndingsWithinQuotes) {
        this.normalizeLineEndingsWithinQuotes = normalizeLineEndingsWithinQuotes;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        out.put("Empty value", this.emptyValue);
        out.put("Parse unescaped quotes", this.parseUnescapedQuotes);
        out.put("Escape unquoted values", this.escapeUnquotedValues);
        out.put("Keep escape sequences", this.keepEscapeSequences);
        out.put("Normalize escaped line separators", this.normalizeLineEndingsWithinQuotes);
        out.put("Autodetect column delimiter", this.delimiterDetectionEnabled);
        out.put("Autodetect quotes", this.quoteDetectionEnabled);
    }
}

