/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor;

import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ParsingContextWrapper;
import com.univocity.parsers.common.processor.ColumnOrderDependent;
import com.univocity.parsers.common.processor.NoopRowProcessor;
import com.univocity.parsers.common.processor.RowProcessor;
import java.util.HashMap;
import java.util.Map;

public abstract class RowProcessorSwitch
implements RowProcessor,
ColumnOrderDependent {
    private Map<RowProcessor, ParsingContextWrapper> rowProcessors;
    private RowProcessor selectedRowProcessor;
    private ParsingContextWrapper contextForProcessor;

    protected abstract RowProcessor switchRowProcessor(String[] var1, ParsingContext var2);

    public String[] getHeaders() {
        return null;
    }

    public int[] getIndexes() {
        return null;
    }

    public void rowProcessorSwitched(RowProcessor from, RowProcessor to) {
    }

    @Override
    public void processStarted(ParsingContext context) {
        this.rowProcessors = new HashMap<RowProcessor, ParsingContextWrapper>();
        this.selectedRowProcessor = NoopRowProcessor.instance;
    }

    @Override
    public final void rowProcessed(String[] row, final ParsingContext context) {
        RowProcessor processor = this.switchRowProcessor(row, context);
        if (processor == null) {
            processor = NoopRowProcessor.instance;
        }
        if (processor != this.selectedRowProcessor) {
            this.contextForProcessor = this.rowProcessors.get(processor);
            if (this.contextForProcessor == null) {
                this.contextForProcessor = new ParsingContextWrapper(context){
                    private final String[] fieldNames;
                    private final int[] indexes;
                    {
                        super(x0);
                        this.fieldNames = RowProcessorSwitch.this.getHeaders();
                        this.indexes = RowProcessorSwitch.this.getIndexes();
                    }

                    @Override
                    public String[] headers() {
                        return this.fieldNames == null || this.fieldNames.length == 0 ? context.headers() : this.fieldNames;
                    }

                    @Override
                    public int[] extractedFieldIndexes() {
                        return this.indexes == null || this.indexes.length == 0 ? context.extractedFieldIndexes() : this.indexes;
                    }
                };
                processor.processStarted(this.contextForProcessor);
                this.rowProcessors.put(processor, this.contextForProcessor);
            }
            if (this.selectedRowProcessor != NoopRowProcessor.instance) {
                this.rowProcessorSwitched(this.selectedRowProcessor, processor);
            }
            this.selectedRowProcessor = processor;
            if (this.getIndexes() != null) {
                int[] indexes = this.getIndexes();
                String[] tmp = new String[indexes.length];
                for (int i = 0; i < indexes.length; ++i) {
                    int index = indexes[i];
                    if (index >= row.length) continue;
                    tmp[i] = row[index];
                }
                row = tmp;
            }
            this.selectedRowProcessor.rowProcessed(row, this.contextForProcessor);
        } else {
            this.selectedRowProcessor.rowProcessed(row, this.contextForProcessor);
        }
    }

    @Override
    public void processEnded(ParsingContext context) {
        this.rowProcessorSwitched(this.selectedRowProcessor, null);
        this.selectedRowProcessor = NoopRowProcessor.instance;
        for (Map.Entry<RowProcessor, ParsingContextWrapper> e : this.rowProcessors.entrySet()) {
            e.getKey().processEnded(e.getValue());
        }
    }

    @Override
    public boolean preventColumnReordering() {
        return true;
    }
}

