/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.common.input.InputAnalysisProcess;
import com.univocity.parsers.common.input.NoopCharAppender;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvFormatDetector;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.UnescapedQuoteHandling;

public class CsvParser
extends AbstractParser<CsvParserSettings> {
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private boolean parseUnescapedQuotes;
    private boolean parseUnescapedQuotesUntilDelimiter;
    private final boolean doNotEscapeUnquotedValues;
    private final boolean keepEscape;
    private char delimiter;
    private char quote;
    private char quoteEscape;
    private final char escapeEscape;
    private final char newLine;
    private final DefaultCharAppender whitespaceAppender;
    private final boolean normalizeLineEndingsInQuotes;
    private UnescapedQuoteHandling quoteHandling;

    public CsvParser(CsvParserSettings settings) {
        super(settings);
        this.ignoreTrailingWhitespace = settings.getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = settings.getIgnoreLeadingWhitespaces();
        this.parseUnescapedQuotes = settings.isParseUnescapedQuotes();
        this.parseUnescapedQuotesUntilDelimiter = settings.isParseUnescapedQuotesUntilDelimiter();
        this.doNotEscapeUnquotedValues = !settings.isEscapeUnquotedValues();
        this.keepEscape = settings.isKeepEscapeSequences();
        this.normalizeLineEndingsInQuotes = settings.isNormalizeLineEndingsWithinQuotes();
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.delimiter = format.getDelimiter();
        this.quote = format.getQuote();
        this.quoteEscape = format.getQuoteEscape();
        this.escapeEscape = format.getCharToEscapeQuoteEscaping();
        this.newLine = format.getNormalizedNewline();
        this.whitespaceAppender = new DefaultCharAppender(settings.getMaxCharsPerColumn(), "");
        this.quoteHandling = settings.getUnescapedQuoteHandling();
        if (this.quoteHandling == null) {
            this.quoteHandling = this.parseUnescapedQuotes ? (this.parseUnescapedQuotesUntilDelimiter ? UnescapedQuoteHandling.STOP_AT_DELIMITER : UnescapedQuoteHandling.STOP_AT_CLOSING_QUOTE) : UnescapedQuoteHandling.RAISE_ERROR;
        } else {
            this.parseUnescapedQuotesUntilDelimiter = this.quoteHandling == UnescapedQuoteHandling.STOP_AT_DELIMITER || this.quoteHandling == UnescapedQuoteHandling.SKIP_VALUE;
            this.parseUnescapedQuotes = this.quoteHandling != UnescapedQuoteHandling.RAISE_ERROR;
        }
    }

    @Override
    protected void initialize() {
        this.input.setDelimiter(this.delimiter);
        this.input.setEscape(this.quote);
        this.input.setQuoteEscape(this.quoteEscape);
        this.input.setEscapeEscape(this.escapeEscape);
    }

    @Override
    protected void parseRecord() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.ch = this.input.skipWhitespace(this.ch);
        }
        while (this.ch != this.newLine) {
            if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
                this.ch = this.input.skipWhitespace(this.ch);
            }
            if (this.ch == this.delimiter) {
                this.output.emptyParsed();
            } else {
                if (this.ch == this.quote) {
                    if (this.normalizeLineEndingsInQuotes) {
                        this.parseQuotedValue('\u0000');
                    } else {
                        this.input.enableNormalizeLineEndings(false);
                        this.parseQuotedValue('\u0000');
                        this.input.enableNormalizeLineEndings(true);
                    }
                } else if (this.doNotEscapeUnquotedValues) {
                    this.ch = this.ignoreTrailingWhitespace ? this.input.appendIWUntilDelimiter(this.ch, this.output.appender) : this.input.appendUntilDelimiter(this.ch, this.output.appender);
                } else {
                    this.parseValueProcessingEscape('\u0000');
                }
                this.output.valueParsed();
            }
            if (this.ch == this.newLine) continue;
            this.ch = this.input.nextChar();
            if (this.ch != this.newLine) continue;
            this.output.emptyParsed();
        }
    }

    private void skipValue() {
        this.output.appender.reset();
        this.ch = this.input.appendUntilDelimiter(this.ch, NoopCharAppender.getInstance());
    }

    private void handleValueSkipping(boolean quoted) {
        switch (this.quoteHandling) {
            case SKIP_VALUE: {
                this.skipValue();
                break;
            }
            case RAISE_ERROR: {
                throw new TextParsingException(this.context, "Unescaped quote character '" + this.quote + "' inside " + (quoted ? "quoted" : "") + " value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
            }
        }
    }

    private void handleUnescapedQuoteInValue() {
        switch (this.quoteHandling) {
            case STOP_AT_CLOSING_QUOTE: 
            case STOP_AT_DELIMITER: {
                this.output.appender.append(this.quote);
                this.parseValueProcessingEscape(this.ch);
                break;
            }
            default: {
                this.handleValueSkipping(false);
            }
        }
    }

    private boolean handleUnescapedQuote() {
        switch (this.quoteHandling) {
            case STOP_AT_CLOSING_QUOTE: 
            case STOP_AT_DELIMITER: {
                this.output.appender.append(this.quote);
                this.output.appender.append(this.ch);
                this.parseQuotedValue(this.ch);
                return true;
            }
        }
        this.handleValueSkipping(true);
        return false;
    }

    private void parseValueProcessingEscape(char prev) {
        if (this.ignoreTrailingWhitespace) {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    if (prev == this.quote) {
                        this.handleUnescapedQuoteInValue();
                        return;
                    }
                    this.output.appender.appendIgnoringWhitespace(this.ch);
                } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                    if (this.keepEscape) {
                        this.output.appender.appendIgnoringWhitespace(this.escapeEscape);
                    }
                    this.output.appender.appendIgnoringWhitespace(this.quoteEscape);
                    this.ch = '\u0000';
                } else if (prev == this.quoteEscape) {
                    if (this.ch == this.quote) {
                        if (this.keepEscape) {
                            this.output.appender.appendIgnoringWhitespace(this.quoteEscape);
                        }
                        this.output.appender.appendIgnoringWhitespace(this.quote);
                        this.ch = '\u0000';
                    } else {
                        this.output.appender.appendIgnoringWhitespace(prev);
                    }
                } else if (this.ch == this.quote && prev == this.quote) {
                    this.output.appender.appendIgnoringWhitespace(this.quote);
                }
                prev = this.ch;
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    if (prev == this.quote) {
                        this.handleUnescapedQuoteInValue();
                        break;
                    }
                    this.output.appender.append(this.ch);
                } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                    if (this.keepEscape) {
                        this.output.appender.append(this.escapeEscape);
                    }
                    this.output.appender.append(this.quoteEscape);
                    this.ch = '\u0000';
                } else if (prev == this.quoteEscape) {
                    if (this.ch == this.quote) {
                        if (this.keepEscape) {
                            this.output.appender.append(this.quoteEscape);
                        }
                        this.output.appender.append(this.quote);
                        this.ch = '\u0000';
                    } else {
                        this.output.appender.append(prev);
                    }
                } else if (this.ch == this.quote && prev == this.quote) {
                    this.output.appender.appendIgnoringWhitespace(this.quote);
                }
                prev = this.ch;
                this.ch = this.input.nextChar();
            }
        }
    }

    private void parseQuotedValue(char prev) {
        if (prev != '\u0000' && this.parseUnescapedQuotesUntilDelimiter) {
            if (this.quoteHandling == UnescapedQuoteHandling.SKIP_VALUE) {
                this.skipValue();
                return;
            }
            this.output.appender.prepend(this.quote);
            this.ch = this.input.nextChar();
            this.ch = this.ignoreTrailingWhitespace ? this.input.appendIWUntilDelimiter(this.ch, this.output.appender) : this.input.appendUntilDelimiter(this.ch, this.output.appender);
            return;
        }
        while (true) {
            this.ch = this.input.nextChar();
            if (prev == this.quote && (this.ch <= ' ' || this.ch == this.delimiter || this.ch == this.newLine)) break;
            if (this.ch != this.quote && this.ch != this.quoteEscape) {
                if (prev == this.quote) {
                    if (this.handleUnescapedQuote()) break;
                    return;
                }
                this.ch = this.input.appendUtilAnyEscape(this.ch, this.output.appender);
            } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                if (this.keepEscape) {
                    this.output.appender.append(this.escapeEscape);
                }
                this.output.appender.append(this.quoteEscape);
                this.ch = '\u0000';
            } else if (prev == this.quoteEscape) {
                if (this.ch == this.quote) {
                    if (this.keepEscape) {
                        this.output.appender.append(this.quoteEscape);
                    }
                    this.output.appender.append(this.quote);
                    this.ch = '\u0000';
                } else {
                    this.output.appender.append(prev);
                }
            } else if (this.ch == this.quote && prev == this.quote) {
                this.output.appender.append(this.quote);
            }
            prev = this.ch;
        }
        if (this.ch != this.delimiter && this.ch != this.newLine && this.ch <= ' ') {
            this.whitespaceAppender.reset();
            do {
                this.whitespaceAppender.append(this.ch);
                this.ch = this.input.nextChar();
                if (this.ch != this.newLine) continue;
                return;
            } while (this.ch <= ' ');
            if (this.ch != this.delimiter && this.parseUnescapedQuotes) {
                if (this.output.appender instanceof DefaultCharAppender) {
                    this.output.appender.append(this.quote);
                    ((DefaultCharAppender)this.output.appender).append(this.whitespaceAppender);
                }
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    this.output.appender.append(this.ch);
                }
                this.parseQuotedValue(this.ch);
            }
        }
        if (this.ch != this.delimiter && this.ch != this.newLine) {
            throw new TextParsingException(this.context, "Unexpected character '" + this.ch + "' following quoted value of CSV field. Expecting '" + this.delimiter + "'. Cannot parse CSV input.");
        }
    }

    @Override
    protected InputAnalysisProcess getInputAnalysisProcess() {
        if (((CsvParserSettings)this.settings).isDelimiterDetectionEnabled() || ((CsvParserSettings)this.settings).isQuoteDetectionEnabled()) {
            return new CsvFormatDetector(20, (CsvParserSettings)this.settings){

                @Override
                void apply(char delimiter, char quote, char quoteEscape) {
                    if (((CsvParserSettings)CsvParser.this.settings).isDelimiterDetectionEnabled()) {
                        CsvParser.this.delimiter = delimiter;
                    }
                    if (((CsvParserSettings)CsvParser.this.settings).isQuoteDetectionEnabled()) {
                        CsvParser.this.quote = quote;
                        CsvParser.this.quoteEscape = quoteEscape;
                    }
                }
            };
        }
        return null;
    }

    public final CsvFormat getDetectedFormat() {
        CsvFormat out = null;
        if (((CsvParserSettings)this.settings).isDelimiterDetectionEnabled()) {
            out = ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone();
            out.setDelimiter(this.delimiter);
        }
        if (((CsvParserSettings)this.settings).isQuoteDetectionEnabled()) {
            out = out == null ? ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone() : out;
            out.setQuote(this.quote);
            out.setQuoteEscape(this.quoteEscape);
        }
        if (((CsvParserSettings)this.settings).isLineSeparatorDetectionEnabled()) {
            out = out == null ? ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone() : out;
            out.setLineSeparator(this.input.getLineSeparator());
        }
        return out;
    }
}

