/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.NoopCharAppender;
import java.util.Arrays;

public class ParserOutput {
    int column = 0;
    private final String[] parsedValues;
    private final CharAppender[] appenders;
    private final CommonParserSettings<?> settings;
    private final boolean skipEmptyLines;
    private final String nullValue;
    public CharAppender appender;
    private boolean columnsToExtractInitialized;
    private boolean columnsReordered;
    private String[] headers;
    private int[] selectedIndexes;
    private long currentRecord;
    public boolean trim = false;
    String[] parsedHeaders;

    public ParserOutput(CommonParserSettings<?> settings) {
        this.appender = settings.newCharAppender();
        this.parsedValues = new String[settings.getMaxColumns()];
        this.appenders = new CharAppender[settings.getMaxColumns()];
        Arrays.fill(this.appenders, this.appender);
        this.settings = settings;
        this.skipEmptyLines = settings.getSkipEmptyLines();
        this.nullValue = settings.getNullValue();
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0L;
    }

    void initializeHeaders() {
        this.columnsToExtractInitialized = true;
        this.columnsReordered = false;
        this.selectedIndexes = null;
        this.appender = this.settings.newCharAppender();
        Arrays.fill(this.appenders, this.appender);
        this.headers = this.settings.getHeaders();
        if (this.headers != null) {
            this.headers = (String[])this.headers.clone();
            this.initializeColumnsToExtract(this.headers);
        } else if (this.column > 0) {
            this.initializeColumnsToExtract(Arrays.copyOf(this.parsedValues, this.column));
            this.parsedHeaders = new String[this.column];
            System.arraycopy(this.parsedValues, 0, this.parsedHeaders, 0, this.column);
            if (this.settings.isHeaderExtractionEnabled()) {
                this.headers = (String[])this.parsedHeaders.clone();
            }
        }
    }

    public String[] rowParsed() {
        if (this.column > 0) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
                if (this.settings.isHeaderExtractionEnabled()) {
                    Arrays.fill(this.parsedValues, null);
                    this.column = 0;
                    this.appender = this.appenders[0];
                    return null;
                }
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                String[] reorderedValues = new String[this.selectedIndexes.length];
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    int index = this.selectedIndexes[i];
                    reorderedValues[i] = index >= this.column || index == -1 ? this.nullValue : this.parsedValues[index];
                }
                this.column = 0;
                this.appender = this.appenders[0];
                return reorderedValues;
            }
            String[] out = new String[this.column];
            System.arraycopy(this.parsedValues, 0, out, 0, this.column);
            this.column = 0;
            this.appender = this.appenders[0];
            return out;
        }
        if (!this.skipEmptyLines) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                Object[] out = new String[this.selectedIndexes.length];
                Arrays.fill(out, this.nullValue);
                return out;
            }
            return ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        return null;
    }

    private void initializeColumnsToExtract(String[] values) {
        FieldSelector selector = this.settings.getFieldSelector();
        if (selector != null) {
            this.selectedIndexes = selector.getFieldIndexes(values);
            if (this.selectedIndexes != null) {
                Arrays.fill(this.appenders, NoopCharAppender.getInstance());
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    int index = this.selectedIndexes[i];
                    if (index == -1) continue;
                    this.appenders[index] = this.appender;
                }
                this.columnsReordered = this.settings.isColumnReorderingEnabled();
                if (!this.columnsReordered && values.length < this.appenders.length) {
                    Arrays.fill(this.appenders, values.length, this.appenders.length, this.appender);
                }
            }
        }
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int[] getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public boolean isColumnReorderingEnabled() {
        return this.columnsReordered;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void emptyParsed() {
        this.parsedValues[this.column++] = this.nullValue;
        this.appender = this.appenders[this.column];
    }

    public void valueParsed() {
        if (this.trim) {
            this.appender.updateWhitespace();
        }
        this.parsedValues[this.column++] = this.appender.getAndReset();
        this.appender = this.appenders[this.column];
    }

    public long getCurrentRecord() {
        return this.currentRecord;
    }

    public final void discardValues() {
        this.column = 0;
        this.appender = this.appenders[0];
    }

    final void reset() {
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0L;
        this.column = 0;
        this.headers = null;
    }
}

