/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.input.CharAppender;
import java.util.Arrays;

public class DefaultCharAppender
implements CharAppender {
    final char[] emptyChars;
    char[] chars;
    int index = 0;
    final String emptyValue;
    int whitespaceCount = 0;

    public DefaultCharAppender(int maxLength, String emptyValue) {
        this.chars = new char[maxLength];
        this.emptyValue = emptyValue;
        this.emptyChars = (char[])(emptyValue == null ? null : emptyValue.toCharArray());
    }

    @Override
    public void appendIgnoringPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch == padding ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch, char padding) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch <= ' ' || ch == padding ? ++this.whitespaceCount : 0;
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        this.chars[this.index++] = ch;
        this.whitespaceCount = ch <= ' ' ? ++this.whitespaceCount : 0;
    }

    @Override
    public void append(char ch) {
        this.chars[this.index++] = ch;
    }

    @Override
    public final String getAndReset() {
        String out = this.emptyValue;
        if (this.index > this.whitespaceCount) {
            out = new String(this.chars, 0, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    public final String toString() {
        if (this.index <= this.whitespaceCount) {
            return this.emptyValue;
        }
        return new String(this.chars, 0, this.index - this.whitespaceCount);
    }

    @Override
    public final int length() {
        return this.index - this.whitespaceCount;
    }

    @Override
    public final char[] getCharsAndReset() {
        char[] out = this.emptyChars;
        if (this.index > this.whitespaceCount) {
            out = Arrays.copyOf(this.chars, this.index - this.whitespaceCount);
        }
        this.index = 0;
        this.whitespaceCount = 0;
        return out;
    }

    @Override
    public final int whitespaceCount() {
        return this.whitespaceCount;
    }

    @Override
    public final void reset() {
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void append(DefaultCharAppender appender) {
        System.arraycopy(appender.chars, 0, this.chars, this.index, appender.index - appender.whitespaceCount);
        this.index += appender.index - appender.whitespaceCount;
        appender.reset();
    }

    @Override
    public final void resetWhitespaceCount() {
        this.whitespaceCount = 0;
    }

    @Override
    public final char[] getChars() {
        return this.chars;
    }

    @Override
    public void fill(char ch, int length) {
        for (int i = 0; i < length; ++i) {
            this.chars[this.index++] = ch;
        }
    }

    @Override
    public final void prepend(char ch) {
        System.arraycopy(this.chars, 0, this.chars, 1, this.index);
        this.chars[0] = ch;
        ++this.index;
    }

    @Override
    public final void updateWhitespace() {
        this.whitespaceCount = 0;
        int i = this.index - 1;
        while (i >= 0 && this.chars[i] <= ' ') {
            --i;
            ++this.whitespaceCount;
        }
    }
}

