/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.annotations.helpers;

import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.beans.PropertyWrapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class FieldMapping {
    private final Field field;
    private int index;
    private String fieldName;
    private final Class<?> beanClass;
    private final Method readMethod;
    private final Method writeMethod;
    private boolean accessible = false;

    public FieldMapping(Class<?> beanClass, Field field, PropertyWrapper property) {
        this.beanClass = beanClass;
        this.field = field;
        this.readMethod = property != null ? property.getReadMethod() : null;
        this.writeMethod = property != null ? property.getWriteMethod() : null;
        this.determineFieldMapping();
    }

    private void determineFieldMapping() {
        Parsed parsed = this.field.getAnnotation(Parsed.class);
        String name = "";
        if (parsed != null) {
            this.index = parsed.index();
            if (this.index >= 0) {
                this.fieldName = null;
                return;
            }
            name = parsed.field();
        }
        if (name.isEmpty()) {
            name = this.field.getName();
        }
        this.fieldName = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldMapping that = (FieldMapping)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.field.equals(that.field)) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        return this.beanClass.equals(that.beanClass);
    }

    public int hashCode() {
        int result = this.field.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + (this.fieldName != null ? this.fieldName.hashCode() : 0);
        result = 31 * result + this.beanClass.hashCode();
        return result;
    }

    public boolean isMappedToIndex() {
        return this.index >= 0;
    }

    public boolean isMappedToField() {
        return this.index < 0;
    }

    public int getIndex() {
        return this.index;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Field getField() {
        return this.field;
    }

    private void setAccessible(Method accessor) {
        if (accessor == null && !this.accessible) {
            this.field.setAccessible(true);
            this.accessible = true;
        }
    }

    public Class<?> getFieldParent() {
        return this.field.getDeclaringClass();
    }

    public Class<?> getFieldType() {
        return this.field.getType();
    }

    public boolean canWrite(Object instance) {
        Class<?> declaringClass = this.writeMethod != null ? this.writeMethod.getDeclaringClass() : this.field.getDeclaringClass();
        return declaringClass.isAssignableFrom(instance.getClass());
    }

    public Object read(Object instance) {
        this.setAccessible(this.readMethod);
        try {
            if (this.readMethod != null) {
                return this.readMethod.invoke(instance, new Object[0]);
            }
            return this.field.get(instance);
        }
        catch (Throwable e) {
            throw new DataProcessingException("Unable to get value from field '" + this.field.getName() + "' in " + this.beanClass.getName(), e);
        }
    }

    public void write(Object instance, Object value) {
        this.setAccessible(this.writeMethod);
        try {
            if (this.writeMethod != null) {
                this.writeMethod.invoke(instance, value);
            } else {
                this.field.set(instance, value);
            }
        }
        catch (Throwable e) {
            DataProcessingException ex = new DataProcessingException("Unable to set value '{value}' of field '" + this.field.getName() + "' in " + this.beanClass.getName(), e);
            ex.setValue(value);
            ex.markAsNonFatal();
            ex.setValue(value);
            throw ex;
        }
    }
}

