/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.EntityFieldSelector;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.fields.EntityFieldSet;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.common.processor.core.NoopProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractEntityParserSettings<F extends Format, C extends Context>
extends CommonParserSettings<F> {
    protected final Map<String, Processor<C>> entityProcessors = new HashMap<String, Processor<C>>();
    protected final Set<String> entitiesToRead = new TreeSet<String>();
    protected final Set<String> entitiesToSkip = new TreeSet<String>();
    private final List<EntityFieldSet> entityFieldSets = new ArrayList<EntityFieldSet>();

    public AbstractEntityParserSettings() {
        this.setHeaderExtractionEnabled(false);
        this.setMaxCharsPerColumn(-1);
        this.setCommentCollectionEnabled(true);
    }

    private static String[] toArray(Collection<String> collection) {
        return collection == null ? ArgumentUtils.EMPTY_STRING_ARRAY : collection.toArray(new String[0]);
    }

    public final void setEntityProcessor(Processor<C> entityProcessor, Collection<String> entities) {
        this.setEntityProcessor(entityProcessor, AbstractEntityParserSettings.toArray(entities));
    }

    public final void setEntityProcessor(Processor<C> entityProcessor, String ... entities) {
        ArgumentUtils.noNulls("Names of entities to be processed", entities);
        ArgumentUtils.noNulls("Processor for entities " + Arrays.toString(entities), entityProcessor);
        for (String entity : entities) {
            this.addEntityProcessor(entityProcessor, entity);
        }
    }

    private void addEntityProcessor(Processor<C> entityProcessor, String entity) {
        ArgumentUtils.noNulls("Name of entity to be processed", entity);
        ArgumentUtils.noNulls("Processor for entity " + entity, entityProcessor);
        entity = ArgumentUtils.normalize(entity);
        this.entityProcessors.put(entity, entityProcessor);
    }

    public final void addEntitiesToRead(Collection<String> entitiesToRead) {
        this.addEntitiesToRead(AbstractEntityParserSettings.toArray(entitiesToRead));
    }

    public final void addEntitiesToRead(String ... entitiesToRead) {
        for (String entity : entitiesToRead) {
            ArgumentUtils.noNulls("Name of entity to be read", entity);
            this.entitiesToRead.add(entity);
        }
    }

    public final void addEntitiesToSkip(Collection<String> entitiesToSkip) {
        this.setEntitiesToSkip(AbstractEntityParserSettings.toArray(entitiesToSkip));
    }

    public final void setEntitiesToSkip(Collection<String> entitiesToSkip) {
        this.setEntitiesToSkip(AbstractEntityParserSettings.toArray(entitiesToSkip));
    }

    public final Set<String> getEntitiesToRead() {
        return Collections.unmodifiableSet(this.entitiesToRead);
    }

    public final void setEntitiesToRead(Collection<String> entitiesToRead) {
        this.setEntitiesToRead(AbstractEntityParserSettings.toArray(entitiesToRead));
    }

    public final void setEntitiesToRead(String ... entitiesToRead) {
        this.entitiesToRead.clear();
        this.addEntitiesToRead(entitiesToRead);
    }

    public final Set<String> getEntitiesToSkip() {
        return Collections.unmodifiableSet(this.entitiesToSkip);
    }

    public final void setEntitiesToSkip(String ... entitiesToSkip) {
        this.entitiesToSkip.clear();
        this.addEntitiesToSkip(entitiesToSkip);
    }

    public final void addEntitiesToSkip(String ... entitiesToSkip) {
        for (String entity : entitiesToSkip) {
            ArgumentUtils.noNulls("Name of entity to be skipped", entity);
            this.entitiesToSkip.add(entity);
        }
    }

    public Processor<?> getEntityProcessor(String entityName) {
        Processor<C> out = this.entityProcessors.get(entityName = ArgumentUtils.normalize(entityName));
        if (out == null) {
            return NoopProcessor.instance;
        }
        return out;
    }

    public final EntityFieldSet<String> selectFields(String ... fieldNames) {
        this.setHeaders(fieldNames);
        return this.newEntityFieldSet(super.selectFields(fieldNames));
    }

    private <T> EntityFieldSet<T> newEntityFieldSet(FieldSet<T> fieldSet) {
        if (!this.entityFieldSets.isEmpty()) {
            EntityFieldSet previous = this.entityFieldSets.get(this.entityFieldSets.size() - 1);
            ((EntityFieldSelector)previous).validate();
        }
        EntityFieldSelector<T> out = new EntityFieldSelector<T>(fieldSet);
        this.entityFieldSets.add(out);
        return out;
    }

    public final EntityFieldSet<String> excludeFields(String ... fieldNames) {
        return this.newEntityFieldSet(super.excludeFields(fieldNames));
    }

    public final EntityFieldSet<Integer> selectIndexes(Integer ... fieldIndexes) {
        return this.newEntityFieldSet(super.selectIndexes(fieldIndexes));
    }

    public final EntityFieldSet<Integer> excludeIndexes(Integer ... fieldIndexes) {
        return this.newEntityFieldSet(super.excludeIndexes(fieldIndexes));
    }

    protected Map<String, EntityFieldSet> getEntityFieldSelection() {
        if (this.entityFieldSets.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, EntityFieldSet> out = new HashMap<String, EntityFieldSet>();
        ArrayList<EntityFieldSet> reversed = new ArrayList<EntityFieldSet>(this.entityFieldSets);
        Collections.reverse(reversed);
        for (EntityFieldSet selection : reversed) {
            ((EntityFieldSelector)selection).validate();
            String entityName = selection.getEntityName();
            if (out.containsKey(entityName)) continue;
            out.put(ArgumentUtils.normalize(entityName), selection);
        }
        return out;
    }

    @Override
    protected void addConfiguration(Map<String, Object> out) {
        super.addConfiguration(out);
        for (Map.Entry<String, Processor<C>> entry : this.entityProcessors.entrySet()) {
            out.put("\tProcessor of " + entry.getKey(), entry.getValue().getClass().getName() + "(" + entry.getValue() + ")");
        }
        out.put("Entities to read", this.entitiesToRead.isEmpty() ? "all" : this.entitiesToRead);
        out.put("Entities to skip", this.entitiesToSkip.isEmpty() ? "none" : this.entitiesToSkip);
        for (Map.Entry<String, Object> entry : this.getEntityFieldSelection().entrySet()) {
            if (!this.printConfiguration(entry.getKey())) continue;
            out.put("\tField selection of " + entry.getKey(), ((EntityFieldSet)entry.getValue()).toString());
        }
    }

    protected boolean printConfiguration(String entityName) {
        return true;
    }

    public final boolean shouldSkip(String entityName) {
        return this.entitiesToSkip.contains(entityName) || !this.entitiesToRead.isEmpty() && !this.entitiesToRead.contains(entityName);
    }

    public final boolean shouldRead(String entityName) {
        return !this.entitiesToRead.isEmpty() && this.entitiesToRead.contains(entityName);
    }
}

