/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.AbstractException;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.DefaultConversionProcessor;
import com.univocity.parsers.common.DefaultParsingContext;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.LineReader;
import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.AbstractCharInputReader;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.DefaultCharInputReader;
import com.univocity.parsers.common.input.EOFException;
import com.univocity.parsers.common.input.InputAnalysisProcess;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.common.record.RecordFactory;
import com.univocity.parsers.common.record.RecordMetaData;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractParser<T extends CommonParserSettings<?>> {
    protected final T settings;
    protected final ParserOutput output;
    private final long recordsToRead;
    private final char comment;
    private final LineReader lineReader = new LineReader();
    protected ParsingContext context;
    protected Processor processor;
    protected CharInputReader input;
    protected char ch;
    private final ProcessorErrorHandler errorHandler;
    protected RecordFactory recordFactory;
    private final long rowsToSkip;
    protected final Map<Long, String> comments;
    protected String lastComment;
    private final boolean collectComments;
    private Record firstRecord;
    private final int errorContentLength;

    public AbstractParser(T settings) {
        ((CommonSettings)settings).autoConfigure();
        this.settings = settings;
        this.errorContentLength = ((CommonSettings)settings).getErrorContentLength();
        this.output = new ParserOutput((CommonParserSettings<?>)settings);
        this.processor = ((CommonParserSettings)settings).getProcessor();
        this.recordsToRead = ((CommonParserSettings)settings).getNumberOfRecordsToRead();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
        this.errorHandler = ((CommonSettings)settings).getProcessorErrorHandler();
        this.rowsToSkip = ((CommonParserSettings)settings).getNumberOfRowsToSkip();
        this.collectComments = ((CommonParserSettings)settings).isCommentCollectionEnabled();
        this.comments = this.collectComments ? new TreeMap() : Collections.emptyMap();
    }

    protected void processComment() {
        if (this.collectComments) {
            long line = this.input.lineCount();
            String comment = this.input.readComment();
            if (comment != null) {
                this.lastComment = comment;
                this.comments.put(line, this.lastComment);
            }
        } else {
            this.input.skipLines(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(Reader reader) {
        this.beginParsing(reader);
        try {
            while (!this.context.isStopped()) {
                this.ch = this.input.nextChar();
                if (this.inComment()) {
                    this.processComment();
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                if (this.recordsToRead >= 0L && this.context.currentRecord() >= this.recordsToRead) {
                    this.context.stop();
                    if (this.recordsToRead == 0L) {
                        this.stopParsing();
                        return;
                    }
                }
                this.rowProcessed(row);
            }
            this.stopParsing();
        }
        catch (EOFException ex) {
            try {
                this.handleEOF();
            }
            finally {
                this.stopParsing();
            }
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
        }
    }

    protected abstract void parseRecord();

    protected boolean consumeValueOnEOF() {
        return false;
    }

    private String[] handleEOF() {
        String[] row = null;
        try {
            boolean consumeValueOnEOF = this.consumeValueOnEOF();
            if (this.output.column != 0 || consumeValueOnEOF) {
                if (this.output.appender.length() > 0 || consumeValueOnEOF) {
                    this.output.valueParsed();
                } else {
                    this.output.emptyParsed();
                }
                row = this.output.rowParsed();
            } else if (this.output.appender.length() > 0) {
                this.output.valueParsed();
                row = this.output.rowParsed();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw this.handleException(e);
        }
        if (row != null) {
            this.rowProcessed(row);
        }
        return row;
    }

    public final void beginParsing(Reader reader) {
        this.output.reset();
        this.input = reader instanceof LineReader ? new DefaultCharInputReader(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparator(), ((Format)((CommonSettings)this.settings).getFormat()).getNormalizedNewline(), ((CommonParserSettings)this.settings).getInputBufferSize()) : ((CommonParserSettings)this.settings).newCharInputReader();
        this.input.enableNormalizeLineEndings(true);
        this.context = this.createParsingContext();
        if (this.processor instanceof DefaultConversionProcessor) {
            DefaultConversionProcessor conversionProcessor = (DefaultConversionProcessor)((Object)this.processor);
            conversionProcessor.errorHandler = this.errorHandler;
            conversionProcessor.context = this.context;
        }
        if (this.input instanceof AbstractCharInputReader) {
            ((AbstractCharInputReader)this.input).addInputAnalysisProcess(this.getInputAnalysisProcess());
        }
        this.input.start(reader);
        this.input.skipLines(this.rowsToSkip);
        this.recordFactory = new RecordFactory(this.context, this.errorContentLength);
        this.processor.processStarted(this.context);
        this.initialize();
    }

    protected ParsingContext createParsingContext() {
        DefaultParsingContext out = new DefaultParsingContext(this);
        out.stopped = false;
        return out;
    }

    protected void initialize() {
    }

    protected InputAnalysisProcess getInputAnalysisProcess() {
        return null;
    }

    private String getParsedContent(CharSequence tmp) {
        return "Parsed content: " + AbstractException.restrictContent(this.errorContentLength, tmp);
    }

    private TextParsingException handleException(Throwable ex) {
        if (ex instanceof DataProcessingException) {
            DataProcessingException error = (DataProcessingException)ex;
            error.restrictContent(this.errorContentLength);
            error.setContext(this.context);
            throw error;
        }
        String message = ex.getClass().getName() + " - " + ex.getMessage();
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            String tmp;
            int length = this.output.appender.length();
            if (length > chars.length) {
                message = "Length of parsed input (" + length + ") exceeds the maximum number of characters defined in" + " your parser settings (" + ((CommonSettings)this.settings).getMaxCharsPerColumn() + "). ";
                length = chars.length;
            }
            if ((tmp = new String(chars)).contains("\n") || tmp.contains("\r")) {
                tmp = AbstractParser.displayLineSeparators(tmp, true);
                String lineSeparator = AbstractParser.displayLineSeparators(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparatorString(), false);
                message = message + "\nIdentified line separator characters in the parsed content. This may be the cause of the error. The line separator in your parser settings is set to '" + lineSeparator + "'. " + this.getParsedContent(tmp);
            }
            int nullCharacterCount = 0;
            int maxLength = length > 0x3FFFFFFF ? 0x3FFFFFFE : length;
            StringBuilder s = new StringBuilder(maxLength);
            for (int i = 0; i < maxLength; ++i) {
                if (chars[i] == '\u0000') {
                    s.append('\\');
                    s.append('0');
                    ++nullCharacterCount;
                    continue;
                }
                s.append(chars[i]);
            }
            tmp = s.toString();
            if (nullCharacterCount > 0) {
                message = message + "\nIdentified " + nullCharacterCount + " null characters ('\u0000') on parsed content. This may " + "indicate the data is corrupt or its encoding is invalid. Parsed content:\n\t" + this.getParsedContent(tmp);
            }
        }
        if (ex instanceof ArrayIndexOutOfBoundsException) {
            try {
                int index = Integer.parseInt(ex.getMessage());
                if (index == ((CommonSettings)this.settings).getMaxCharsPerColumn()) {
                    message = message + "\nHint: Number of characters processed may have exceeded limit of " + index + " characters per column. Use settings.setMaxCharsPerColumn(int) to define the maximum number of characters a column can have";
                }
                if (index == ((CommonSettings)this.settings).getMaxColumns()) {
                    message = message + "\nHint: Number of columns processed may have exceeded limit of " + index + " columns. Use settings.setMaxColumns(int) to define the maximum number of columns your input can have";
                }
                message = message + "\nEnsure your configuration is correct, with delimiters, quotes and escape sequences that match the input format you are trying to parse";
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            if (!message.isEmpty()) {
                message = message + "\n";
            }
            message = message + "Parser Configuration: " + ((CommonSettings)this.settings).toString();
        }
        catch (Exception t) {
            // empty catch block
        }
        if (this.errorContentLength == 0) {
            this.output.appender.reset();
        }
        TextParsingException out = new TextParsingException(this.context, message, ex);
        out.setErrorContentLength(this.errorContentLength);
        return out;
    }

    private static String displayLineSeparators(String str, boolean addNewLine) {
        if (addNewLine) {
            str = str.contains("\r\n") ? str.replaceAll("\\r\\n", "[\\\\r\\\\n]\r\n\t") : (str.contains("\n") ? str.replaceAll("\\n", "[\\\\n]\n\t") : str.replaceAll("\\r", "[\\\\r]\r\t"));
        } else {
            str = str.replaceAll("\\n", "\\\\n");
            str = str.replaceAll("\\r", "\\\\r");
        }
        return str;
    }

    private void stopParsing(Throwable error) {
        if (error != null) {
            try {
                this.stopParsing();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            if (error instanceof DataProcessingException) {
                DataProcessingException ex = (DataProcessingException)error;
                ex.setContext(this.context);
                throw ex;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw new IllegalStateException(error.getMessage(), error);
        }
        this.stopParsing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopParsing() {
        try {
            this.context.stop();
        }
        finally {
            try {
                this.processor.processEnded(this.context);
            }
            finally {
                this.output.appender.reset();
                this.input.stop();
            }
        }
    }

    public final List<String[]> parseAll(Reader reader) {
        String[] row;
        ArrayList<String[]> out = new ArrayList<String[]>(10000);
        this.beginParsing(reader);
        while ((row = this.parseNext()) != null) {
            out.add(row);
        }
        return out;
    }

    protected boolean inComment() {
        return this.ch == this.comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseNext() {
        if (this.firstRecord != null) {
            String[] out = this.firstRecord.getValues();
            this.firstRecord = null;
            return out;
        }
        try {
            while (!this.context.isStopped()) {
                this.ch = this.input.nextChar();
                if (this.inComment()) {
                    this.processComment();
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                if (this.recordsToRead >= 0L && this.context.currentRecord() >= this.recordsToRead) {
                    this.context.stop();
                    if (this.recordsToRead == 0L) {
                        this.stopParsing();
                        return null;
                    }
                }
                this.rowProcessed(row);
                return row;
            }
            this.stopParsing();
            return null;
        }
        catch (EOFException ex) {
            String[] row = this.handleEOF();
            this.stopParsing();
            return row;
        }
        catch (NullPointerException ex) {
            if (this.context == null) {
                throw new IllegalStateException("Cannot parse without invoking method beginParsing(Reader) first");
            }
            if (this.input != null) {
                this.stopParsing();
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }

    protected final void reloadHeaders() {
        this.output.initializeHeaders();
        this.recordFactory = new RecordFactory(this.context, this.errorContentLength);
        if (this.context instanceof DefaultParsingContext) {
            ((DefaultParsingContext)this.context).reset();
        }
    }

    public final Record parseRecord(String line) {
        String[] values = this.parseLine(line);
        if (values == null) {
            return null;
        }
        return this.recordFactory.newRecord(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        this.lineReader.setLine(line);
        if (this.context == null || this.context.isStopped()) {
            this.beginParsing(this.lineReader);
        } else {
            ((DefaultCharInputReader)this.input).reloadBuffer();
        }
        try {
            while (!this.context.isStopped()) {
                this.ch = this.input.nextChar();
                if (this.inComment()) {
                    this.processComment();
                    return null;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.rowProcessed(row);
                return row;
            }
            return null;
        }
        catch (EOFException ex) {
            return this.handleEOF();
        }
        catch (NullPointerException ex) {
            if (this.input != null) {
                this.stopParsing(null);
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }

    private void rowProcessed(String[] row) {
        try {
            this.processor.rowProcessed(row, this.context);
        }
        catch (DataProcessingException ex) {
            ex.setContext(this.context);
            ex.setErrorContentLength(this.errorContentLength);
            if (ex.isFatal()) {
                throw ex;
            }
            this.errorHandler.handleError(ex, row, this.context);
        }
        catch (Throwable t) {
            DataProcessingException ex = new DataProcessingException("Unexpected error processing input row " + AbstractException.restrictContent(this.errorContentLength, Arrays.toString(row)) + " using RowProcessor " + this.processor.getClass().getName() + '.', AbstractException.restrictContent(this.errorContentLength, row), t);
            ex.restrictContent(this.errorContentLength);
            throw ex;
        }
    }

    public final void parse(File file) {
        this.parse(ArgumentUtils.newReader(file));
    }

    public final void parse(File file, String encoding) {
        this.parse(ArgumentUtils.newReader(file, encoding));
    }

    public final void parse(File file, Charset encoding) {
        this.parse(ArgumentUtils.newReader(file, encoding));
    }

    public final void parse(InputStream input) {
        this.parse(ArgumentUtils.newReader(input));
    }

    public final void parse(InputStream input, String encoding) {
        this.parse(ArgumentUtils.newReader(input, encoding));
    }

    public final void parse(InputStream input, Charset encoding) {
        this.parse(ArgumentUtils.newReader(input, encoding));
    }

    public final void beginParsing(File file) {
        this.beginParsing(ArgumentUtils.newReader(file));
    }

    public final void beginParsing(File file, String encoding) {
        this.beginParsing(ArgumentUtils.newReader(file, encoding));
    }

    public final void beginParsing(File file, Charset encoding) {
        this.beginParsing(ArgumentUtils.newReader(file, encoding));
    }

    public final void beginParsing(InputStream input) {
        this.beginParsing(ArgumentUtils.newReader(input));
    }

    public final void beginParsing(InputStream input, String encoding) {
        this.beginParsing(ArgumentUtils.newReader(input, encoding));
    }

    public final void beginParsing(InputStream input, Charset encoding) {
        this.beginParsing(ArgumentUtils.newReader(input, encoding));
    }

    public final List<String[]> parseAll(File file) {
        return this.parseAll(ArgumentUtils.newReader(file));
    }

    public final List<String[]> parseAll(File file, String encoding) {
        return this.parseAll(ArgumentUtils.newReader(file, encoding));
    }

    public final List<String[]> parseAll(File file, Charset encoding) {
        return this.parseAll(ArgumentUtils.newReader(file, encoding));
    }

    public final List<String[]> parseAll(InputStream input) {
        return this.parseAll(ArgumentUtils.newReader(input));
    }

    public final List<String[]> parseAll(InputStream input, String encoding) {
        return this.parseAll(ArgumentUtils.newReader(input, encoding));
    }

    public final List<String[]> parseAll(InputStream input, Charset encoding) {
        return this.parseAll(ArgumentUtils.newReader(input, encoding));
    }

    public final List<Record> parseAllRecords(File file) {
        return this.parseAllRecords(ArgumentUtils.newReader(file));
    }

    public final List<Record> parseAllRecords(File file, String encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(file, encoding));
    }

    public final List<Record> parseAllRecords(File file, Charset encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(file, encoding));
    }

    public final List<Record> parseAllRecords(InputStream input) {
        return this.parseAllRecords(ArgumentUtils.newReader(input));
    }

    public final List<Record> parseAllRecords(InputStream input, String encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(input, encoding));
    }

    public final List<Record> parseAllRecords(InputStream input, Charset encoding) {
        return this.parseAllRecords(ArgumentUtils.newReader(input, encoding));
    }

    public final List<Record> parseAllRecords(Reader reader) {
        Record record;
        ArrayList<Record> out = new ArrayList<Record>(10000);
        this.beginParsing(reader);
        while ((record = this.parseNextRecord()) != null) {
            out.add(record);
        }
        return out;
    }

    public final Record parseNextRecord() {
        if (this.firstRecord != null) {
            Record out = this.firstRecord;
            this.firstRecord = null;
            return out;
        }
        String[] row = this.parseNext();
        if (row != null) {
            return this.recordFactory.newRecord(row);
        }
        return null;
    }

    final Map<Long, String> getComments() {
        return this.comments;
    }

    final String getLastComment() {
        return this.lastComment;
    }

    final String[] getParsedHeaders() {
        return this.output.parsedHeaders;
    }

    public final ParsingContext getContext() {
        return this.context;
    }

    public final RecordMetaData getRecordMetadata() {
        if (this.recordFactory != null) {
            if (this.context.currentRecord() == 0L && this.context.headers() == null && ((CommonParserSettings)this.settings).isHeaderExtractionEnabled() && !this.context.isStopped()) {
                this.firstRecord = this.parseNextRecord();
            }
            return this.recordFactory.getRecordMetaData();
        }
        throw new IllegalStateException("No record metadata available. The parsing process has not been started yet.");
    }
}

