/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.NoopProcessorErrorHandler;
import com.univocity.parsers.common.NoopRowProcessorErrorHandler;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.RowProcessorErrorHandler;
import com.univocity.parsers.common.fields.ExcludeFieldEnumSelector;
import com.univocity.parsers.common.fields.ExcludeFieldIndexSelector;
import com.univocity.parsers.common.fields.ExcludeFieldNameSelector;
import com.univocity.parsers.common.fields.FieldEnumSelector;
import com.univocity.parsers.common.fields.FieldIndexSelector;
import com.univocity.parsers.common.fields.FieldNameSelector;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public abstract class CommonSettings<F extends Format> {
    private F format;
    private String nullValue = null;
    private int maxCharsPerColumn = 4096;
    private int maxColumns = 512;
    private boolean skipEmptyLines = true;
    private boolean ignoreTrailingWhitespaces = true;
    private boolean ignoreLeadingWhitespaces = true;
    private FieldSelector fieldSelector = null;
    private boolean autoConfigurationEnabled = true;
    private ProcessorErrorHandler<? extends Context> errorHandler;
    private int errorContentLength = -1;
    private String[] headers;

    public CommonSettings() {
        this.setFormat(this.createDefaultFormat());
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(String emptyValue) {
        this.nullValue = emptyValue;
    }

    public int getMaxCharsPerColumn() {
        return this.maxCharsPerColumn;
    }

    public void setMaxCharsPerColumn(int maxCharsPerColumn) {
        this.maxCharsPerColumn = maxCharsPerColumn;
    }

    public boolean getSkipEmptyLines() {
        return this.skipEmptyLines;
    }

    public void setSkipEmptyLines(boolean skipEmptyLines) {
        this.skipEmptyLines = skipEmptyLines;
    }

    public boolean getIgnoreTrailingWhitespaces() {
        return this.ignoreTrailingWhitespaces;
    }

    public void setIgnoreTrailingWhitespaces(boolean ignoreTrailingWhitespaces) {
        this.ignoreTrailingWhitespaces = ignoreTrailingWhitespaces;
    }

    public boolean getIgnoreLeadingWhitespaces() {
        return this.ignoreLeadingWhitespaces;
    }

    public void setIgnoreLeadingWhitespaces(boolean ignoreLeadingWhitespaces) {
        this.ignoreLeadingWhitespaces = ignoreLeadingWhitespaces;
    }

    public void setHeaders(String ... headers) {
        this.headers = headers == null || headers.length == 0 ? null : headers;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public F getFormat() {
        return this.format;
    }

    public void setFormat(F format) {
        if (format == null) {
            throw new IllegalArgumentException("Format cannot be null");
        }
        this.format = format;
    }

    public FieldSet<String> selectFields(String ... fieldNames) {
        return this.setFieldSet(new FieldNameSelector(), fieldNames);
    }

    public FieldSet<String> excludeFields(String ... fieldNames) {
        return this.setFieldSet(new ExcludeFieldNameSelector(), fieldNames);
    }

    public FieldSet<Integer> selectIndexes(Integer ... fieldIndexes) {
        return this.setFieldSet(new FieldIndexSelector(), fieldIndexes);
    }

    public FieldSet<Integer> excludeIndexes(Integer ... fieldIndexes) {
        return this.setFieldSet(new ExcludeFieldIndexSelector(), fieldIndexes);
    }

    public FieldSet<Enum> selectFields(Enum ... columns) {
        return this.setFieldSet(new FieldEnumSelector(), columns);
    }

    public FieldSet<Enum> excludeFields(Enum ... columns) {
        return this.setFieldSet(new ExcludeFieldEnumSelector(), columns);
    }

    private <T> FieldSet<T> setFieldSet(FieldSet<T> fieldSet, T ... values) {
        this.fieldSelector = (FieldSelector)((Object)fieldSet);
        fieldSet.add(values);
        return fieldSet;
    }

    FieldSet<?> getFieldSet() {
        return (FieldSet)((Object)this.fieldSelector);
    }

    FieldSelector getFieldSelector() {
        return this.fieldSelector;
    }

    public final boolean isAutoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public final void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
    }

    @Deprecated
    public RowProcessorErrorHandler getRowProcessorErrorHandler() {
        return this.errorHandler == null ? NoopRowProcessorErrorHandler.instance : (RowProcessorErrorHandler)this.errorHandler;
    }

    @Deprecated
    public void setRowProcessorErrorHandler(RowProcessorErrorHandler rowProcessorErrorHandler) {
        this.errorHandler = rowProcessorErrorHandler;
    }

    public <T extends Context> ProcessorErrorHandler<T> getProcessorErrorHandler() {
        return this.errorHandler == null ? NoopProcessorErrorHandler.instance : this.errorHandler;
    }

    public void setProcessorErrorHandler(ProcessorErrorHandler<? extends Context> processorErrorHandler) {
        this.errorHandler = processorErrorHandler;
    }

    protected abstract F createDefaultFormat();

    final void autoConfigure() {
        if (!this.autoConfigurationEnabled) {
            return;
        }
        this.runAutomaticConfiguration();
    }

    public final void trimValues(boolean trim) {
        this.setIgnoreLeadingWhitespaces(trim);
        this.setIgnoreTrailingWhitespaces(trim);
    }

    public int getErrorContentLength() {
        return this.errorContentLength;
    }

    public void setErrorContentLength(int errorContentLength) {
        this.errorContentLength = errorContentLength;
    }

    void runAutomaticConfiguration() {
    }

    public final String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.getClass().getSimpleName()).append(':');
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        this.addConfiguration(config);
        for (Map.Entry<String, Object> e : config.entrySet()) {
            out.append("\n\t");
            out.append(e.getKey()).append('=').append(e.getValue());
        }
        out.append("Format configuration:\n\t").append(((Format)this.getFormat()).toString());
        return out.toString();
    }

    protected void addConfiguration(Map<String, Object> out) {
        out.put("Null value", this.nullValue);
        out.put("Maximum number of characters per column", this.maxCharsPerColumn);
        out.put("Maximum number of columns", this.maxColumns);
        out.put("Skip empty lines", this.skipEmptyLines);
        out.put("Ignore trailing whitespaces", this.ignoreTrailingWhitespaces);
        out.put("Ignore leading whitespaces", this.ignoreLeadingWhitespaces);
        out.put("Selected fields", this.fieldSelector == null ? "none" : this.fieldSelector.describe());
        out.put("Headers", Arrays.toString(this.headers));
        out.put("Auto configuration enabled", this.autoConfigurationEnabled);
        out.put("RowProcessor error handler", this.errorHandler);
        out.put("Length of content displayed on error", this.errorContentLength);
        out.put("Restricting data in exceptions", this.errorContentLength == 0);
    }
}

