/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import java.util.Collection;
import java.util.List;

public abstract class EntityFieldSet<T>
extends FieldSet<T> {
    private final FieldSet<T> wrappedFieldSet;
    protected String entity;

    public EntityFieldSet(FieldSet<T> fieldSet) {
        this.wrappedFieldSet = fieldSet;
    }

    public final void of(String entity) {
        ArgumentUtils.noNulls("Entity associated with field selection " + super.describe(), entity);
        this.entity = entity;
    }

    @Override
    public final List<T> get() {
        this.validate();
        return this.wrappedFieldSet.get();
    }

    protected abstract void validate();

    @Override
    public final FieldSet<T> set(T ... fields) {
        return this.wrappedFieldSet.set(fields);
    }

    @Override
    public final FieldSet<T> add(T ... fields) {
        return this.wrappedFieldSet.add(fields);
    }

    @Override
    public final FieldSet<T> set(Collection<T> fields) {
        return this.wrappedFieldSet.set(fields);
    }

    @Override
    public final FieldSet<T> add(Collection<T> fields) {
        return this.wrappedFieldSet.add(fields);
    }

    @Override
    public final FieldSet<T> remove(T ... fields) {
        return this.wrappedFieldSet.remove(fields);
    }

    @Override
    public final FieldSet<T> remove(Collection<T> fields) {
        return this.wrappedFieldSet.remove(fields);
    }

    @Override
    public final String describe() {
        if (this.entity != null) {
            return "Entity " + this.entity + ", " + this.wrappedFieldSet.describe();
        }
        return this.wrappedFieldSet.describe();
    }

    protected final FieldSelector getWrappedFieldSelector() {
        return (FieldSelector)((Object)this.wrappedFieldSet);
    }

    public final String getEntityName() {
        return this.entity;
    }

    @Override
    public final String toString() {
        return this.describe();
    }
}

