/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.processor.core;

import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.ContextWrapper;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.processor.ColumnOrderDependent;
import com.univocity.parsers.common.processor.RowProcessor;
import com.univocity.parsers.common.processor.core.NoopProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProcessorSwitch<T extends Context>
implements Processor<T>,
ColumnOrderDependent {
    private Map<Processor, ContextWrapper> processors;
    private Processor selectedProcessor;
    private ContextWrapper contextForProcessor;

    protected abstract Processor<T> switchRowProcessor(String[] var1, T var2);

    public String[] getHeaders() {
        return null;
    }

    public int[] getIndexes() {
        return null;
    }

    public void processorSwitched(Processor<ParsingContext> from, Processor<ParsingContext> to) {
        if (from != null) {
            if (from instanceof RowProcessor && (to == null || to instanceof RowProcessor)) {
                this.rowProcessorSwitched((RowProcessor)from, (RowProcessor)to);
            }
        } else if (to != null && to instanceof RowProcessor) {
            this.rowProcessorSwitched((RowProcessor)from, (RowProcessor)to);
        }
    }

    public void rowProcessorSwitched(RowProcessor from, RowProcessor to) {
    }

    @Override
    public void processStarted(T context) {
        this.processors = new HashMap<Processor, ContextWrapper>();
        this.selectedProcessor = NoopProcessor.instance;
    }

    @Override
    public final void rowProcessed(String[] row, T context) {
        Processor processor = this.switchRowProcessor(row, context);
        if (processor == null) {
            processor = NoopProcessor.instance;
        }
        if (processor != this.selectedProcessor) {
            this.contextForProcessor = this.processors.get(processor);
            if (this.contextForProcessor == null) {
                this.contextForProcessor = new ContextWrapper((Context)context, (Context)context){
                    private final String[] fieldNames;
                    private final int[] indexes;
                    final /* synthetic */ Context val$context;
                    {
                        this.val$context = context;
                        super(x0);
                        this.fieldNames = AbstractProcessorSwitch.this.getHeaders();
                        this.indexes = AbstractProcessorSwitch.this.getIndexes();
                    }

                    @Override
                    public String[] headers() {
                        return this.fieldNames == null || this.fieldNames.length == 0 ? this.val$context.headers() : this.fieldNames;
                    }

                    @Override
                    public int[] extractedFieldIndexes() {
                        return this.indexes == null || this.indexes.length == 0 ? this.val$context.extractedFieldIndexes() : this.indexes;
                    }
                };
                processor.processStarted(this.contextForProcessor);
                this.processors.put(processor, this.contextForProcessor);
            }
            if (this.selectedProcessor != NoopProcessor.instance) {
                this.processorSwitched(this.selectedProcessor, processor);
            }
            this.selectedProcessor = processor;
            if (this.getIndexes() != null) {
                int[] indexes = this.getIndexes();
                String[] tmp = new String[indexes.length];
                for (int i = 0; i < indexes.length; ++i) {
                    int index = indexes[i];
                    if (index >= row.length) continue;
                    tmp[i] = row[index];
                }
                row = tmp;
            }
            this.selectedProcessor.rowProcessed(row, this.contextForProcessor);
        } else {
            this.selectedProcessor.rowProcessed(row, this.contextForProcessor);
        }
    }

    @Override
    public void processEnded(T context) {
        this.processorSwitched(this.selectedProcessor, null);
        this.selectedProcessor = NoopProcessor.instance;
        for (Map.Entry<Processor, ContextWrapper> e : this.processors.entrySet()) {
            e.getKey().processEnded((Context)e.getValue());
        }
    }

    @Override
    public boolean preventColumnReordering() {
        return true;
    }
}

