/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.annotations.helpers;

import com.univocity.parsers.annotations.BooleanString;
import com.univocity.parsers.annotations.Convert;
import com.univocity.parsers.annotations.Copy;
import com.univocity.parsers.annotations.EnumOptions;
import com.univocity.parsers.annotations.Format;
import com.univocity.parsers.annotations.Headers;
import com.univocity.parsers.annotations.LowerCase;
import com.univocity.parsers.annotations.NullString;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.annotations.Replace;
import com.univocity.parsers.annotations.Trim;
import com.univocity.parsers.annotations.UpperCase;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.beans.BeanHelper;
import com.univocity.parsers.common.beans.PropertyWrapper;
import com.univocity.parsers.conversions.BooleanConversion;
import com.univocity.parsers.conversions.Conversion;
import com.univocity.parsers.conversions.Conversions;
import com.univocity.parsers.conversions.EnumConversion;
import com.univocity.parsers.conversions.FormattedConversion;
import com.univocity.parsers.conversions.NumericConversion;
import com.univocity.parsers.conversions.ObjectConversion;
import com.univocity.parsers.conversions.ToStringConversion;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;

public class AnnotationHelper {
    private static AnnotatedElement lastProcessedElement;
    private static Class<? extends Annotation> lastProcessedAnnotationType;
    private static Annotation lastAnnotationFound;
    private static final Set<Class> javaLangAnnotationTypes;
    private static final Set<Class> customAnnotationTypes;

    private AnnotationHelper() {
    }

    private static String getNullValue(String defaultValue) {
        if ("null".equals(defaultValue)) {
            return null;
        }
        if ("'null'".equals(defaultValue)) {
            return "null";
        }
        return defaultValue;
    }

    private static String getNullWriteValue(Parsed parsed) {
        if (parsed == null) {
            return null;
        }
        return AnnotationHelper.getNullValue(parsed.defaultNullWrite());
    }

    private static String getNullReadValue(Parsed parsed) {
        if (parsed == null) {
            return null;
        }
        return AnnotationHelper.getNullValue(parsed.defaultNullRead());
    }

    public static Conversion getConversion(Field field, Annotation annotation) {
        return AnnotationHelper.getConversion(field.getType(), field, annotation);
    }

    public static Conversion getConversion(Class classType, Annotation annotation) {
        return AnnotationHelper.getConversion(classType, null, annotation);
    }

    private static Conversion getConversion(Class fieldType, Field field, Annotation annotation) {
        try {
            Parsed parsed = field == null ? null : AnnotationHelper.findAnnotation(field, Parsed.class);
            Class<? extends Annotation> annType = annotation.annotationType();
            String nullRead = AnnotationHelper.getNullReadValue(parsed);
            String nullWrite = AnnotationHelper.getNullWriteValue(parsed);
            if (annType == NullString.class) {
                String[] nulls = ((NullString)annotation).nulls();
                return Conversions.toNull(nulls);
            }
            if (annType == EnumOptions.class) {
                if (!fieldType.isEnum()) {
                    if (field == null) {
                        throw new IllegalStateException("Invalid " + EnumOptions.class.getName() + " instance for converting class " + fieldType.getName() + ". Not an enum type.");
                    }
                    throw new IllegalStateException("Invalid " + EnumOptions.class.getName() + " annotation on attribute " + field.getName() + " of type " + field.getType().getName() + ". Attribute must be an enum type.");
                }
                EnumOptions enumOptions = (EnumOptions)annotation;
                String element = enumOptions.customElement().trim();
                if (element.isEmpty()) {
                    element = null;
                }
                Object nullReadValue = nullRead == null ? null : (Object)Enum.valueOf(fieldType, nullRead);
                return new EnumConversion<Object>((Class<Object>)fieldType, nullReadValue, nullWrite, element, enumOptions.selectors());
            }
            if (annType == Trim.class) {
                int length = ((Trim)annotation).length();
                if (length == -1) {
                    return Conversions.trim();
                }
                return Conversions.trim(length);
            }
            if (annType == LowerCase.class) {
                return Conversions.toLowerCase();
            }
            if (annType == UpperCase.class) {
                return Conversions.toUpperCase();
            }
            if (annType == Replace.class) {
                Replace replace = (Replace)annotation;
                return Conversions.replace(replace.expression(), replace.replacement());
            }
            if (annType == BooleanString.class) {
                Boolean valueForNull;
                if (fieldType != Boolean.TYPE && fieldType != Boolean.class) {
                    if (field == null) {
                        throw new DataProcessingException("Invalid  usage of " + BooleanString.class.getName() + ". Got type " + fieldType.getName() + " instead of boolean.");
                    }
                    throw new DataProcessingException("Invalid annotation: Field " + field.getName() + " has type " + fieldType.getName() + " instead of boolean.");
                }
                BooleanString boolString = (BooleanString)annotation;
                String[] falseStrings = boolString.falseStrings();
                String[] trueStrings = boolString.trueStrings();
                Boolean bl = valueForNull = nullRead == null ? null : BooleanConversion.getBoolean(nullRead, trueStrings, falseStrings);
                if (valueForNull == null && fieldType == Boolean.TYPE) {
                    valueForNull = Boolean.FALSE;
                }
                return Conversions.toBoolean(valueForNull, nullWrite, trueStrings, falseStrings);
            }
            if (annType == Format.class) {
                Format format = (Format)annotation;
                String[] formats = format.formats();
                ObjectConversion conversion = null;
                if (fieldType == BigDecimal.class) {
                    BigDecimal defaultForNull = nullRead == null ? null : new BigDecimal(nullRead);
                    conversion = Conversions.formatToBigDecimal(defaultForNull, nullWrite, formats);
                } else if (Number.class.isAssignableFrom(fieldType)) {
                    conversion = Conversions.formatToNumber(formats);
                    ((NumericConversion)conversion).setNumberType(fieldType);
                } else {
                    Date dateIfNull = null;
                    if (nullRead != null) {
                        if ("now".equalsIgnoreCase(nullRead)) {
                            dateIfNull = new Date();
                        } else {
                            if (formats.length == 0) {
                                throw new DataProcessingException("No format defined");
                            }
                            SimpleDateFormat sdf = new SimpleDateFormat(formats[0]);
                            dateIfNull = sdf.parse(nullRead);
                        }
                    }
                    if (Date.class == fieldType) {
                        conversion = Conversions.toDate(dateIfNull, nullWrite, formats);
                    } else if (Calendar.class == fieldType) {
                        Calendar calendarIfNull = null;
                        if (dateIfNull != null) {
                            calendarIfNull = Calendar.getInstance();
                            calendarIfNull.setTime(dateIfNull);
                        }
                        conversion = Conversions.toCalendar(calendarIfNull, nullWrite, formats);
                    }
                }
                if (conversion != null) {
                    Object[] options = format.options();
                    if (options.length > 0) {
                        if (conversion instanceof FormattedConversion) {
                            T[] formatters;
                            for (Object formatter : formatters = ((FormattedConversion)((Object)conversion)).getFormatterObjects()) {
                                AnnotationHelper.applyFormatSettings(formatter, (String[])options);
                            }
                        } else {
                            throw new DataProcessingException("Options '" + Arrays.toString(options) + "' not supported by conversion of type '" + conversion.getClass() + "'. It must implement " + FormattedConversion.class);
                        }
                    }
                    return conversion;
                }
            } else if (annType == Convert.class) {
                Convert convert = (Convert)annotation;
                String[] args = convert.args();
                Class<? extends Conversion> conversionClass = convert.conversionClass();
                if (!Conversion.class.isAssignableFrom(conversionClass)) {
                    throw new DataProcessingException("Not a valid conversion class: '" + conversionClass.getSimpleName() + "' (" + conversionClass.getName() + ')');
                }
                try {
                    Constructor<? extends Conversion> constructor = conversionClass.getConstructor(String[].class);
                    return constructor.newInstance(new Object[]{args});
                }
                catch (NoSuchMethodException e) {
                    throw new DataProcessingException("Could not find a public constructor with a String[] parameter in custom conversion class '" + conversionClass.getSimpleName() + "' (" + conversionClass.getName() + ')', (Throwable)e);
                }
                catch (Exception e) {
                    throw new DataProcessingException("Unexpected error instantiating custom conversion class '" + conversionClass.getSimpleName() + "' (" + conversionClass.getName() + ')', (Throwable)e);
                }
            }
            if (fieldType == String.class && (nullRead != null || nullWrite != null)) {
                return new ToStringConversion(nullRead, nullWrite);
            }
            return null;
        }
        catch (DataProcessingException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            if (field == null) {
                throw new DataProcessingException("Unexpected error identifying conversions to apply over type " + fieldType, ex);
            }
            throw new DataProcessingException("Unexpected error identifying conversions to apply over field " + field.getName() + " of class " + field.getDeclaringClass().getName(), ex);
        }
    }

    public static Conversion getDefaultConversion(Class fieldType, Parsed parsed) {
        String nullRead = AnnotationHelper.getNullReadValue(parsed);
        Comparable<Boolean> valueIfStringIsNull = null;
        ObjectConversion conversion = null;
        if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
            conversion = Conversions.toBoolean();
            valueIfStringIsNull = nullRead == null ? null : Boolean.valueOf(nullRead);
        } else if (fieldType == Character.class || fieldType == Character.TYPE) {
            conversion = Conversions.toChar();
            if (nullRead != null && nullRead.length() > 1) {
                throw new DataProcessingException("Invalid default value for character '" + nullRead + "'. It should contain one character only.");
            }
            valueIfStringIsNull = nullRead == null ? null : Character.valueOf(nullRead.charAt(0));
        } else if (fieldType == Byte.class || fieldType == Byte.TYPE) {
            conversion = Conversions.toByte();
            valueIfStringIsNull = nullRead == null ? null : Byte.valueOf(nullRead);
        } else if (fieldType == Short.class || fieldType == Short.TYPE) {
            conversion = Conversions.toShort();
            valueIfStringIsNull = nullRead == null ? null : Short.valueOf(nullRead);
        } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
            conversion = Conversions.toInteger();
            valueIfStringIsNull = nullRead == null ? null : Integer.valueOf(nullRead);
        } else if (fieldType == Long.class || fieldType == Long.TYPE) {
            conversion = Conversions.toLong();
            valueIfStringIsNull = nullRead == null ? null : Long.valueOf(nullRead);
        } else if (fieldType == Float.class || fieldType == Float.TYPE) {
            conversion = Conversions.toFloat();
            valueIfStringIsNull = nullRead == null ? null : Float.valueOf(nullRead);
        } else if (fieldType == Double.class || fieldType == Double.TYPE) {
            conversion = Conversions.toDouble();
            valueIfStringIsNull = nullRead == null ? null : Double.valueOf(nullRead);
        } else if (fieldType == BigInteger.class) {
            conversion = Conversions.toBigInteger();
            valueIfStringIsNull = nullRead == null ? null : new BigInteger(nullRead);
        } else if (fieldType == BigDecimal.class) {
            conversion = Conversions.toBigDecimal();
            valueIfStringIsNull = nullRead == null ? null : new BigDecimal(nullRead);
        } else if (Enum.class.isAssignableFrom(fieldType)) {
            conversion = Conversions.toEnum(fieldType);
        }
        if (conversion != null) {
            conversion.setValueIfStringIsNull(valueIfStringIsNull);
            conversion.setValueIfObjectIsNull(AnnotationHelper.getNullWriteValue(parsed));
        }
        return conversion;
    }

    public static Conversion getDefaultConversion(Field field) {
        Parsed parsed = AnnotationHelper.findAnnotation(field, Parsed.class);
        return AnnotationHelper.getDefaultConversion(field.getType(), parsed);
    }

    public static void applyFormatSettings(Object formatter, String[] propertiesAndValues) {
        if (propertiesAndValues.length == 0) {
            return;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (String setting : propertiesAndValues) {
            if (setting == null) {
                throw new DataProcessingException("Illegal format among: " + Arrays.toString(propertiesAndValues));
            }
            String[] pair = setting.split("=");
            if (pair.length != 2) {
                throw new DataProcessingException("Illegal format setting '" + setting + "' among: " + Arrays.toString(propertiesAndValues));
            }
            values.put(pair[0], pair[1]);
        }
        try {
            for (PropertyWrapper property : BeanHelper.getPropertyDescriptors(formatter.getClass())) {
                String name = property.getName();
                String value = (String)values.remove(name);
                if (value != null) {
                    AnnotationHelper.invokeSetter(formatter, property, value);
                }
                if (!"decimalFormatSymbols".equals(property.getName())) continue;
                DecimalFormatSymbols modifiedDecimalSymbols = new DecimalFormatSymbols();
                boolean modified = false;
                try {
                    for (PropertyWrapper prop : BeanHelper.getPropertyDescriptors(modifiedDecimalSymbols.getClass())) {
                        value = (String)values.remove(prop.getName());
                        if (value == null) continue;
                        AnnotationHelper.invokeSetter(modifiedDecimalSymbols, prop, value);
                        modified = true;
                    }
                    if (!modified) continue;
                    Method writeMethod = property.getWriteMethod();
                    if (writeMethod != null) {
                        writeMethod.invoke(formatter, modifiedDecimalSymbols);
                        continue;
                    }
                    throw new IllegalStateException("No write method defined for property " + property.getName());
                }
                catch (Throwable ex) {
                    throw new DataProcessingException("Error trying to configure decimal symbols  of formatter '" + formatter.getClass() + '.', ex);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!values.isEmpty()) {
            throw new DataProcessingException("Cannot find properties in formatter of type '" + formatter.getClass() + "': " + values);
        }
    }

    private static void invokeSetter(Object formatter, PropertyWrapper property, String value) {
        Method writeMethod = property.getWriteMethod();
        if (writeMethod == null) {
            DataProcessingException exception = new DataProcessingException("Cannot set property '" + property.getName() + "' of formatter '" + formatter.getClass() + "' to '{value}'. No setter defined");
            exception.setValue(value);
            throw exception;
        }
        Class<?> parameterType = writeMethod.getParameterTypes()[0];
        Object parameterValue = null;
        if (parameterType == String.class) {
            parameterValue = value;
        } else if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            parameterValue = Integer.parseInt(value);
        } else if (parameterType == Character.class || parameterType == Character.TYPE) {
            parameterValue = Character.valueOf(value.charAt(0));
        } else if (parameterType == Currency.class) {
            parameterValue = Currency.getInstance(value);
        } else if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
            parameterValue = Boolean.valueOf(value);
        } else if (parameterType == TimeZone.class) {
            parameterValue = TimeZone.getTimeZone(value);
        } else if (parameterType == DateFormatSymbols.class) {
            parameterValue = DateFormatSymbols.getInstance(new Locale(value));
        }
        if (parameterValue == null) {
            DataProcessingException exception = new DataProcessingException("Cannot set property '" + property.getName() + "' of formatter '" + formatter.getClass() + ". Cannot convert '{value}' to instance of " + parameterType);
            exception.setValue(value);
            throw exception;
        }
        try {
            writeMethod.invoke(formatter, parameterValue);
        }
        catch (Throwable e) {
            DataProcessingException exception = new DataProcessingException("Error setting property '" + property.getName() + "' of formatter '" + formatter.getClass() + ", with '{parameterValue}' (converted from '{value}')", e);
            exception.setValue("parameterValue", parameterValue);
            exception.setValue(value);
            throw exception;
        }
    }

    private static boolean allFieldsIndexOrNameBased(boolean searchName, Class<?> beanClass) {
        boolean hasAnnotation = false;
        for (Field field : AnnotationHelper.getAllFields(beanClass).keySet()) {
            Parsed annotation = AnnotationHelper.findAnnotation(field, Parsed.class);
            if (annotation == null) continue;
            hasAnnotation = true;
            if ((annotation.index() == -1 || !searchName) && (annotation.index() != -1 || searchName)) continue;
            return false;
        }
        return hasAnnotation;
    }

    public static boolean allFieldsIndexBased(Class<?> beanClass) {
        return AnnotationHelper.allFieldsIndexOrNameBased(false, beanClass);
    }

    public static boolean allFieldsNameBased(Class<?> beanClass) {
        return AnnotationHelper.allFieldsIndexOrNameBased(true, beanClass);
    }

    public static Integer[] getSelectedIndexes(Class<?> beanClass) {
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Field field : AnnotationHelper.getAllFields(beanClass).keySet()) {
            Parsed annotation = AnnotationHelper.findAnnotation(field, Parsed.class);
            if (annotation == null || annotation.index() == -1) continue;
            if (indexes.contains(annotation.index())) {
                throw new IllegalArgumentException("Duplicate field index '" + annotation.index() + "' found in attribute '" + field.getName() + "' of class " + beanClass.getName());
            }
            indexes.add(annotation.index());
        }
        return indexes.toArray(new Integer[indexes.size()]);
    }

    public static String[] deriveHeaderNamesFromFields(Class<?> beanClass) {
        List<Field> sequence = AnnotationHelper.getFieldSequence(beanClass);
        ArrayList<String> out = new ArrayList<String>(sequence.size());
        for (Field field : sequence) {
            if (field == null) {
                return ArgumentUtils.EMPTY_STRING_ARRAY;
            }
            out.add(AnnotationHelper.getHeaderName(field));
        }
        return out.toArray(new String[out.size()]);
    }

    public static String getHeaderName(Field field) {
        if (field == null) {
            return null;
        }
        Parsed annotation = AnnotationHelper.findAnnotation(field, Parsed.class);
        if (annotation != null) {
            if (annotation.field().isEmpty()) {
                return field.getName();
            }
            return annotation.field();
        }
        return null;
    }

    public static Headers findHeadersAnnotation(Class<?> beanClass) {
        Class<?> parent = beanClass;
        do {
            Headers headers;
            if ((headers = parent.getAnnotation(Headers.class)) != null) {
                return headers;
            }
            for (Class<?> iface : parent.getInterfaces()) {
                headers = AnnotationHelper.findHeadersAnnotation(iface);
                if (headers == null) continue;
                return headers;
            }
        } while ((parent = parent.getSuperclass()) != null);
        return null;
    }

    public static List<Field> getFieldSequence(Class beanClass) {
        Field[] fields;
        ArrayList<Field> tmp = new ArrayList<Field>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Field field : fields = AnnotationHelper.getAllFields(beanClass).keySet().toArray(new Field[0])) {
            Parsed annotation = AnnotationHelper.findAnnotation(field, Parsed.class);
            if (annotation == null) continue;
            if (annotation.index() != -1 && indexes.contains(annotation.index())) {
                throw new IllegalArgumentException("Duplicate field index found in attribute '" + field.getName() + "' of class " + beanClass.getName());
            }
            tmp.add(field);
            indexes.add(annotation.index());
        }
        int col = -1;
        Iterator i$ = indexes.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            if (i < 0 || i == ++col) continue;
            while (i >= tmp.size()) {
                tmp.add(null);
            }
            Collections.swap(tmp, i, col);
        }
        return tmp;
    }

    public static Map<Field, PropertyWrapper> getAllFields(Class<?> beanClass) {
        HashMap<String, PropertyWrapper> properties = new HashMap<String, PropertyWrapper>();
        try {
            for (PropertyWrapper property : BeanHelper.getPropertyDescriptors(beanClass)) {
                String name = property.getName();
                if (name == null) continue;
                properties.put(name, property);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        HashSet<String> used = new HashSet<String>();
        Class<?> clazz = beanClass;
        LinkedHashMap<Field, PropertyWrapper> out = new LinkedHashMap<Field, PropertyWrapper>();
        do {
            Field[] declared;
            for (Field field : declared = clazz.getDeclaredFields()) {
                if (used.contains(field.getName())) continue;
                used.add(field.getName());
                out.put(field, (PropertyWrapper)properties.get(field.getName()));
            }
        } while ((clazz = clazz.getSuperclass()) != null && clazz != Object.class);
        return out;
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        if (annotatedElement == null || annotationType == null) {
            return null;
        }
        if (annotatedElement.equals(lastProcessedElement) && annotationType == lastProcessedAnnotationType) {
            return (A)lastAnnotationFound;
        }
        lastProcessedElement = annotatedElement;
        lastProcessedAnnotationType = annotationType;
        Stack<Annotation> path = new Stack<Annotation>();
        Annotation annotation = (Annotation)AnnotationHelper.findAnnotation(annotatedElement, annotationType, new HashSet<Annotation>(), path);
        if (annotation == null || path.isEmpty()) {
            lastAnnotationFound = annotation;
            return (A)annotation;
        }
        while (!path.isEmpty()) {
            Annotation parent = path.pop();
            Annotation target = path.isEmpty() ? annotation : path.peek();
            for (Method method : parent.annotationType().getDeclaredMethods()) {
                Copy copy = method.getAnnotation(Copy.class);
                if (copy == null) continue;
                Class targetClass = copy.to();
                String targetProperty = copy.property();
                if (targetProperty.trim().isEmpty()) {
                    targetProperty = method.getName();
                }
                Object value = AnnotationHelper.invoke(parent, method);
                AnnotationHelper.setAnnotationValue(AnnotationHelper.getTargetAnnotation(annotatedElement, targetClass, target), targetProperty, value);
            }
        }
        lastAnnotationFound = annotation;
        return (A)annotation;
    }

    private static Annotation getTargetAnnotation(AnnotatedElement annotatedElement, Class targetClass, Annotation current) {
        if (targetClass == current.annotationType()) {
            return current;
        }
        throw new IllegalStateException("Can't process @Copy annotation on '" + current + "' of field '" + annotatedElement + "'.\n" + "Target class '" + targetClass.getName() + "' could not be found.");
    }

    private static void setAnnotationValue(Annotation annotation, String attribute, Object newValue) {
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        try {
            Field field = handler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            Map memberValues = (Map)field.get(handler);
            memberValues.put(attribute, newValue);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't process @Copy annotation to assign value '" + newValue + "' to attribute '" + attribute + "' of annotation " + annotation + ".", e);
        }
    }

    private static Object invoke(Annotation annotation, Method method) {
        try {
            return method.invoke((Object)annotation, (Object[])null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read value from annotation " + annotation, e);
        }
    }

    private static <A> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Annotation> visited, Stack<Annotation> path) {
        Annotation ann;
        int i;
        Annotation[] declaredAnnotations = annotatedElement.getDeclaredAnnotations();
        for (i = 0; i < declaredAnnotations.length; ++i) {
            ann = declaredAnnotations[i];
            if (ann.annotationType() != annotationType) continue;
            return (A)ann;
        }
        for (i = 0; i < declaredAnnotations.length; ++i) {
            ann = declaredAnnotations[i];
            if (!AnnotationHelper.isCustomAnnotation(ann) || !visited.add(ann)) continue;
            A annotation = AnnotationHelper.findAnnotation(ann.annotationType(), annotationType, visited, path);
            path.push(ann);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static boolean isCustomAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (customAnnotationTypes.contains(annotationType)) {
            return true;
        }
        if (javaLangAnnotationTypes.contains(annotationType)) {
            return false;
        }
        if (annotationType.getName().startsWith("java.lang.annotation")) {
            javaLangAnnotationTypes.add(annotationType);
            return false;
        }
        customAnnotationTypes.add(annotationType);
        return true;
    }

    public static List<Annotation> findAllAnnotationsInPackage(AnnotatedElement annotatedElement, Package aPackage) {
        ArrayList<Annotation> found = new ArrayList<Annotation>();
        AnnotationHelper.findAllAnnotationsInPackage(annotatedElement, aPackage, found, new HashSet<Annotation>());
        return found;
    }

    private static void findAllAnnotationsInPackage(AnnotatedElement annotatedElement, Package aPackage, ArrayList<? super Annotation> found, Set<Annotation> visited) {
        Annotation[] declaredAnnotations = annotatedElement.getDeclaredAnnotations();
        for (int i = 0; i < declaredAnnotations.length; ++i) {
            Annotation ann = declaredAnnotations[i];
            if (aPackage.equals(ann.annotationType().getPackage())) {
                found.add(ann);
            }
            if (!AnnotationHelper.isCustomAnnotation(ann) || !visited.add(ann)) continue;
            AnnotationHelper.findAllAnnotationsInPackage(ann.annotationType(), aPackage, found, visited);
        }
    }

    public static final Object getDefaultPrimitiveValue(Class type) {
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        return null;
    }

    static {
        javaLangAnnotationTypes = new HashSet<Class>();
        customAnnotationTypes = new HashSet<Class>();
    }
}

