/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input.concurrent;

import com.univocity.parsers.common.input.AbstractCharInputReader;
import com.univocity.parsers.common.input.concurrent.CharBucket;
import com.univocity.parsers.common.input.concurrent.ConcurrentCharLoader;
import java.io.Reader;

public class ConcurrentCharInputReader
extends AbstractCharInputReader {
    private ConcurrentCharLoader bucketLoader;
    private final int bucketSize;
    private final int bucketQuantity;

    public ConcurrentCharInputReader(char normalizedLineSeparator, int bucketSize, int bucketQuantity, int whitespaceRangeStart) {
        super(normalizedLineSeparator, whitespaceRangeStart);
        this.bucketSize = bucketSize;
        this.bucketQuantity = bucketQuantity;
    }

    public ConcurrentCharInputReader(char[] lineSeparator, char normalizedLineSeparator, int bucketSize, int bucketQuantity, int whitespaceRangeStart) {
        super(lineSeparator, normalizedLineSeparator, whitespaceRangeStart);
        this.bucketSize = bucketSize;
        this.bucketQuantity = bucketQuantity;
    }

    @Override
    public void stop() {
        if (this.bucketLoader != null) {
            this.bucketLoader.stopReading();
        }
    }

    @Override
    protected void setReader(Reader reader) {
        this.stop();
        this.bucketLoader = new ConcurrentCharLoader(reader, this.bucketSize, this.bucketQuantity);
    }

    @Override
    protected void reloadBuffer() {
        CharBucket currentBucket = this.bucketLoader.nextBucket();
        this.buffer = currentBucket.data;
        this.length = currentBucket.length;
    }
}

