/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer;

import com.vaadin.addon.jpacontainer.BatchableEntityProvider;
import com.vaadin.addon.jpacontainer.JPAContainer;
import com.vaadin.addon.jpacontainer.MutableEntityProvider;
import com.vaadin.data.Buffered;
import com.vaadin.data.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BufferedContainerDelegate<T>
implements Serializable {
    private static final long serialVersionUID = -4471665710680629463L;
    private JPAContainer<T> container;
    private List<Delta> deltaList = new LinkedList<Delta>();
    private List<Object> addedItemIdsCache = new ArrayList<Object>();
    private Map<Object, T> addedEntitiesCache = new HashMap<Object, T>();
    private Set<Object> deletedItemIdsCache = new HashSet<Object>();
    private Map<Object, T> updatedEntitiesCache = new HashMap<Object, T>();

    BufferedContainerDelegate(JPAContainer<T> container) {
        assert (container != null) : "container must not be null";
        this.container = container;
    }

    private T cloneEntityIfPossible(T entity) {
        if (entity instanceof Cloneable) {
            try {
                Method m = entity.getClass().getMethod("clone", new Class[0]);
                T clonedEntity = this.container.getEntityClass().cast(m.invoke(entity, new Object[0]));
                return clonedEntity;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return entity;
    }

    public List<Object> getAddedItemIds() {
        return Collections.unmodifiableList(this.addedItemIdsCache);
    }

    public Collection<Object> getDeletedItemIds() {
        return Collections.unmodifiableCollection(this.deletedItemIdsCache);
    }

    public Collection<Object> getUpdatedItemIds() {
        return Collections.unmodifiableCollection(this.updatedEntitiesCache.keySet());
    }

    public T getAddedEntity(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.addedEntitiesCache.get(itemId);
    }

    public T getUpdatedEntity(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.updatedEntitiesCache.get(itemId);
    }

    public boolean isAdded(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.addedEntitiesCache.containsKey(itemId);
    }

    public boolean isDeleted(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.deletedItemIdsCache.contains(itemId);
    }

    public boolean isUpdated(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        return this.updatedEntitiesCache.containsKey(itemId);
    }

    public boolean isModified() {
        return !this.deltaList.isEmpty();
    }

    private void clear() {
        this.deltaList.clear();
        this.addedEntitiesCache.clear();
        this.addedItemIdsCache.clear();
        this.updatedEntitiesCache.clear();
        this.deletedItemIdsCache.clear();
    }

    public void commit() throws Buffered.SourceException, Validator.InvalidValueException {
        assert (this.container.getEntityProvider() instanceof BatchableEntityProvider) : "entityProvider is not batchable";
        BatchableEntityProvider ep = (BatchableEntityProvider)this.container.getEntityProvider();
        ep.batchUpdate(new BatchableEntityProvider.BatchUpdateCallback<T>(){
            private static final long serialVersionUID = -5385980617323427732L;

            @Override
            public void batchUpdate(MutableEntityProvider<T> batchEnabledEntityProvider) {
                try {
                    for (Delta delta : BufferedContainerDelegate.this.deltaList) {
                        if (delta.type == DeltaType.ADD) {
                            batchEnabledEntityProvider.addEntity(delta.entity);
                            continue;
                        }
                        if (delta.type == DeltaType.UPDATE) {
                            batchEnabledEntityProvider.updateEntity(delta.entity);
                            continue;
                        }
                        if (delta.type != DeltaType.DELETE) continue;
                        batchEnabledEntityProvider.removeEntity(delta.itemId);
                    }
                }
                catch (Exception e) {
                    throw new Buffered.SourceException((Buffered)BufferedContainerDelegate.this.container, (Throwable)e);
                }
            }
        });
        this.clear();
    }

    public void discard() throws Buffered.SourceException {
        this.clear();
    }

    public Object addEntity(T entity) {
        assert (entity != null) : "entity must not be null";
        UUID uuid = UUID.randomUUID();
        this.deltaList.add(new Delta(DeltaType.ADD, uuid, this.cloneEntityIfPossible(entity)));
        this.addedEntitiesCache.put(uuid, entity);
        this.addedItemIdsCache.add(uuid);
        return uuid;
    }

    public void deleteItem(Object itemId) {
        assert (itemId != null) : "itemId must not be null";
        if (this.isAdded(itemId)) {
            this.addedEntitiesCache.remove(itemId);
            this.addedItemIdsCache.remove(itemId);
            for (int i = this.deltaList.size() - 1; i >= 0; --i) {
                if (!this.deltaList.get((int)i).itemId.equals(itemId)) continue;
                this.deltaList.remove(i);
            }
        } else {
            if (this.isUpdated(itemId)) {
                this.updatedEntitiesCache.remove(itemId);
                for (int i = this.deltaList.size() - 1; i >= 0; --i) {
                    if (!this.deltaList.get((int)i).itemId.equals(itemId)) continue;
                    this.deltaList.remove(i);
                }
            }
            this.deltaList.add(new Delta(DeltaType.DELETE, itemId, null));
            this.deletedItemIdsCache.add(itemId);
        }
    }

    public void updateEntity(Object itemId, T entity) {
        assert (entity != null) : "entity must not be null";
        assert (itemId != null) : "itemId must not be null";
        if (!this.isAdded(itemId)) {
            this.deltaList.add(new Delta(DeltaType.UPDATE, itemId, this.cloneEntityIfPossible(entity)));
            this.updatedEntitiesCache.put(itemId, entity);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Delta
    implements Serializable {
        private static final long serialVersionUID = -5907859901553818040L;
        final DeltaType type;
        final Object itemId;
        final T entity;

        Delta(DeltaType type, Object itemId, T entity) {
            this.type = type;
            this.itemId = itemId;
            this.entity = entity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DeltaType {
        ADD,
        UPDATE,
        DELETE;

    }
}

