/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer;

import com.vaadin.addon.jpacontainer.metadata.ClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.PersistentPropertyMetadata;
import com.vaadin.addon.jpacontainer.metadata.PropertyMetadata;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyList<T>
implements Serializable {
    private static final long serialVersionUID = 372287057799712177L;
    private ClassMetadata<T> metadata;
    private Set<String> propertyNames = new HashSet<String>();
    private Set<String> persistentPropertyNames = new HashSet<String>();
    private Set<String> nestedPropertyNames = new HashSet<String>();
    private Set<String> allPropertyNames = new HashSet<String>();
    private PropertyList<T> parentList;
    private Map<String, NestedProperty> nestedPropertyMap = new HashMap<String, NestedProperty>();

    public PropertyList(ClassMetadata<T> metadata) {
        assert (metadata != null) : "metadata must not be null";
        this.metadata = metadata;
        for (PropertyMetadata pm : metadata.getProperties()) {
            this.propertyNames.add(pm.getName());
            this.allPropertyNames.add(pm.getName());
            if (!(pm instanceof PersistentPropertyMetadata)) continue;
            this.persistentPropertyNames.add(pm.getName());
        }
    }

    public PropertyList(PropertyList<T> parentList) {
        assert (parentList != null) : "parentList must not be null";
        this.parentList = parentList;
        this.metadata = parentList.getClassMetadata();
    }

    public ClassMetadata<T> getClassMetadata() {
        return this.metadata;
    }

    public PropertyList<T> getParentList() {
        return this.parentList;
    }

    public void addNestedProperty(String propertyName) throws IllegalArgumentException {
        assert (propertyName != null) : "propertyName must not be null";
        if (propertyName.indexOf(46) == -1) {
            throw new IllegalArgumentException(propertyName + " is not nested");
        }
        if (this.getAllAvailablePropertyNames().contains(propertyName)) {
            return;
        }
        if (propertyName.endsWith("*")) {
            String parentPropertyName = propertyName.substring(0, propertyName.length() - 2);
            NestedProperty parentProperty = this.getNestedProperty(parentPropertyName);
            if (parentProperty.getMetadata() != null) {
                for (PropertyMetadata pm : parentProperty.getMetadata().getProperties()) {
                    String newName = parentPropertyName + "." + pm.getName();
                    if (this.getAllAvailablePropertyNames().contains(newName)) continue;
                    if (pm instanceof PersistentPropertyMetadata) {
                        this.persistentPropertyNames.add(newName);
                    }
                    this.propertyNames.add(newName);
                    this.allPropertyNames.add(newName);
                    this.nestedPropertyNames.add(newName);
                }
            } else {
                for (Method m : parentProperty.getType().getMethods()) {
                    if (!m.getName().startsWith("get") || Modifier.isStatic(m.getModifiers()) || m.getReturnType() == Void.TYPE || m.getDeclaringClass() == Object.class) continue;
                    String newName = parentPropertyName + "." + Introspector.decapitalize(m.getName().substring(3));
                    if (this.getAllAvailablePropertyNames().contains(newName)) continue;
                    this.propertyNames.add(newName);
                    this.nestedPropertyNames.add(newName);
                    this.allPropertyNames.add(newName);
                }
            }
        } else {
            NestedProperty np = this.getNestedProperty(propertyName);
            if (np.getKind() == NestedPropertyKind.PERSISTENT) {
                this.persistentPropertyNames.add(propertyName);
            }
            this.propertyNames.add(propertyName);
            this.nestedPropertyNames.add(propertyName);
            this.allPropertyNames.add(propertyName);
        }
    }

    private NestedProperty getNestedProperty(String propertyName) throws IllegalArgumentException {
        if (this.nestedPropertyMap.containsKey(propertyName)) {
            return this.nestedPropertyMap.get(propertyName);
        }
        try {
            if (propertyName.indexOf(46) != -1) {
                NestedProperty property;
                int offset = propertyName.lastIndexOf(46);
                String parentName = propertyName.substring(0, offset);
                String name = propertyName.substring(offset + 1);
                NestedProperty parentProperty = this.getNestedProperty(parentName);
                if (parentProperty.getMetadata() != null) {
                    PropertyMetadata pm = parentProperty.getMetadata().getProperty(name);
                    if (pm == null) {
                        throw new IllegalArgumentException("Invalid property name");
                    }
                    property = new NestedProperty(pm.getName(), parentProperty.getMetadata(), parentProperty);
                } else {
                    Method getter = this.getGetterMethod(name, parentProperty.getType());
                    if (getter == null) {
                        throw new IllegalArgumentException("Invalid property name");
                    }
                    property = new NestedProperty(name, getter, parentProperty);
                }
                this.nestedPropertyMap.put(propertyName, property);
                return property;
            }
            PropertyMetadata pm = this.metadata.getProperty(propertyName);
            if (pm == null) {
                throw new IllegalArgumentException("Invalid property name");
            }
            NestedProperty property = new NestedProperty(pm.getName(), this.metadata);
            this.nestedPropertyMap.put(propertyName, property);
            return property;
        }
        catch (IllegalArgumentException e) {
            if (this.parentList == null) {
                throw e;
            }
            return super.getNestedProperty(propertyName);
        }
    }

    private Method getGetterMethod(String prop, Class<?> parent) {
        String propertyName = prop.substring(0, 1).toUpperCase() + prop.substring(1);
        try {
            Method m = parent.getMethod("get" + propertyName, new Class[0]);
            if (m.getReturnType() != Void.TYPE) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public boolean removeProperty(String propertyName) {
        assert (propertyName != null) : "propertyName must not be null";
        boolean result = this.propertyNames.remove(propertyName);
        this.persistentPropertyNames.remove(propertyName);
        if (this.nestedPropertyNames.remove(propertyName)) {
            this.allPropertyNames.remove(propertyName);
        }
        return result;
    }

    public Set<String> getAllAvailablePropertyNames() {
        return Collections.unmodifiableSet(this.doGetAllAvailablePropertyNames());
    }

    private <E> Set<E> union(Set<E> ... sets) {
        HashSet<E> newSet = new HashSet<E>();
        for (Set<E> s : sets) {
            newSet.addAll(s);
        }
        return newSet;
    }

    protected Set<String> doGetAllAvailablePropertyNames() {
        if (this.parentList == null) {
            return this.allPropertyNames;
        }
        return this.union(this.allPropertyNames, this.parentList.doGetAllAvailablePropertyNames());
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.doGetPropertyNames());
    }

    protected Set<String> doGetPropertyNames() {
        if (this.parentList == null) {
            return this.propertyNames;
        }
        return this.union(this.propertyNames, this.parentList.doGetPropertyNames());
    }

    public Set<String> getPersistentPropertyNames() {
        return Collections.unmodifiableSet(this.doGetPersistentPropertyNames());
    }

    protected Set<String> doGetPersistentPropertyNames() {
        if (this.parentList == null) {
            return this.persistentPropertyNames;
        }
        return this.union(this.persistentPropertyNames, this.parentList.doGetPersistentPropertyNames());
    }

    public Set<String> getNestedPropertyNames() {
        return Collections.unmodifiableSet(this.doGetNestedPropertyNames());
    }

    protected Set<String> doGetNestedPropertyNames() {
        if (this.parentList == null) {
            return this.nestedPropertyNames;
        }
        return this.union(this.nestedPropertyNames, this.parentList.doGetNestedPropertyNames());
    }

    public Class<?> getPropertyType(String propertyName) throws IllegalArgumentException {
        assert (propertyName != null) : "propertyName must not be null";
        if (!this.getAllAvailablePropertyNames().contains(propertyName)) {
            throw new IllegalArgumentException("Illegal property name: " + propertyName);
        }
        if (propertyName.indexOf(46) != -1) {
            return this.getNestedProperty(propertyName).getType();
        }
        return this.metadata.getProperty(propertyName).getType();
    }

    public boolean isPropertyWritable(String propertyName) throws IllegalArgumentException {
        assert (propertyName != null) : "propertyName must not be null";
        if (!this.getAllAvailablePropertyNames().contains(propertyName)) {
            throw new IllegalArgumentException("Illegal property name: " + propertyName);
        }
        if (propertyName.indexOf(46) != -1) {
            return this.getNestedProperty(propertyName).isWritable();
        }
        return this.metadata.getProperty(propertyName).isWritable();
    }

    public Object getPropertyValue(T object, String propertyName) throws IllegalArgumentException {
        assert (propertyName != null) : "propertyName must not be null";
        assert (object != null) : "object must not be null";
        if (!this.getAllAvailablePropertyNames().contains(propertyName)) {
            throw new IllegalArgumentException("Illegal property name: " + propertyName);
        }
        return this.metadata.getPropertyValue(object, propertyName);
    }

    public void setPropertyValue(T object, String propertyName, Object propertyValue) throws IllegalArgumentException, IllegalStateException {
        assert (propertyName != null) : "propertyName must not be null";
        assert (object != null) : "object must not be null";
        if (!this.getAllAvailablePropertyNames().contains(propertyName)) {
            throw new IllegalArgumentException("Illegal property name: " + propertyName);
        }
        this.metadata.setPropertyValue(object, propertyName, propertyValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NestedProperty
    implements Serializable {
        private static final long serialVersionUID = -430502035392444897L;
        final NestedProperty parent;
        private final String name;
        final ClassMetadata<? extends Object> parentClassMetadata;
        final Method propertyGetterMethod;

        NestedProperty(String name, ClassMetadata<? extends Object> parentClassMetadata) {
            this.name = name;
            this.parentClassMetadata = parentClassMetadata;
            this.parent = null;
            this.propertyGetterMethod = null;
        }

        NestedProperty(String name, ClassMetadata<? extends Object> parentClassMetadata, NestedProperty parent) {
            this.name = name;
            this.parentClassMetadata = parentClassMetadata;
            this.parent = parent;
            this.propertyGetterMethod = null;
        }

        NestedProperty(String name, Method propertyGetterMethod, NestedProperty parent) {
            this.name = name;
            this.parentClassMetadata = null;
            this.parent = parent;
            this.propertyGetterMethod = propertyGetterMethod;
        }

        String getName() {
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.getName() + "." + this.name;
        }

        Class<?> getType() {
            if (this.parentClassMetadata != null) {
                return this.parentClassMetadata.getProperty(this.name).getType();
            }
            return this.propertyGetterMethod.getReturnType();
        }

        ClassMetadata<?> getMetadata() {
            PropertyMetadata pm;
            if (this.parentClassMetadata != null && (pm = this.parentClassMetadata.getProperty(this.name)) instanceof PersistentPropertyMetadata) {
                return ((PersistentPropertyMetadata)pm).getTypeMetadata();
            }
            return null;
        }

        NestedPropertyKind getKind() {
            if (this.parentClassMetadata != null && this.parentClassMetadata.getProperty(this.name) instanceof PersistentPropertyMetadata) {
                return NestedPropertyKind.PERSISTENT;
            }
            return NestedPropertyKind.TRANSIENT;
        }

        boolean isWritable() {
            if (this.parentClassMetadata != null) {
                return this.parentClassMetadata.getProperty(this.name).isWritable();
            }
            try {
                this.propertyGetterMethod.getDeclaringClass().getMethod("s" + this.propertyGetterMethod.getName().substring(1), this.getType());
                return true;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NestedPropertyKind {
        PERSISTENT,
        TRANSIENT;

    }
}

