/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.filter;

import com.vaadin.addon.jpacontainer.filter.AbstractPropertyFilter;
import com.vaadin.addon.jpacontainer.filter.IntervalFilter;
import java.util.Random;

public abstract class AbstractIntervalFilter
extends AbstractPropertyFilter
implements IntervalFilter {
    private static final long serialVersionUID = 2153303161748313563L;
    private Object endingPoint;
    private boolean endingPointIncluded;
    private String endingPointQLParameter;
    private Object startingPoint;
    private boolean startingPointIncluded;
    private String startingPointQLParameter;

    protected AbstractIntervalFilter(Object propertyId, Object startingPoint, boolean startingPointIncluded, Object endingPoint, boolean endingPointIncluded) {
        super(propertyId);
        assert (startingPoint != null) : "startingPoint must not be null";
        assert (endingPoint != null) : "endingPoint must not be null";
        int rnd = Math.abs(new Random().nextInt());
        this.startingPoint = startingPoint;
        this.startingPointIncluded = startingPointIncluded;
        this.startingPointQLParameter = propertyId.toString() + "_start" + rnd;
        this.endingPoint = endingPoint;
        this.endingPointIncluded = endingPointIncluded;
        this.endingPointQLParameter = propertyId.toString() + "_end" + rnd;
    }

    public Object getEndingPoint() {
        return this.endingPoint;
    }

    public String getEndingPointQLParameterName() {
        return this.endingPointQLParameter;
    }

    public Object getStartingPoint() {
        return this.startingPoint;
    }

    public String getStartingPointQLParameterName() {
        return this.startingPointQLParameter;
    }

    public boolean isEndingPointIncluded() {
        return this.endingPointIncluded;
    }

    public boolean isStartingPointIncluded() {
        return this.startingPointIncluded;
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AbstractIntervalFilter o = (AbstractIntervalFilter)obj;
            return o.endingPointIncluded == this.endingPointIncluded && o.startingPointIncluded == this.startingPointIncluded && o.endingPoint.equals(this.endingPoint) && o.startingPoint.equals(this.startingPoint);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + 7 * new Boolean(this.endingPointIncluded).hashCode() + 11 * new Boolean(this.startingPointIncluded).hashCode() + 3 * this.endingPoint.hashCode() + 5 * this.startingPoint.hashCode();
    }
}

