/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.filter.util;

import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.filter.CompositeFilter;
import com.vaadin.addon.jpacontainer.filter.Filters;
import com.vaadin.addon.jpacontainer.filter.JoinFilter;
import com.vaadin.addon.jpacontainer.filter.PropertyFilter;
import com.vaadin.data.Container;
import com.vaadin.data.util.filter.And;
import com.vaadin.data.util.filter.Compare;
import com.vaadin.data.util.filter.IsNull;
import com.vaadin.data.util.filter.Or;
import com.vaadin.data.util.filter.SimpleStringFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedFilterableSupport
implements Serializable {
    private static final long serialVersionUID = 398382431841547719L;
    private Collection<Object> filterablePropertyIds;
    private LinkedList<ApplyFiltersListener> listeners = new LinkedList();
    private LinkedList<Filter> appliedFilters = new LinkedList();
    private LinkedList<Filter> filters = new LinkedList();
    private boolean applyFiltersImmediately = true;
    private boolean unappliedFilters = false;

    public void addListener(ApplyFiltersListener listener) {
        assert (listener != null) : "listener must not be null";
        this.listeners.add(listener);
    }

    public void removeListener(ApplyFiltersListener listener) {
        assert (listener != null) : "listener must not be null";
        this.listeners.remove(listener);
    }

    protected void fireListeners() {
        LinkedList listenerList = (LinkedList)this.listeners.clone();
        for (ApplyFiltersListener l : listenerList) {
            l.filtersApplied(this);
        }
    }

    public Collection<Object> getFilterablePropertyIds() {
        if (this.filterablePropertyIds == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.filterablePropertyIds);
    }

    public void setFilterablePropertyIds(Collection<?> propertyIds) {
        assert (propertyIds != null) : "propertyIds must not be null";
        this.filterablePropertyIds = propertyIds;
    }

    public void setFilterablePropertyIds(Object ... propertyIds) {
        assert (propertyIds != null) : "propertyIds must not be null";
        this.setFilterablePropertyIds(Arrays.asList(propertyIds));
    }

    public boolean isFilterable(Object propertyId) {
        return this.getFilterablePropertyIds().contains(propertyId);
    }

    public boolean isValidFilter(Filter filter) {
        assert (filter != null) : "filter must not be null";
        if (filter instanceof JoinFilter) {
            return this.isFilterable(((JoinFilter)filter).getJoinProperty());
        }
        if (filter instanceof PropertyFilter) {
            return this.isFilterable(((PropertyFilter)filter).getPropertyId());
        }
        if (filter instanceof CompositeFilter) {
            for (Filter f : ((CompositeFilter)filter).getFilters()) {
                if (this.isValidFilter(f)) continue;
                return false;
            }
        }
        return true;
    }

    public void addFilter(Filter filter) throws IllegalArgumentException {
        if (!this.isValidFilter(filter)) {
            throw new IllegalArgumentException("Invalid filter");
        }
        this.filters.add(filter);
        if (this.isApplyFiltersImmediately()) {
            this.fireListeners();
        } else {
            this.unappliedFilters = true;
        }
    }

    public void removeFilter(Filter filter) {
        assert (filter != null) : "filter must not be null";
        if (this.filters.remove(filter)) {
            if (this.isApplyFiltersImmediately()) {
                this.fireListeners();
            } else {
                this.unappliedFilters = true;
            }
        }
    }

    public void removeAllFilters() {
        this.filters.clear();
        if (this.isApplyFiltersImmediately()) {
            this.fireListeners();
        } else {
            this.unappliedFilters = true;
        }
    }

    public List<Filter> getFilters() {
        return Collections.unmodifiableList(this.filters);
    }

    public List<Filter> getAppliedFilters() {
        return this.isApplyFiltersImmediately() ? this.getFilters() : Collections.unmodifiableList(this.appliedFilters);
    }

    public void setApplyFiltersImmediately(boolean applyFiltersImmediately) {
        this.applyFiltersImmediately = applyFiltersImmediately;
    }

    public boolean isApplyFiltersImmediately() {
        return this.applyFiltersImmediately;
    }

    public void applyFilters() {
        this.unappliedFilters = false;
        this.appliedFilters.clear();
        this.appliedFilters.addAll(this.filters);
        this.fireListeners();
    }

    public boolean hasUnappliedFilters() {
        return this.unappliedFilters;
    }

    public static Filter convertFilter(Container.Filter filter) {
        assert (filter != null) : "filter must not be null";
        if (filter instanceof And) {
            return Filters.and(AdvancedFilterableSupport.convertFilters(((And)filter).getFilters()));
        }
        if (filter instanceof Or) {
            return Filters.or(AdvancedFilterableSupport.convertFilters(((Or)filter).getFilters()));
        }
        if (filter instanceof Compare) {
            Compare compare = (Compare)filter;
            switch (compare.getOperation()) {
                case EQUAL: {
                    return Filters.eq(compare.getPropertyId(), compare.getValue());
                }
                case GREATER: {
                    return Filters.gt(compare.getPropertyId(), compare.getValue());
                }
                case GREATER_OR_EQUAL: {
                    return Filters.gteq(compare.getPropertyId(), compare.getValue());
                }
                case LESS: {
                    return Filters.lt(compare.getPropertyId(), compare.getValue());
                }
                case LESS_OR_EQUAL: {
                    return Filters.lteq(compare.getPropertyId(), compare.getValue());
                }
            }
        }
        if (filter instanceof IsNull) {
            return Filters.isNull(((IsNull)filter).getPropertyId());
        }
        if (filter instanceof SimpleStringFilter) {
            SimpleStringFilter stringFilter = (SimpleStringFilter)filter;
            String filterString = stringFilter.getFilterString();
            filterString = stringFilter.isOnlyMatchPrefix() ? filterString + "%" : "%" + filterString + "%";
            return Filters.like(stringFilter.getPropertyId(), filterString, !stringFilter.isIgnoreCase());
        }
        return null;
    }

    public static List<Filter> convertFilters(Collection<Container.Filter> filters) {
        ArrayList<Filter> result = new ArrayList<Filter>();
        for (Container.Filter filter : filters) {
            result.add(AdvancedFilterableSupport.convertFilter(filter));
        }
        return result;
    }

    public static interface ApplyFiltersListener
    extends Serializable {
        public void filtersApplied(AdvancedFilterableSupport var1);
    }
}

