/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.metadata;

import com.vaadin.addon.jpacontainer.metadata.PersistentPropertyMetadata;
import com.vaadin.addon.jpacontainer.metadata.PropertyMetadata;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMetadata<T>
implements Serializable {
    private static final long serialVersionUID = 2569781449737488799L;
    private final Class<T> mappedClass;
    private final Map<String, PropertyMetadata> allProperties = new LinkedHashMap<String, PropertyMetadata>();
    private final Map<String, PersistentPropertyMetadata> persistentProperties = new LinkedHashMap<String, PersistentPropertyMetadata>();

    ClassMetadata(Class<T> mappedClass) {
        assert (mappedClass != null) : "mappedClass must not be null";
        this.mappedClass = mappedClass;
    }

    final void addProperties(PropertyMetadata ... properties) {
        assert (properties != null) : "properties must not be null";
        for (PropertyMetadata pm : properties) {
            this.allProperties.put(pm.getName(), pm);
            if (pm instanceof PersistentPropertyMetadata) {
                this.persistentProperties.put(pm.getName(), (PersistentPropertyMetadata)pm);
                continue;
            }
            this.persistentProperties.remove(pm.getName());
        }
    }

    public Class<T> getMappedClass() {
        return this.mappedClass;
    }

    public Collection<PersistentPropertyMetadata> getPersistentProperties() {
        return Collections.unmodifiableCollection(this.persistentProperties.values());
    }

    public Collection<String> getPersistentPropertyNames() {
        return Collections.unmodifiableCollection(this.persistentProperties.keySet());
    }

    public Collection<PropertyMetadata> getProperties() {
        return Collections.unmodifiableCollection(this.allProperties.values());
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableCollection(this.allProperties.keySet());
    }

    public PropertyMetadata getProperty(String propertyName) {
        return this.allProperties.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getPropertyValue(T object, PropertyMetadata property) throws IllegalArgumentException {
        assert (object != null) : "object must not be null";
        assert (property != null) : "property must not be null";
        try {
            if (!(property instanceof PersistentPropertyMetadata)) return property.getter.invoke(object, new Object[0]);
            PersistentPropertyMetadata ppmd = (PersistentPropertyMetadata)property;
            if (ppmd.field == null) return property.getter.invoke(object, new Object[0]);
            try {
                ppmd.field.setAccessible(true);
                Object object2 = ppmd.field.get(object);
                return object2;
            }
            finally {
                ppmd.field.setAccessible(false);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access the property value", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot access the property value", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPropertyValue(T object, PropertyMetadata property, Object value) throws IllegalArgumentException {
        assert (object != null) : "object must not be null";
        assert (property != null) : "property must not be null";
        if (property != null && property.isWritable()) {
            try {
                if (property instanceof PersistentPropertyMetadata) {
                    PersistentPropertyMetadata ppmd = (PersistentPropertyMetadata)property;
                    if (ppmd.field != null) {
                        try {
                            ppmd.field.setAccessible(true);
                            ppmd.field.set(object, value);
                            return;
                        }
                        finally {
                            ppmd.field.setAccessible(false);
                        }
                    }
                }
                property.setter.invoke(object, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot set the property value", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot set the property value", e);
            }
        } else {
            throw new IllegalArgumentException("No such writable property: " + property.getName());
        }
    }

    protected Method getGetterMethod(String propertyName, Class<?> parent) {
        String methodName = "get" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method m = parent.getMethod(methodName, new Class[0]);
            if (m.getReturnType() != Void.TYPE) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    protected Method getSetterMethod(String propertyName, Class<?> parent, Class<?> propertyType) {
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method m = parent.getMethod(methodName, propertyType);
            if (m.getReturnType() == Void.TYPE) {
                return m;
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public Object getPropertyValue(T object, String propertyName) throws IllegalArgumentException {
        assert (object != null) : "object must not be null";
        assert (propertyName != null) : "propertyName must not be null";
        StringTokenizer st = new StringTokenizer(propertyName, ".");
        ClassMetadata<Object> typeMetadata = this;
        Class<?> type = null;
        Object currentObject = object;
        while (st.hasMoreTokens()) {
            String propName = st.nextToken();
            if (typeMetadata != null) {
                PropertyMetadata pmd = typeMetadata.getProperty(propName);
                if (pmd == null) {
                    throw new IllegalArgumentException("Invalid property name");
                }
                if ((currentObject = typeMetadata.getPropertyValue(currentObject, pmd)) == null) {
                    return null;
                }
                typeMetadata = pmd instanceof PersistentPropertyMetadata ? ((PersistentPropertyMetadata)pmd).getTypeMetadata() : null;
                if (typeMetadata == null) {
                    type = pmd.getType();
                    continue;
                }
                type = null;
                continue;
            }
            if (type == null) continue;
            Method getter = this.getGetterMethod(propName, type);
            if (getter == null) {
                throw new IllegalArgumentException("Invalid property name");
            }
            try {
                currentObject = getter.invoke(currentObject, new Object[0]);
                if (currentObject == null) {
                    return null;
                }
                type = getter.getReturnType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access a nested property", e);
            }
        }
        return currentObject;
    }

    public void setPropertyValue(T object, String propertyName, Object value) throws IllegalArgumentException, IllegalStateException {
        assert (object != null) : "object must not be null";
        assert (propertyName != null) : "propertyName must not be null";
        StringTokenizer st = new StringTokenizer(propertyName, ".");
        ClassMetadata<Object> typeMetadata = this;
        Class<?> type = null;
        Object currentObject = object;
        while (st.hasMoreTokens()) {
            String propName = st.nextToken();
            if (typeMetadata != null) {
                PropertyMetadata pmd = typeMetadata.getProperty(propName);
                if (pmd == null) {
                    throw new IllegalArgumentException("Invalid property name");
                }
                if (!st.hasMoreTokens()) {
                    typeMetadata.setPropertyValue(currentObject, pmd, value);
                    continue;
                }
                if ((currentObject = typeMetadata.getPropertyValue(currentObject, pmd)) == null) {
                    throw new IllegalStateException("A null value was found in the chain of nested properties");
                }
                typeMetadata = pmd instanceof PersistentPropertyMetadata ? ((PersistentPropertyMetadata)pmd).getTypeMetadata() : null;
                if (typeMetadata == null) {
                    type = pmd.getType();
                    continue;
                }
                type = null;
                continue;
            }
            if (type == null) continue;
            Method getter = this.getGetterMethod(propName, type);
            if (getter == null) {
                throw new IllegalArgumentException("Invalid property name");
            }
            if (!st.hasMoreTokens()) {
                Method setter = this.getSetterMethod(propName, type, getter.getReturnType());
                if (setter == null) {
                    throw new IllegalArgumentException("Property is read only");
                }
                try {
                    setter.invoke(currentObject, value);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not set the value");
                }
            }
            try {
                currentObject = getter.invoke(currentObject, new Object[0]);
                if (currentObject == null) {
                    throw new IllegalStateException("A null value was found in the chain of nested properties");
                }
                type = getter.getReturnType();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access a nested property", e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj.getClass() == this.getClass()) {
            ClassMetadata other = (ClassMetadata)obj;
            return this.mappedClass.equals(other.mappedClass) && ((Object)this.allProperties).equals(other.allProperties) && ((Object)this.persistentProperties).equals(other.persistentProperties);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = hash * 31 + this.mappedClass.hashCode();
        hash = hash * 31 + ((Object)this.allProperties).hashCode();
        hash = hash * 31 + ((Object)this.persistentProperties).hashCode();
        return hash;
    }
}

