/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.metadata;

import com.vaadin.addon.jpacontainer.metadata.ClassMetadata;
import com.vaadin.addon.jpacontainer.metadata.PersistentPropertyMetadata;
import com.vaadin.addon.jpacontainer.metadata.PropertyMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityClassMetadata<T>
extends ClassMetadata<T> {
    private static final long serialVersionUID = -4870942071257502328L;
    private final String entityName;
    private String versionProperty;
    private String identifierProperty;

    EntityClassMetadata(Class<T> mappedClass, String entityName) {
        super(mappedClass);
        assert (entityName != null) : "entityName must not be null";
        this.entityName = entityName;
    }

    void setVersionPropertyName(String propertyName) {
        PropertyMetadata pm;
        if (!(propertyName == null || (pm = this.getProperty(propertyName)) != null && pm instanceof PersistentPropertyMetadata)) {
            throw new IllegalArgumentException("Invalid property");
        }
        this.versionProperty = propertyName;
    }

    void setIdentifierPropertyName(String propertyName) throws IllegalArgumentException {
        PropertyMetadata pm;
        if (!(propertyName == null || (pm = this.getProperty(propertyName)) != null && pm instanceof PersistentPropertyMetadata)) {
            throw new IllegalArgumentException("Invalid property");
        }
        this.identifierProperty = propertyName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean hasVersionProperty() {
        return this.versionProperty != null;
    }

    public PersistentPropertyMetadata getVersionProperty() {
        return this.versionProperty == null ? null : (PersistentPropertyMetadata)this.getProperty(this.versionProperty);
    }

    public boolean hasIdentifierProperty() {
        return this.identifierProperty != null;
    }

    public PersistentPropertyMetadata getIdentifierProperty() {
        return this.identifierProperty == null ? null : (PersistentPropertyMetadata)this.getProperty(this.identifierProperty);
    }

    public boolean hasEmbeddedIdentifier() {
        return this.hasIdentifierProperty() && this.getIdentifierProperty().getPropertyKind() == PersistentPropertyMetadata.PropertyKind.EMBEDDED;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            EntityClassMetadata other = (EntityClassMetadata)obj;
            return this.entityName.equals(other.entityName) && (this.versionProperty == null ? other.versionProperty == null : this.versionProperty.equals(other.versionProperty)) && (this.identifierProperty == null ? other.identifierProperty == null : this.identifierProperty.equals(other.identifierProperty));
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.entityName.hashCode();
        if (this.versionProperty != null) {
            hash = hash * 31 + this.versionProperty.hashCode();
        }
        if (this.identifierProperty != null) {
            hash = hash * 31 + this.identifierProperty.hashCode();
        }
        return hash;
    }
}

