/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.provider;

import com.vaadin.addon.jpacontainer.Filter;
import com.vaadin.addon.jpacontainer.SortBy;
import com.vaadin.addon.jpacontainer.provider.LocalEntityProvider;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachingSupport<T>
implements Serializable {
    private final LocalEntityProvider<T> entityProvider;
    private int maxCacheSize = 1000;
    private boolean cacheInUse = true;
    private boolean cloneCachedEntities = false;
    protected static final int CHUNK_SIZE = 150;
    protected static Filter NULL_FILTER = new Filter(){
        private static final long serialVersionUID = 6142104349424102387L;

        public String toQLString() {
            return "";
        }

        public String toQLString(Filter.PropertyIdPreprocessor propertyIdPreprocessor) {
            return "";
        }
    };
    public static final int MAX_FILTER_CACHE_SIZE = 10;
    public static final int MAX_SORTBY_CACHE_SIZE = 10;
    private Map<Object, T> entityCache;
    private Map<Filter, FilterCacheEntry> filterCache;

    public CachingSupport(LocalEntityProvider<T> entityProvider) {
        assert (entityProvider != null) : "entityProvider should not be null";
        this.entityProvider = entityProvider;
    }

    public synchronized void invalidate(Object entityId, boolean updated) {
        this.getEntityCache().remove(entityId);
        if (updated) {
            this.getFilterCache().clear();
        } else {
            for (FilterCacheEntry fce : this.getFilterCache().values()) {
                fce.invalidate(entityId);
            }
        }
    }

    public synchronized void entityAdded(T entity) {
        this.flush();
    }

    protected List<Object> getIds(Filter filter, List<SortBy> sortBy, int startFrom, int fetchMax) {
        Query query = this.entityProvider.createFilteredQuery("obj." + this.entityProvider.getEntityClassMetadata().getIdentifierProperty().getName(), "obj", filter, this.entityProvider.addPrimaryKeyToSortList(sortBy), false, null);
        query.setFirstResult(startFrom);
        if (fetchMax > 0) {
            query.setMaxResults(fetchMax);
        }
        return query.getResultList();
    }

    protected List<Object> getNextIds(Filter filter, List<SortBy> sortBy, Object startFrom, int fetchMax) {
        Query query = this.entityProvider.createSiblingQuery(startFrom, filter, sortBy, false);
        if (fetchMax > 0) {
            query.setMaxResults(fetchMax);
        }
        return query.getResultList();
    }

    protected List<Object> getPreviousIds(Filter filter, List<SortBy> sortBy, Object startFrom, int fetchMax) {
        Query query = this.entityProvider.createSiblingQuery(startFrom, filter, sortBy, true);
        if (fetchMax > 0) {
            query.setMaxResults(fetchMax);
        }
        return query.getResultList();
    }

    synchronized Map<Object, T> getEntityCache() {
        if (this.entityCache == null) {
            this.entityCache = new CacheMap<Object, T>(this.getMaxCacheSize());
        }
        return this.entityCache;
    }

    synchronized Map<Filter, FilterCacheEntry> getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = new CacheMap<Filter, FilterCacheEntry>(10);
        }
        return this.filterCache;
    }

    synchronized FilterCacheEntry getFilterCacheEntry(Filter filter) {
        FilterCacheEntry e;
        if (filter == null) {
            filter = NULL_FILTER;
        }
        if ((e = this.getFilterCache().get(filter)) == null) {
            e = new FilterCacheEntry(filter);
            this.getFilterCache().put(filter, e);
        }
        return e;
    }

    public synchronized void flush() {
        if (this.entityCache != null) {
            this.entityCache.clear();
        }
        if (this.filterCache != null) {
            this.filterCache.clear();
        }
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public boolean isCacheInUse() {
        return this.cacheInUse;
    }

    public void setCacheInUse(boolean cacheInUse) {
        this.cacheInUse = cacheInUse;
        if (!cacheInUse) {
            this.flush();
        }
    }

    public void setMaxCacheSize(int maxSize) {
        this.maxCacheSize = maxSize;
        this.entityCache = null;
        this.filterCache = null;
    }

    public boolean containsEntity(Object entityId, Filter filter) {
        if (!this.isCacheInUse()) {
            return this.entityProvider.doContainsEntity(entityId, filter);
        }
        return this.getFilterCacheEntry(filter).containsId(entityId);
    }

    public List<Object> getAllEntityIdentifiers(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetAllEntityIdentifiers(filter, sortBy);
        }
        return this.getFilterCacheEntry(filter).getAllIds(sortBy);
    }

    public synchronized T getEntity(Object entityId) {
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetEntity(entityId);
        }
        T entity = this.getEntityCache().get(entityId);
        if (entity == null) {
            entity = this.entityProvider.doGetEntity(entityId);
            if (entity == null) {
                return null;
            }
            this.getEntityCache().put(entityId, entity);
        }
        return this.cloneEntityIfNeeded(entity);
    }

    protected T cloneEntityIfNeeded(T entity) {
        if (this.isCloneCachedEntities()) {
            assert (entity instanceof Cloneable) : "entity is not cloneable";
            try {
                Method m = entity.getClass().getMethod("clone", new Class[0]);
                Object copy = m.invoke(entity, new Object[0]);
                return (T)copy;
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Could not clone entity", e);
            }
        }
        return entity;
    }

    public boolean isEntitiesDetached() {
        return this.isCacheInUse() || this.entityProvider.isEntitiesDetached();
    }

    public boolean isCloneCachedEntities() {
        return this.cloneCachedEntities;
    }

    public void setCloneCachedEntities(boolean clone) throws UnsupportedOperationException {
        if (!clone) {
            this.cloneCachedEntities = false;
        } else if (Cloneable.class.isAssignableFrom(this.entityProvider.getEntityClassMetadata().getMappedClass())) {
            this.cloneCachedEntities = true;
        } else {
            throw new UnsupportedOperationException("Entity class is not cloneable");
        }
    }

    public int getEntityCount(Filter filter) {
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetEntityCount(filter);
        }
        return this.getFilterCacheEntry(filter).getEntityCount();
    }

    public Object getEntityIdentifierAt(Filter filter, List<SortBy> sortBy, int index) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetEntityIdentifierAt(filter, sortBy, index);
        }
        return this.getFilterCacheEntry(filter).getIdAt(sortBy, index);
    }

    public Object getFirstEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetFirstEntityIdentifier(filter, sortBy);
        }
        return this.getFilterCacheEntry(filter).getFirstId(sortBy);
    }

    public Object getLastEntityIdentifier(Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetLastEntityIdentifier(filter, sortBy);
        }
        return this.getFilterCacheEntry(filter).getLastId(sortBy);
    }

    public Object getNextEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetNextEntityIdentifier(entityId, filter, sortBy);
        }
        return this.getFilterCacheEntry(filter).getNextId(entityId, sortBy);
    }

    public Object getPreviousEntityIdentifier(Object entityId, Filter filter, List<SortBy> sortBy) {
        if (sortBy == null) {
            sortBy = Collections.emptyList();
        }
        if (!this.isCacheInUse()) {
            return this.entityProvider.doGetPreviousEntityIdentifier(entityId, filter, sortBy);
        }
        return this.getFilterCacheEntry(filter).getPreviousId(entityId, sortBy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheSet<V>
    extends HashSet<V> {
        private static final long serialVersionUID = 2900939583997256189L;
        private LinkedList<V> addOrder = new LinkedList();
        private int maxSize;

        public CacheSet(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public synchronized boolean add(V e) {
            if (this.size() == this.maxSize) {
                this.remove(this.addOrder.removeFirst());
            }
            this.addOrder.add(e);
            return super.add(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CacheMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 2900939583997256189L;
        private LinkedList<K> addOrder = new LinkedList();
        private int maxSize;

        public CacheMap(int maxSize) {
            super(maxSize);
            this.maxSize = maxSize;
        }

        @Override
        public synchronized V put(K key, V value) {
            if (this.size() == this.maxSize) {
                this.remove(this.addOrder.removeFirst());
            }
            this.addOrder.add(key);
            return super.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterCacheEntry
    implements Serializable {
        private static final long serialVersionUID = -2978864194978758736L;
        private Filter filter;
        private Integer entityCount;
        public Map<List<SortBy>, IdListEntry> idListMap = new CacheMap<List<SortBy>, IdListEntry>(10);
        public Set<Object> idSet = new CacheSet<Object>(CachingSupport.this.getMaxCacheSize());

        public FilterCacheEntry(Filter filter) {
            this.filter = filter;
        }

        public synchronized int getEntityCount() {
            if (this.entityCount == null) {
                this.entityCount = CachingSupport.this.entityProvider.doGetEntityCount(this.getFilter());
            }
            return this.entityCount;
        }

        public synchronized boolean containsId(Object entityId) {
            if (!this.idSet.contains(entityId)) {
                if (CachingSupport.this.entityProvider.doContainsEntity(entityId, this.getFilter())) {
                    this.idSet.add(entityId);
                    return true;
                }
                return false;
            }
            return true;
        }

        public Object getFirstId(List<SortBy> sortBy) {
            return this.getIdAt(sortBy, 0);
        }

        public synchronized Object getNextId(Object entityId, List<SortBy> sortBy) {
            int index;
            IdListEntry entry = this.idListMap.get(sortBy);
            if (entry == null) {
                entry = new IdListEntry();
                entry.idList = new ArrayList();
                entry.listOffset = -1;
                this.idListMap.put(sortBy, entry);
            }
            if ((index = entry.idList.indexOf(entityId)) == -1) {
                entry.idList = new ArrayList<Object>(CachingSupport.this.getNextIds(this.getFilter(), sortBy, entityId, 150));
                if (entry.idList.isEmpty()) {
                    return null;
                }
                return entry.idList.get(0);
            }
            if (index == entry.idList.size() - 1) {
                if (CachingSupport.this.getMaxCacheSize() > -1 && entry.idList.size() + 150 > CachingSupport.this.getMaxCacheSize()) {
                    if (entry.idList.size() <= 150) {
                        entry.idList.clear();
                        index = -1;
                    } else {
                        entry.idList.subList(0, 150).clear();
                        index -= 150;
                    }
                }
                entry.idList.addAll(CachingSupport.this.getNextIds(this.getFilter(), sortBy, entityId, 150));
            }
            if (index + 1 == entry.idList.size()) {
                return null;
            }
            return entry.idList.get(index + 1);
        }

        public synchronized Object getPreviousId(Object entityId, List<SortBy> sortBy) {
            int index;
            IdListEntry entry = this.idListMap.get(sortBy);
            if (entry == null) {
                entry = new IdListEntry();
                entry.idList = new ArrayList();
                entry.listOffset = -1;
                this.idListMap.put(sortBy, entry);
            }
            if ((index = entry.idList.indexOf(entityId)) == -1) {
                List<Object> objects = CachingSupport.this.getPreviousIds(this.getFilter(), sortBy, entityId, 150);
                entry.idList = new ArrayList(objects.size());
                for (int i = objects.size() - 1; i >= 0; --i) {
                    entry.idList.add(objects.get(i));
                }
                if (entry.idList.isEmpty()) {
                    return null;
                }
                return entry.idList.get(entry.idList.size() - 1);
            }
            if (index == 0) {
                List<Object> objects = CachingSupport.this.getPreviousIds(this.getFilter(), sortBy, entityId, 150);
                if (objects.isEmpty()) {
                    return null;
                }
                Object theId = objects.get(0);
                ArrayList<Object> l = new ArrayList<Object>();
                for (int i = objects.size() - 1; i >= 0; --i) {
                    l.add(objects.get(i));
                }
                if (CachingSupport.this.getMaxCacheSize() > -1 && entry.idList.size() + 150 > CachingSupport.this.getMaxCacheSize()) {
                    if (entry.idList.size() > 150) {
                        l.addAll(entry.idList.subList(0, entry.idList.size() - 150));
                    }
                } else {
                    l.addAll(entry.idList);
                }
                entry.idList = l;
                return theId;
            }
            return entry.idList.get(index - 1);
        }

        public Object getLastId(List<SortBy> sortBy) {
            return this.getIdAt(sortBy, this.getEntityCount() - 1);
        }

        public synchronized void invalidate(Object entityId) {
            if (this.containsId(entityId)) {
                this.idListMap.clear();
                this.idSet.remove(entityId);
            }
        }

        public synchronized Object getIdAt(List<SortBy> sortBy, int index) {
            IdListEntry entry = this.idListMap.get(sortBy);
            if (entry == null) {
                entry = new IdListEntry();
                entry.idList = new ArrayList(300);
                this.idListMap.put(sortBy, entry);
            }
            if (!entry.containsAll && (entry.idList.isEmpty() || index < entry.listOffset || index >= entry.listOffset + entry.idList.size())) {
                if (entry.listOffset > -1 && index == entry.listOffset - 1) {
                    if (CachingSupport.this.getMaxCacheSize() > -1 && entry.idList.size() + 150 > CachingSupport.this.getMaxCacheSize()) {
                        if (entry.idList.size() <= 150) {
                            entry.idList.clear();
                        } else {
                            entry.idList.subList(entry.idList.size() - 150, entry.idList.size()).clear();
                        }
                    }
                    ArrayList<Object> l = new ArrayList<Object>(150 + entry.idList.size());
                    int startFrom = index - 150;
                    if (startFrom < 0) {
                        startFrom = 0;
                    }
                    l.addAll(CachingSupport.this.getIds(this.getFilter(), sortBy, startFrom, index - startFrom + 1));
                    l.addAll(entry.idList);
                    entry.idList = l;
                    entry.listOffset = startFrom;
                } else if (entry.listOffset > -1 && index == entry.listOffset + entry.idList.size()) {
                    if (CachingSupport.this.getMaxCacheSize() > -1 && entry.idList.size() + 150 > CachingSupport.this.getMaxCacheSize()) {
                        if (entry.idList.size() <= 150) {
                            entry.listOffset += entry.idList.size();
                            entry.idList.clear();
                        } else {
                            entry.idList.subList(0, 150).clear();
                            entry.listOffset += 150;
                        }
                    }
                    entry.idList.addAll(CachingSupport.this.getIds(this.getFilter(), sortBy, index, 150));
                } else {
                    entry.idList.clear();
                    entry.idList.addAll(CachingSupport.this.getIds(this.getFilter(), sortBy, index, 150));
                    entry.listOffset = index;
                }
            }
            int i = index - entry.listOffset;
            if (entry.idList.size() <= i) {
                return null;
            }
            return entry.idList.get(i);
        }

        public synchronized List<Object> getAllIds(List<SortBy> sortBy) {
            IdListEntry entry = this.idListMap.get(sortBy);
            if (entry == null) {
                entry = new IdListEntry();
                this.idListMap.put(sortBy, entry);
            }
            if (!entry.containsAll) {
                entry.idList = new ArrayList<Object>(CachingSupport.this.getIds(this.getFilter(), sortBy, 0, -1));
                entry.listOffset = 0;
                entry.containsAll = true;
            }
            return Collections.unmodifiableList(entry.idList);
        }

        public Filter getFilter() {
            return this.filter == NULL_FILTER ? null : this.filter;
        }
    }

    static class IdListEntry
    implements Serializable {
        private static final long serialVersionUID = -3552793234160831297L;
        public ArrayList<Object> idList;
        public int listOffset = 0;
        public boolean containsAll = false;

        IdListEntry() {
        }
    }
}

