/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.addon.jpacontainer.provider;

import com.vaadin.addon.jpacontainer.EntityProviderChangeEvent;
import com.vaadin.addon.jpacontainer.EntityProviderChangeListener;
import com.vaadin.addon.jpacontainer.EntityProviderChangeNotifier;
import com.vaadin.addon.jpacontainer.MutableEntityProvider;
import com.vaadin.addon.jpacontainer.provider.EntitiesAddedEvent;
import com.vaadin.addon.jpacontainer.provider.EntitiesRemovedEvent;
import com.vaadin.addon.jpacontainer.provider.EntitiesUpdatedEvent;
import com.vaadin.addon.jpacontainer.provider.LocalEntityProvider;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableLocalEntityProvider<T>
extends LocalEntityProvider<T>
implements MutableEntityProvider<T>,
EntityProviderChangeNotifier<T> {
    private static final long serialVersionUID = -6628293930338167750L;
    private boolean transactionsHandled = true;
    private LinkedList<WeakReference<EntityProviderChangeListener<T>>> listeners = new LinkedList();
    private boolean fireEntityProviderChangeEvent = true;

    public MutableLocalEntityProvider(Class<T> entityClass) {
        super(entityClass);
    }

    public MutableLocalEntityProvider(Class<T> entityClass, EntityManager entityManager) {
        super(entityClass, entityManager);
    }

    public void setTransactionsHandledByProvider(boolean transactionsHandled) {
        this.transactionsHandled = transactionsHandled;
    }

    public boolean isTransactionsHandledByProvider() {
        return this.transactionsHandled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInTransaction(Runnable operation) {
        assert (operation != null) : "operation must not be null";
        if (this.isTransactionsHandledByProvider()) {
            EntityTransaction et = this.getEntityManager().getTransaction();
            if (et.isActive()) {
                operation.run();
            } else {
                try {
                    et.begin();
                    operation.run();
                    et.commit();
                }
                finally {
                    if (et.isActive()) {
                        et.rollback();
                    }
                }
            }
        } else {
            operation.run();
        }
    }

    @Override
    public T addEntity(final T entity) {
        assert (entity != null);
        final Object[] entityA = new Object[1];
        this.runInTransaction(new Runnable(){

            public void run() {
                EntityManager em = MutableLocalEntityProvider.this.getEntityManager();
                entityA[0] = em.merge(entity);
                em.flush();
            }
        });
        Object dEntity = this.detachEntity(entityA[0]);
        this.fireEntityProviderChangeEvent(new EntitiesAddedEvent<Object>(this, dEntity));
        return (T)dEntity;
    }

    @Override
    public void removeEntity(final Object entityId) {
        assert (entityId != null);
        final Object[] entityA = new Object[1];
        this.runInTransaction(new Runnable(){

            public void run() {
                EntityManager em = MutableLocalEntityProvider.this.getEntityManager();
                Object entity = em.find(MutableLocalEntityProvider.this.getEntityClassMetadata().getMappedClass(), entityId);
                if (entity != null) {
                    em.remove(em.merge(entity));
                    em.flush();
                    entityA[0] = MutableLocalEntityProvider.this.detachEntity(entity);
                }
            }
        });
        if (entityA[0] != null) {
            this.fireEntityProviderChangeEvent(new EntitiesRemovedEvent<Object>(this, entityA[0]));
        }
    }

    @Override
    public T updateEntity(final T entity) {
        assert (entity != null) : "entity must not be null";
        final Object[] entityA = new Object[1];
        this.runInTransaction(new Runnable(){

            public void run() {
                EntityManager em = MutableLocalEntityProvider.this.getEntityManager();
                entityA[0] = em.merge(entity);
                em.flush();
            }
        });
        Object dEntity = this.detachEntity(entityA[0]);
        this.fireEntityProviderChangeEvent(new EntitiesUpdatedEvent<Object>(this, dEntity));
        return (T)dEntity;
    }

    @Override
    public void updateEntityProperty(final Object entityId, final String propertyName, final Object propertyValue) throws IllegalArgumentException {
        assert (entityId != null) : "entityId must not be null";
        assert (propertyName != null) : "propertyName must not be null";
        final Object[] entityA = new Object[1];
        this.runInTransaction(new Runnable(){

            public void run() {
                EntityManager em = MutableLocalEntityProvider.this.getEntityManager();
                Object entity = em.find(MutableLocalEntityProvider.this.getEntityClassMetadata().getMappedClass(), entityId);
                if (entity != null) {
                    em.refresh(entity);
                    MutableLocalEntityProvider.this.getEntityClassMetadata().setPropertyValue(entity, propertyName, propertyValue);
                    entity = em.merge(entity);
                    em.flush();
                    entityA[0] = MutableLocalEntityProvider.this.detachEntity(entity);
                }
            }
        });
        if (entityA[0] != null) {
            this.fireEntityProviderChangeEvent(new EntitiesUpdatedEvent<Object>(this, entityA[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(EntityProviderChangeListener<T> listener) {
        LinkedList<WeakReference<EntityProviderChangeListener<T>>> linkedList = this.listeners;
        synchronized (linkedList) {
            assert (listener != null) : "listener must not be null";
            this.listeners.add(new WeakReference<EntityProviderChangeListener<T>>(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(EntityProviderChangeListener<T> listener) {
        LinkedList<WeakReference<EntityProviderChangeListener<T>>> linkedList = this.listeners;
        synchronized (linkedList) {
            assert (listener != null) : "listener must not be null";
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                EntityProviderChangeListener l = (EntityProviderChangeListener)((WeakReference)it.next()).get();
                if (null != l && !listener.equals(l)) continue;
                it.remove();
            }
        }
    }

    protected void setFireEntityProviderChangeEvents(boolean fireEvents) {
        this.fireEntityProviderChangeEvent = fireEvents;
    }

    protected boolean isFireEntityProviderChangeEvent() {
        return this.fireEntityProviderChangeEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntityProviderChangeEvent(EntityProviderChangeEvent<T> event) {
        LinkedList list;
        LinkedList<WeakReference<EntityProviderChangeListener<T>>> linkedList = this.listeners;
        synchronized (linkedList) {
            assert (event != null) : "event must not be null";
            if (this.listeners.isEmpty() && !this.isFireEntityProviderChangeEvent()) {
                return;
            }
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                if (null != ((WeakReference)it.next()).get()) continue;
                it.remove();
            }
            list = (LinkedList)this.listeners.clone();
        }
        for (WeakReference ref : list) {
            EntityProviderChangeListener listener = (EntityProviderChangeListener)ref.get();
            if (null == listener) continue;
            listener.entityProviderChange(event);
        }
    }
}

