/*
 * Decompiled with CFR 0.152.
 */
package com.cucumber.listener;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.cucumber.listener.ExtentCucumberFormatter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Reporter {
    private static Map<String, Boolean> systemInfoKeyMap = new HashMap<String, Boolean>();

    private Reporter() {
    }

    public static ExtentHtmlReporter getExtentHtmlReport() {
        return ExtentCucumberFormatter.getExtentHtmlReport();
    }

    public static ExtentReports getExtentReport() {
        return ExtentCucumberFormatter.getExtentReport();
    }

    public static void loadXMLConfig(String xmlPath) {
        Reporter.getExtentHtmlReport().loadXMLConfig(xmlPath);
    }

    public static void loadXMLConfig(File file) {
        Reporter.getExtentHtmlReport().loadXMLConfig(file);
    }

    public static void addStepLog(String message) {
        Reporter.getCurrentStep().info(message);
    }

    public static void addScenarioLog(String message) {
        Reporter.getCurrentScenario().info(message);
    }

    public static void addScreenCaptureFromPath(String imagePath) throws IOException {
        Reporter.getCurrentStep().addScreenCaptureFromPath(imagePath);
    }

    public static void addScreenCaptureFromPath(String imagePath, String title) throws IOException {
        Reporter.getCurrentStep().addScreenCaptureFromPath(imagePath, title);
    }

    public static void addScreenCast(String screenCastPath) throws IOException {
        Reporter.getCurrentStep().addScreencastFromPath(screenCastPath);
    }

    public static void setSystemInfo(String key, String value) {
        if (systemInfoKeyMap.isEmpty() || !systemInfoKeyMap.containsKey(key)) {
            systemInfoKeyMap.put(key, false);
        }
        if (systemInfoKeyMap.get(key).booleanValue()) {
            return;
        }
        Reporter.getExtentReport().setSystemInfo(key, value);
        systemInfoKeyMap.put(key, true);
    }

    public static void setTestRunnerOutput(List<String> log) {
        Reporter.getExtentReport().setTestRunnerOutput(log);
    }

    public static void setTestRunnerOutput(String outputMessage) {
        Reporter.getExtentReport().setTestRunnerOutput(outputMessage);
    }

    public static void assignAuthor(String ... authorName) {
        Reporter.getCurrentScenario().assignAuthor(authorName);
    }

    private static ExtentTest getCurrentStep() {
        return ExtentCucumberFormatter.stepTestThreadLocal.get();
    }

    private static ExtentTest getCurrentScenario() {
        return ExtentCucumberFormatter.scenarioThreadLocal.get();
    }
}

