/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.config;

import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.connection.ConnectionProxyFactory;
import com.vladmihalcea.flexypool.event.EventListenerResolver;
import com.vladmihalcea.flexypool.metric.MetricsFactory;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategy;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategyFactory;
import com.vladmihalcea.flexypool.strategy.ConnectionAcquiringStrategyFactoryResolver;
import com.vladmihalcea.flexypool.strategy.MetricNamingStrategy;
import com.vladmihalcea.flexypool.util.ClassLoaderUtils;
import com.vladmihalcea.flexypool.util.JndiUtils;
import com.vladmihalcea.flexypool.util.LazyJndiResolver;
import com.vladmihalcea.flexypool.util.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyLoader.class);
    public static final String PROPERTIES_FILE_PATH = "flexy.pool.properties.path";
    public static final String PROPERTIES_FILE_NAME = "flexy-pool.properties";
    private final Properties properties = new Properties();

    public PropertyLoader() {
        this.load();
    }

    public PropertyLoader(Properties overridingProperties) {
        this();
        this.properties.putAll((Map<?, ?>)overridingProperties);
    }

    private void load() {
        InputStream propertiesInputStream = null;
        try {
            propertiesInputStream = this.propertiesInputStream();
            if (propertiesInputStream == null) {
                throw new IllegalArgumentException("The properties file could not be loaded!");
            }
            this.properties.load(propertiesInputStream);
        }
        catch (IOException e) {
            LOGGER.error("Can't load properties", (Throwable)e);
        }
        finally {
            try {
                if (propertiesInputStream != null) {
                    propertiesInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Can't close the properties InputStream", (Throwable)e);
            }
        }
    }

    private InputStream propertiesInputStream() throws IOException {
        String propertiesFilePath = System.getProperty(PROPERTIES_FILE_PATH);
        URL propertiesFileUrl = null;
        if (propertiesFilePath != null) {
            block6: {
                try {
                    propertiesFileUrl = new URL(propertiesFilePath);
                }
                catch (MalformedURLException ignore) {
                    File f;
                    propertiesFileUrl = ClassLoaderUtils.getResource(propertiesFilePath);
                    if (propertiesFileUrl != null || !(f = new File(propertiesFilePath)).exists() || !f.isFile()) break block6;
                    try {
                        propertiesFileUrl = f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error("The property " + propertiesFilePath + " can't be resolved to either a URL/a Classpath resource or a File");
                    }
                }
            }
            if (propertiesFileUrl != null) {
                return propertiesFileUrl.openStream();
            }
        }
        return ClassLoaderUtils.getResourceAsStream(PROPERTIES_FILE_NAME);
    }

    public String getUniqueName() {
        return this.properties.getProperty(PropertyKey.DATA_SOURCE_UNIQUE_NAME.getKey());
    }

    public <T extends DataSource> T getDataSource() {
        DataSource dataSource = (DataSource)this.jndiLookup(PropertyKey.DATA_SOURCE_JNDI_NAME);
        if (dataSource != null) {
            return (T)dataSource;
        }
        dataSource = (DataSource)this.instantiateClass(PropertyKey.DATA_SOURCE_CLASS_NAME);
        if (dataSource == null) {
            throw new IllegalArgumentException("The " + (Object)((Object)PropertyKey.DATA_SOURCE_CLASS_NAME) + " property is mandatory!");
        }
        return (T)this.applyDataSourceProperties(dataSource);
    }

    private <T extends DataSource> T applyDataSourceProperties(T dataSource) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            String propertyKey = PropertyKey.DATA_SOURCE_PROPERTY.getKey();
            if (!key.startsWith(propertyKey)) continue;
            String dataSourceProperty = key.substring(propertyKey.length());
            ReflectionUtils.invokeSetter(dataSource, dataSourceProperty, value);
        }
        return dataSource;
    }

    public <T extends DataSource> PoolAdapterFactory<T> getPoolAdapterFactory() {
        return (PoolAdapterFactory)this.instantiateClass(PropertyKey.POOL_ADAPTER_FACTORY);
    }

    public MetricsFactory getMetricsFactory() {
        return (MetricsFactory)this.instantiateClass(PropertyKey.POOL_METRICS_FACTORY);
    }

    public ConnectionProxyFactory getConnectionProxyFactory() {
        return (ConnectionProxyFactory)this.instantiateClass(PropertyKey.POOL_CONNECTION_PROXY_FACTORY);
    }

    public Integer getMetricLogReporterMillis() {
        return this.integerProperty(PropertyKey.POOL_METRICS_REPORTER_LOG_MILLIS);
    }

    public Boolean isJmxEnabled() {
        return this.booleanProperty(PropertyKey.POOL_METRICS_REPORTER_JMX_ENABLE);
    }

    public Boolean isJmxAutoStart() {
        return this.booleanProperty(PropertyKey.POOL_METRICS_REPORTER_JMX_AUTO_START);
    }

    public MetricNamingStrategy getMetricNamingStrategy() {
        return (MetricNamingStrategy)this.instantiateClass(PropertyKey.POOL_METRICS_NAMING_STRATEGY);
    }

    public boolean isJndiLazyLookup() {
        return Boolean.TRUE.equals(this.booleanProperty(PropertyKey.DATA_SOURCE_JNDI_LAZY_LOOKUP));
    }

    public <T extends DataSource> List<ConnectionAcquiringStrategyFactory<? extends ConnectionAcquiringStrategy, T>> getConnectionAcquiringStrategyFactories() {
        ConnectionAcquiringStrategyFactoryResolver connectionAcquiringStrategyFactoryResolver = (ConnectionAcquiringStrategyFactoryResolver)this.instantiateClass(PropertyKey.POOL_STRATEGIES_FACTORY_RESOLVER);
        if (connectionAcquiringStrategyFactoryResolver != null) {
            return connectionAcquiringStrategyFactoryResolver.resolveFactories();
        }
        return Collections.emptyList();
    }

    public EventListenerResolver getEventListenerResolver() {
        return (EventListenerResolver)this.instantiateClass(PropertyKey.POOL_EVENT_LISTENER_RESOLVER);
    }

    public Long getConnectionAcquireTimeThresholdMillis() {
        return this.longProperty(PropertyKey.POOL_TIME_THRESHOLD_CONNECTION_ACQUIRE);
    }

    public Long getConnectionLeaseTimeThresholdMillis() {
        return this.longProperty(PropertyKey.POOL_TIME_THRESHOLD_CONNECTION_LEASE);
    }

    private <T> T instantiateClass(PropertyKey propertyKey) {
        T object = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            try {
                Class clazz = ClassLoaderUtils.loadClass(property);
                LOGGER.debug("Instantiate {}", clazz);
                object = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Couldn't load the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("Couldn't instantiate the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Couldn't access the " + property + " class given by the " + (Object)((Object)propertyKey) + " property", (Throwable)e);
            }
        }
        return object;
    }

    private Integer integerProperty(PropertyKey propertyKey) {
        Integer value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Integer.valueOf(property);
        }
        return value;
    }

    private Long longProperty(PropertyKey propertyKey) {
        Long value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Long.valueOf(property);
        }
        return value;
    }

    private Boolean booleanProperty(PropertyKey propertyKey) {
        Boolean value = null;
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            value = Boolean.valueOf(property);
        }
        return value;
    }

    private <T> T jndiLookup(PropertyKey propertyKey) {
        String property = this.properties.getProperty(propertyKey.getKey());
        if (property != null) {
            return this.isJndiLazyLookup() ? LazyJndiResolver.newInstance(property, DataSource.class) : JndiUtils.lookup(property);
        }
        return null;
    }

    public static enum PropertyKey {
        DATA_SOURCE_UNIQUE_NAME("flexy.pool.data.source.unique.name"),
        DATA_SOURCE_JNDI_NAME("flexy.pool.data.source.jndi.name"),
        DATA_SOURCE_JNDI_LAZY_LOOKUP("flexy.pool.data.source.jndi.lazy.lookup"),
        DATA_SOURCE_CLASS_NAME("flexy.pool.data.source.class.name"),
        DATA_SOURCE_PROPERTY("flexy.pool.data.source.property."),
        POOL_ADAPTER_FACTORY("flexy.pool.adapter.factory"),
        POOL_METRICS_FACTORY("flexy.pool.metrics.factory"),
        POOL_CONNECTION_PROXY_FACTORY("flexy.pool.connection.proxy.factory"),
        POOL_METRICS_REPORTER_LOG_MILLIS("flexy.pool.metrics.reporter.log.millis"),
        POOL_METRICS_REPORTER_JMX_ENABLE("flexy.pool.metrics.reporter.jmx.enable"),
        POOL_METRICS_REPORTER_JMX_AUTO_START("flexy.pool.metrics.reporter.jmx.auto.start"),
        POOL_METRICS_NAMING_STRATEGY("flexy.pool.metrics.naming.strategy"),
        POOL_STRATEGIES_FACTORY_RESOLVER("flexy.pool.strategies.factory.resolver"),
        POOL_EVENT_LISTENER_RESOLVER("flexy.pool.event.listener.resolver"),
        POOL_TIME_THRESHOLD_CONNECTION_ACQUIRE("flexy.pool.time.threshold.connection.acquire"),
        POOL_TIME_THRESHOLD_CONNECTION_LEASE("flexy.pool.time.threshold.connection.lease");

        private final String key;

        private PropertyKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

