/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.event;

import com.vladmihalcea.flexypool.event.Event;
import com.vladmihalcea.flexypool.event.EventListener;
import com.vladmihalcea.flexypool.event.EventListenerResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventPublisher {
    private Map<Class<? extends Event>, EventListener<? extends Event>> eventListenerMap = new HashMap<Class<? extends Event>, EventListener<? extends Event>>();

    public static EventPublisher newInstance(EventListenerResolver eventListenerResolver) {
        List<EventListener<? extends Event>> eventListeners = eventListenerResolver != null ? eventListenerResolver.resolveListeners() : null;
        return eventListeners != null && !eventListeners.isEmpty() ? new EventPublisher(eventListeners) : new EventPublisher();
    }

    public EventPublisher(List<? extends EventListener<? extends Event>> eventListeners) {
        for (EventListener<? extends Event> eventListener : eventListeners) {
            Class<? extends Event> eventClass = eventListener.listensTo();
            this.eventListenerMap.put(eventClass, eventListener);
        }
    }

    protected EventPublisher() {
        this(new ArrayList(0));
    }

    public <E extends Event> void publish(E event) {
        EventListener<E> eventListener;
        if (!this.eventListenerMap.isEmpty() && (eventListener = this.getEventListener(event)) != null) {
            eventListener.on(event);
        }
    }

    private <E extends Event> EventListener<E> getEventListener(E event) {
        EventListener<? extends Event> eventListener = this.eventListenerMap.get(event.getClass());
        return eventListener;
    }
}

