/*
 * Copyright 2002-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.webauthn4j.metadata.anchor;

import com.webauthn4j.anchor.TrustAnchorRepository;
import com.webauthn4j.data.attestation.authenticator.AAGUID;

import java.security.cert.TrustAnchor;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AggregatingTrustAnchorRepository implements TrustAnchorRepository {

    List<TrustAnchorRepository> repositories;

    public AggregatingTrustAnchorRepository(TrustAnchorRepository... repositories) {
        this.repositories = Arrays.asList(repositories);
    }

    @Override
    public Set<TrustAnchor> find(AAGUID aaguid) {
        return repositories.stream()
                .flatMap(repository -> repository.find(aaguid).stream())
                .collect(Collectors.toSet());
    }

    @Override
    public Set<TrustAnchor> find(byte[] attestationCertificateKeyIdentifier) {
        return repositories.stream()
                .flatMap(repository -> repository.find(attestationCertificateKeyIdentifier).stream())
                .collect(Collectors.toSet());
    }
}
