/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.anchor;

import com.webauthn4j.anchor.CachingTrustAnchorsProviderBase;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class CertFileResourcesTrustAnchorsProvider
extends CachingTrustAnchorsProviderBase
implements InitializingBean {
    private List<Resource> certificates;

    public CertFileResourcesTrustAnchorsProvider() {
    }

    public CertFileResourcesTrustAnchorsProvider(List<Resource> certificates) {
        this.certificates = certificates;
    }

    public void afterPropertiesSet() {
        this.checkConfig();
    }

    private void checkConfig() {
        AssertUtil.notNull(this.certificates, (String)"certificates must not be null");
    }

    protected Map<AAGUID, Set<TrustAnchor>> loadTrustAnchors() {
        this.checkConfig();
        Set trustAnchors = this.certificates.stream().map(this::loadTrustAnchor).collect(Collectors.toSet());
        return Collections.singletonMap(AAGUID.NULL, trustAnchors);
    }

    public List<Resource> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<Resource> certificates) {
        this.certificates = certificates;
    }

    TrustAnchor loadTrustAnchor(Resource certificate) {
        try {
            X509Certificate x509Certificate = CertificateUtil.generateX509Certificate((InputStream)certificate.getInputStream());
            return new TrustAnchor(x509Certificate, null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

