/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.springframework.security.authenticator;

import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticator;
import com.webauthn4j.springframework.security.authenticator.WebAuthnAuthenticatorManager;
import com.webauthn4j.springframework.security.exception.CredentialIdNotFoundException;
import com.webauthn4j.springframework.security.exception.PrincipalNotFoundException;
import com.webauthn4j.util.Base64UrlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InMemoryWebAuthnAuthenticatorManager
implements WebAuthnAuthenticatorManager {
    private Map<Object, Map<String, WebAuthnAuthenticator>> map = new HashMap<Object, Map<String, WebAuthnAuthenticator>>();

    @Override
    public void updateCounter(byte[] credentialId, long counter) throws CredentialIdNotFoundException {
        WebAuthnAuthenticator webAuthnAuthenticator = this.loadAuthenticatorByCredentialId(credentialId);
        webAuthnAuthenticator.setCounter(counter);
    }

    @Override
    public WebAuthnAuthenticator loadAuthenticatorByCredentialId(byte[] credentialId) throws CredentialIdNotFoundException {
        return this.map.values().stream().map(innerMap -> (WebAuthnAuthenticator)innerMap.get(Base64UrlUtil.encodeToString((byte[])credentialId))).filter(Objects::nonNull).findFirst().orElseThrow(() -> new CredentialIdNotFoundException("credentialId not found."));
    }

    @Override
    public List<WebAuthnAuthenticator> loadAuthenticatorsByUserPrincipal(Object userPrincipal) {
        Map<String, WebAuthnAuthenticator> innerMap = this.map.get(userPrincipal);
        if (innerMap == null || innerMap.isEmpty()) {
            throw new PrincipalNotFoundException("principal not found.");
        }
        return Collections.unmodifiableList(new ArrayList<WebAuthnAuthenticator>(innerMap.values()));
    }

    @Override
    public void createAuthenticator(WebAuthnAuthenticator webAuthnAuthenticator) {
        Object userPrincipal = webAuthnAuthenticator.getUserPrincipal();
        if (!this.map.containsKey(userPrincipal)) {
            this.map.put(userPrincipal, new HashMap());
        }
        this.map.get(userPrincipal).put(Base64UrlUtil.encodeToString((byte[])webAuthnAuthenticator.getAttestedCredentialData().getCredentialId()), webAuthnAuthenticator);
    }

    @Override
    public void deleteAuthenticator(byte[] credentialId) {
        for (Map.Entry<Object, Map<String, WebAuthnAuthenticator>> entry : this.map.entrySet()) {
            WebAuthnAuthenticator webAuthnAuthenticator = entry.getValue().get(Base64UrlUtil.encodeToString((byte[])credentialId));
            if (webAuthnAuthenticator == null) continue;
            entry.getValue().remove(Base64UrlUtil.encodeToString((byte[])credentialId));
            return;
        }
        throw new CredentialIdNotFoundException("credentialId not found.");
    }

    @Override
    public boolean authenticatorExists(byte[] credentialId) {
        return this.map.values().stream().anyMatch(innerMap -> innerMap.get(Base64UrlUtil.encodeToString((byte[])credentialId)) != null);
    }
}

